/*
 * Decompiled with CFR 0.152.
 */
package demos.es2.perftst;

import com.jogamp.math.util.SyncBuffer;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderState;
import demos.es2.perftst.PerfModule;

public class Perftst
implements MouseListener,
GLEventListener {
    private GLWindow window;
    private boolean quit = false;
    private PerfModule pmod;
    private ShaderState st;
    private PMVMatrix pmvMatrix;
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;

    public void mouseClicked(MouseEvent mouseEvent) {
        this.quit = true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
    }

    private void run(int n, PerfModule perfModule) {
        this.pmod = perfModule;
        System.err.println("Perftst.run()");
        try {
            GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getGL2ES2());
            gLCapabilities.setRedBits(5);
            gLCapabilities.setGreenBits(6);
            gLCapabilities.setBlueBits(5);
            gLCapabilities.setDepthBits(16);
            Window window = null;
            if (0 != (n & USE_AWT)) {
                Display display = NewtFactory.createDisplay((String)".awt", null);
                Screen screen = NewtFactory.createScreen((Display)display, (int)0);
                window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities);
                this.window = GLWindow.create((Window)window);
            } else {
                this.window = GLWindow.create((GLCapabilitiesImmutable)gLCapabilities);
            }
            this.window.addMouseListener((MouseListener)this);
            this.window.addGLEventListener((GLEventListener)this);
            this.window.setSize(800, 480);
            this.window.setFullscreen(true);
            this.window.setVisible(true);
            this.window.display();
            this.window.destroy();
            System.out.println("Perftst shut down cleanly.");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.setAutoSwapBufferMode(false);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        System.err.println("Entering initialization");
        System.err.println("GL_VERSION=" + gL2ES2.glGetString(7938));
        System.err.println("GL_EXTENSIONS:");
        System.err.println("  " + gL2ES2.glGetString(7939));
        this.pmvMatrix = new PMVMatrix();
        this.st = this.pmod.initShaderState(gL2ES2);
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        if (!this.st.uniform(gL2ES2, new GLUniformData("mgl_PMVMatrix", 4, 4, (SyncBuffer)this.pmvMatrix.getSyncPMv()))) {
            throw new GLException("Error setting PMVMatrix in shader: " + this.st);
        }
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        this.st.useProgram(gL2ES2, false);
        System.out.println(this.st);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.st.useProgram(gL2ES2, true);
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glOrthof(0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 100.0f);
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        GLUniformData gLUniformData = this.st.getUniform("mgl_PMVMatrix");
        if (null != gLUniformData) {
            this.st.uniform(gL2ES2, gLUniformData);
        }
        this.st.useProgram(gL2ES2, false);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.st.destroy(gL2ES2);
        this.st = null;
        this.pmvMatrix = null;
        this.quit = true;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.pmod.run(gLAutoDrawable, 10);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        int n = USE_NEWT;
        String string = "demos.es2.perftst.PerfVBOLoad";
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (stringArray[i].equals("-awt")) {
                n |= USE_AWT;
            }
            if (!stringArray[i].equals("-test") || i + 1 >= stringArray.length) continue;
            string = stringArray[i + 1];
        }
        try {
            PerfModule perfModule = (PerfModule)Class.forName(string).newInstance();
            new Perftst().run(n, perfModule);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

