/*
 * Decompiled with CFR 0.152.
 */
package demos.fullscreen;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import demos.fullscreen.FullscreenWorkaround;
import demos.gears.Gears;
import demos.util.ScreenResSelector;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GearsFullscreen {
    private GraphicsDevice dev;
    private DisplayMode origMode;
    private boolean fullScreen;
    private Frame frame;
    private Animator animator;
    private int initWidth = 300;
    private int initHeight = 300;

    public static void main(String[] stringArray) {
        new GearsFullscreen().run(stringArray);
    }

    public void run(String[] stringArray) {
        this.dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.origMode = this.dev.getDisplayMode();
        DisplayMode displayMode = null;
        if (this.dev.isFullScreenSupported()) {
            displayMode = ScreenResSelector.showSelectionDialog();
            if (displayMode != null) {
                this.initWidth = displayMode.getWidth();
                this.initHeight = displayMode.getHeight();
            }
        } else {
            System.err.println("NOTE: full-screen mode not supported; running in window instead");
        }
        this.frame = new Frame("Gear Demo");
        if (displayMode != null) {
            this.frame.setUndecorated(true);
        }
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new FullscreenWorkaround(this.initWidth, this.initHeight));
        this.frame.add((Component)gLCanvas);
        this.frame.setSize(this.initWidth, this.initHeight);
        this.animator = new Animator((GLAutoDrawable)gLCanvas);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GearsFullscreen.this.runExit();
            }
        });
        this.frame.setVisible(true);
        if (this.dev.isFullScreenSupported() && displayMode != null) {
            this.dev.setFullScreenWindow(this.frame);
            if (this.dev.isDisplayChangeSupported()) {
                this.dev.setDisplayMode(displayMode);
                this.fullScreen = true;
            } else {
                this.dev.setFullScreenWindow(null);
                final Frame frame = this.frame;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            frame.setVisible(false);
                            frame.setUndecorated(false);
                            frame.setVisible(true);
                            frame.setSize(GearsFullscreen.this.initWidth, GearsFullscreen.this.initHeight);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.err.println("NOTE: was not able to change display mode; full-screen disabled");
            }
        }
        this.animator.start();
    }

    public void runExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GearsFullscreen.this.animator.stop();
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (GearsFullscreen.this.fullScreen) {
                                try {
                                    GearsFullscreen.this.dev.setDisplayMode(GearsFullscreen.this.origMode);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    GearsFullscreen.this.dev.setFullScreenWindow(null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                GearsFullscreen.this.fullScreen = false;
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.exit(0);
            }
        }).start();
    }
}

