/*
 * Decompiled with CFR 0.152.
 */
package demos.fullscreen;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.util.Animator;
import demos.fullscreen.FullscreenWorkaround;
import demos.jgears.JGears;
import demos.util.ScreenResSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class JGearsFullscreen {
    private GraphicsDevice dev;
    private DisplayMode origMode;
    private boolean fullScreen;
    private JFrame frame;
    private Animator animator;
    private int initWidth = 300;
    private int initHeight = 300;

    public static void main(String[] stringArray) {
        new JGearsFullscreen().run(stringArray);
    }

    public void run(String[] stringArray) {
        this.dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.origMode = this.dev.getDisplayMode();
        DisplayMode displayMode = null;
        if (this.dev.isFullScreenSupported()) {
            displayMode = ScreenResSelector.showSelectionDialog();
            if (displayMode != null) {
                this.initWidth = displayMode.getWidth();
                this.initHeight = displayMode.getHeight();
            }
        } else {
            System.err.println("NOTE: full-screen mode not supported; running in window instead");
        }
        this.frame = new JFrame("Gear Demo");
        if (displayMode != null) {
            this.frame.setUndecorated(true);
        }
        JGears jGears = new JGears();
        jGears.addGLEventListener(new FullscreenWorkaround(this.initWidth, this.initHeight));
        this.frame.getContentPane().setLayout(new BorderLayout());
        JButton jButton = new JButton("West");
        jButton.setToolTipText("West ToolTip");
        this.frame.getContentPane().add((Component)jButton, "West");
        jButton = new JButton("East");
        jButton.setToolTipText("East ToolTip");
        this.frame.getContentPane().add((Component)jButton, "East");
        jButton = new JButton("North");
        jButton.setToolTipText("North ToolTip");
        this.frame.getContentPane().add((Component)jButton, "North");
        jButton = new JButton("South");
        jButton.setToolTipText("South ToolTip");
        this.frame.getContentPane().add((Component)jButton, "South");
        this.frame.getContentPane().add((Component)((Object)jGears), "Center");
        this.frame.setSize(this.initWidth, this.initHeight);
        this.animator = new Animator((GLAutoDrawable)jGears);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JGearsFullscreen.this.runExit();
            }
        });
        this.frame.setVisible(true);
        if (this.dev.isFullScreenSupported() && displayMode != null) {
            this.dev.setFullScreenWindow(this.frame);
            if (this.dev.isDisplayChangeSupported()) {
                this.dev.setDisplayMode(displayMode);
                this.fullScreen = true;
            } else {
                this.dev.setFullScreenWindow(null);
                final JFrame jFrame = this.frame;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            jFrame.setVisible(false);
                            jFrame.setUndecorated(false);
                            jFrame.setVisible(true);
                            jFrame.setSize(JGearsFullscreen.this.initWidth, JGearsFullscreen.this.initHeight);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.err.println("NOTE: was not able to change display mode; full-screen disabled");
            }
        }
        this.animator.start();
    }

    public void runExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JGearsFullscreen.this.animator.stop();
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (JGearsFullscreen.this.fullScreen) {
                                try {
                                    JGearsFullscreen.this.dev.setDisplayMode(JGearsFullscreen.this.origMode);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    JGearsFullscreen.this.dev.setFullScreenWindow(null);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                JGearsFullscreen.this.fullScreen = false;
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.exit(0);
            }
        }).start();
    }
}

