/*
 * Decompiled with CFR 0.152.
 */
package demos.gamma;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.Gamma;
import demos.gears.Gears;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TestGamma
implements GLEventListener {
    static float gamma = 1.0f;
    static float brightness = 0.0f;
    static float contrast = 0.0f;

    private static void usage() {
        System.out.println("Usage: java TestGamma [gamma value] [brightness value] [contrast value]");
        System.exit(1);
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        if (!Gamma.setDisplayGamma((GLAutoDrawable)gLAutoDrawable, (float)gamma, (float)brightness, (float)contrast)) {
            System.err.println("Unable to change display gamma, brightness, and contrast");
        }
        System.err.println("init: Gamma.setDisplayGamma");
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Gamma.resetDisplayGamma((GLAutoDrawable)gLAutoDrawable);
        System.err.println("dispose: Gamma.resetDisplayGamma");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            TestGamma.usage();
        }
        try {
            gamma = Float.parseFloat(stringArray[0]);
            brightness = Float.parseFloat(stringArray[1]);
            contrast = Float.parseFloat(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            TestGamma.usage();
        }
        Frame frame = new Frame("Gear and Gamma Demo");
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new TestGamma());
        frame.add((Component)gLCanvas);
        frame.setSize(300, 300);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        frame.setVisible(true);
        animator.start();
    }
}

