/*
 * Decompiled with CFR 0.152.
 */
package demos.gears;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Gears
implements GLEventListener {
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private final float view_rotz = 0.0f;
    private int gear1 = 0;
    private int gear2 = 0;
    private int gear3 = 0;
    private float angle = 0.0f;
    private final int swapInterval;
    private int prevMouseX;
    private int prevMouseY;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Gear Demo");
        frame.setSize(300, 300);
        frame.setLayout(new BorderLayout());
        final Animator animator = new Animator();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        GLCanvas gLCanvas = new GLCanvas();
        animator.add((GLAutoDrawable)gLCanvas);
        Gears gears = new Gears();
        gLCanvas.addGLEventListener((GLEventListener)gears);
        frame.add((Component)gLCanvas, "Center");
        frame.validate();
        frame.setVisible(true);
        animator.start();
    }

    public Gears(int n) {
        this.swapInterval = n;
    }

    public Gears() {
        this.swapInterval = 1;
    }

    public void setGears(int n, int n2, int n3) {
        this.gear1 = n;
        this.gear2 = n2;
        this.gear3 = n3;
    }

    public int getGear1() {
        return this.gear1;
    }

    public int getGear2() {
        return this.gear2;
    }

    public int getGear3() {
        return this.gear3;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Gears: Init: " + gLAutoDrawable);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2.getClass().getName());
        System.err.println("GL_VENDOR: " + gL2.glGetString(7936));
        System.err.println("GL_RENDERER: " + gL2.glGetString(7937));
        System.err.println("GL_VERSION: " + gL2.glGetString(7938));
        float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
        float[] fArray2 = new float[]{0.8f, 0.1f, 0.0f, 0.7f};
        float[] fArray3 = new float[]{0.0f, 0.8f, 0.2f, 0.7f};
        float[] fArray4 = new float[]{0.2f, 0.2f, 1.0f, 0.7f};
        gL2.glLightfv(16384, 4611, fArray, 0);
        gL2.glEnable(2884);
        gL2.glEnable(2896);
        gL2.glEnable(16384);
        gL2.glEnable(2929);
        if (0 >= this.gear1) {
            this.gear1 = gL2.glGenLists(1);
            gL2.glNewList(this.gear1, 4864);
            gL2.glMaterialfv(1028, 5634, fArray2, 0);
            Gears.gear(gL2, 1.0f, 4.0f, 1.0f, 20, 0.7f);
            gL2.glEndList();
            System.err.println("gear1 list created: " + this.gear1);
        } else {
            System.err.println("gear1 list reused: " + this.gear1);
        }
        if (0 >= this.gear2) {
            this.gear2 = gL2.glGenLists(1);
            gL2.glNewList(this.gear2, 4864);
            gL2.glMaterialfv(1028, 5634, fArray3, 0);
            Gears.gear(gL2, 0.5f, 2.0f, 2.0f, 10, 0.7f);
            gL2.glEndList();
            System.err.println("gear2 list created: " + this.gear2);
        } else {
            System.err.println("gear2 list reused: " + this.gear2);
        }
        if (0 >= this.gear3) {
            this.gear3 = gL2.glGenLists(1);
            gL2.glNewList(this.gear3, 4864);
            gL2.glMaterialfv(1028, 5634, fArray4, 0);
            Gears.gear(gL2, 1.3f, 2.0f, 0.5f, 10, 0.7f);
            gL2.glEndList();
            System.err.println("gear3 list created: " + this.gear3);
        } else {
            System.err.println("gear3 list reused: " + this.gear3);
        }
        gL2.glEnable(2977);
        GearsMouseAdapter gearsMouseAdapter = new GearsMouseAdapter();
        GearsKeyAdapter gearsKeyAdapter = new GearsKeyAdapter();
        if (gLAutoDrawable instanceof Window) {
            Window window = (Window)gLAutoDrawable;
            window.addMouseListener((MouseListener)gearsMouseAdapter);
            window.addKeyListener((KeyListener)gearsKeyAdapter);
        } else if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof Component) {
            Component component = (Component)gLAutoDrawable;
            new AWTMouseAdapter((MouseListener)gearsMouseAdapter, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
            new AWTKeyAdapter((KeyListener)gearsKeyAdapter, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        System.err.println("Gears: Reshape " + n + "/" + n2 + " " + n3 + "x" + n4);
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.setSwapInterval(this.swapInterval);
        float f = (float)n4 / (float)n3;
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 5.0, 60.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glTranslatef(0.0f, 0.0f, -40.0f);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        System.err.println("Gears: Dispose");
        this.setGears(0, 0, 0);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.angle += 2.0f;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
            gL2.glClear(256);
        } else {
            gL2.glClear(16640);
        }
        gL2.glPushMatrix();
        gL2.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glPushMatrix();
        gL2.glTranslatef(-3.0f, -2.0f, 0.0f);
        gL2.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear1);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(3.1f, -2.0f, 0.0f);
        gL2.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear2);
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glTranslatef(-3.1f, 4.2f, 0.0f);
        gL2.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
        gL2.glCallList(this.gear3);
        gL2.glPopMatrix();
        gL2.glPopMatrix();
    }

    public static void gear(GL2 gL2, float f, float f2, float f3, int n, float f4) {
        float f5;
        int n2;
        float f6 = f;
        float f7 = f2 - f4 / 2.0f;
        float f8 = f2 + f4 / 2.0f;
        float f9 = (float)Math.PI * 2 / (float)n / 4.0f;
        gL2.glShadeModel(7424);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            if (n2 >= n) continue;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            float f10 = f8 * (float)Math.cos(f5 + f9) - f7 * (float)Math.cos(f5);
            float f11 = f8 * (float)Math.sin(f5 + f9) - f7 * (float)Math.sin(f5);
            float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            gL2.glNormal3f(f11 /= f12, -(f10 /= f12), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            f10 = f7 * (float)Math.cos(f5 + 3.0f * f9) - f8 * (float)Math.cos(f5 + 2.0f * f9);
            f11 = f7 * (float)Math.sin(f5 + 3.0f * f9) - f8 * (float)Math.sin(f5 + 2.0f * f9);
            gL2.glNormal3f(f11, -f10, 0.0f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
        }
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), f3 * 0.5f);
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), -f3 * 0.5f);
        gL2.glEnd();
        gL2.glShadeModel(7425);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glNormal3f(-((float)Math.cos(f5)), -((float)Math.sin(f5)), 0.0f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
        }
        gL2.glEnd();
    }

    class GearsMouseAdapter
    extends MouseAdapter {
        GearsMouseAdapter() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Gears.this.prevMouseX = mouseEvent.getX();
            Gears.this.prevMouseY = mouseEvent.getY();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            Object object2 = mouseEvent.getSource();
            if (object2 instanceof Window) {
                object = (Window)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (object2 instanceof GLAutoDrawable) {
                object = (GLAutoDrawable)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n3 = ((Component)object).getWidth();
                n4 = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            float f = 360.0f * ((float)(n - Gears.this.prevMouseX) / (float)n3);
            float f2 = 360.0f * ((float)(Gears.this.prevMouseY - n2) / (float)n4);
            Gears.this.prevMouseX = n;
            Gears.this.prevMouseY = n2;
            Gears.this.view_rotx += f2;
            Gears.this.view_roty += f;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                Gears.this.view_roty -= 1.0f;
            } else if (151 == s) {
                Gears.this.view_roty += 1.0f;
            } else if (150 == s) {
                Gears.this.view_rotx -= 1.0f;
            } else if (152 == s) {
                Gears.this.view_rotx += 1.0f;
            }
        }
    }
}

