/*
 * Decompiled with CFR 0.152.
 */
package demos.hdr;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLException;
import demos.hdr.Pipeline;
import demos.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ARBFPPipeline
implements Pipeline {
    private int textureFormat;
    private List programs = new ArrayList();

    public ARBFPPipeline(int n) {
        this.textureFormat = n;
    }

    @Override
    public void init() {
    }

    @Override
    public void initFloatingPointTexture(GL2 gL2, int n, int n2, int n3) {
        gL2.glBindTexture(34037, n);
        gL2.glCopyTexImage2D(34037, 0, this.textureFormat, 0, 0, n2, n3, 0);
    }

    @Override
    public void initTexture(GL2 gL2, int n, int n2, int n3) {
        gL2.glBindTexture(34037, n);
        gL2.glCopyTexImage2D(34037, 0, 6408, 0, 0, n2, n3, 0);
    }

    @Override
    public void copyToTexture(GL2 gL2, int n, int n2, int n3) {
        gL2.glBindTexture(34037, n);
        gL2.glCopyTexSubImage2D(34037, 0, 0, 0, 0, 0, n2, n3);
    }

    @Override
    public void bindTexture(GL2 gL2, int n) {
        gL2.glBindTexture(34037, n);
    }

    @Override
    public int loadVertexProgram(GL2 gL2, String string) throws IOException {
        return this.loadProgram(gL2, string, 34336);
    }

    @Override
    public int loadFragmentProgram(GL2 gL2, String string) throws IOException {
        return this.loadProgram(gL2, string, 34820);
    }

    private int loadProgram(GL2 gL2, String string, int n) throws IOException {
        String string2 = FileUtils.loadStreamIntoString((InputStream)this.getClass().getClassLoader().getResourceAsStream(string));
        int[] nArray = new int[1];
        gL2.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL2.glBindProgramARB(n, n2);
        gL2.glProgramStringARB(n, 34933, string2.length(), string2);
        int[] nArray2 = new int[1];
        gL2.glGetIntegerv(34379, nArray2, 0);
        if (nArray2[0] >= 0) {
            int n3;
            String string3 = "Program";
            if (n == 34336) {
                string3 = "Vertex program";
            } else if (n == 34820) {
                string3 = "Fragment program";
            }
            System.out.println(string3 + " failed to load:");
            String string4 = gL2.glGetString(34932);
            if (string4 == null) {
                System.out.println("[No error message available]");
            } else {
                System.out.println("Error message: \"" + string4 + "\"");
            }
            System.out.println("Error occurred at position " + nArray2[0] + " in program:");
            for (n3 = nArray2[0]; n3 < string2.length() && string2.charAt(n3) != '\n'; ++n3) {
            }
            System.out.println(string2.substring(nArray2[0], n3));
            throw new GLException("Error loading " + string3);
        }
        if (n == 34820) {
            int[] nArray3 = new int[1];
            gL2.glGetProgramiv(34820, 34998, nArray3, 0);
            if (nArray3[0] != 1) {
                System.out.println("WARNING: fragment program is over native resource limits");
                Thread.dumpStack();
            }
        }
        return n2;
    }

    @Override
    public void enableVertexProgram(GL2 gL2, int n) {
        gL2.glBindProgramARB(34336, n);
        gL2.glEnable(34336);
    }

    @Override
    public void enableFragmentProgram(GL2 gL2, int n) {
        gL2.glBindProgramARB(34820, n);
        gL2.glEnable(34820);
    }

    @Override
    public void disableVertexProgram(GL2 gL2) {
        gL2.glDisable(34336);
    }

    @Override
    public void disableFragmentProgram(GL2 gL2) {
        gL2.glDisable(34820);
    }

    @Override
    public int getNamedParameter(int n, String string) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setVertexProgramParameter1f(GL2 gL2, int n, float f) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34336, n, f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void setVertexProgramParameter3f(GL2 gL2, int n, float f, float f2, float f3) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34336, n, f, f2, f3, 0.0f);
    }

    @Override
    public void setVertexProgramParameter4f(GL2 gL2, int n, float f, float f2, float f3, float f4) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34336, n, f, f2, f3, f4);
    }

    @Override
    public void setFragmentProgramParameter1f(GL2 gL2, int n, float f) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34820, n, f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void setFragmentProgramParameter3f(GL2 gL2, int n, float f, float f2, float f3) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34820, n, f, f2, f3, 0.0f);
    }

    @Override
    public void setFragmentProgramParameter4f(GL2 gL2, int n, float f, float f2, float f3, float f4) {
        if (n < 0) {
            return;
        }
        gL2.glProgramLocalParameter4fARB(34820, n, f, f2, f3, f4);
    }

    @Override
    public void trackModelViewProjectionMatrix(GL2 gL2, int n) {
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        float[] fArray3 = new float[16];
        gL2.glGetFloatv(2983, fArray2, 0);
        gL2.glGetFloatv(2982, fArray, 0);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    f += fArray[4 * i + k] * fArray2[4 * k + j];
                }
                fArray3[4 * i + j] = f;
            }
        }
        this.setMatrixParameterfc(gL2, n, fArray3);
    }

    @Override
    public void setMatrixParameterfc(GL2 gL2, int n, float[] fArray) {
        for (int i = 0; i < 4; ++i) {
            gL2.glProgramLocalParameter4fARB(34336, n + i, fArray[i], fArray[4 + i], fArray[8 + i], fArray[12 + i]);
        }
    }
}

