/*
 * Decompiled with CFR 0.152.
 */
package demos.hdr;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.gl2.GLUT;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.hdr.ARBFPPipeline;
import demos.hdr.HDRTexture;
import demos.hdr.Pipeline;
import demos.util.DurationTimer;
import demos.util.ObjReader;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.ManipManager;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.swing.JOptionPane;

public class HDR
extends Demo {
    private static String[] defaultArgs = new String[]{"demos/data/images/stpeters_cross.hdr", "512", "384", "2", "7", "3", "demos/data/models/teapot.obj"};
    private GLAutoDrawable drawable;
    private boolean useCg;
    private boolean initComplete;
    private HDRTexture hdr;
    private String modelFilename;
    private ObjReader model;
    private Pipeline pipeline;
    private final GLUT glut = new GLUT();
    private final boolean[] b = new boolean[256];
    private ExaminerViewer viewer;
    private boolean doViewAll = true;
    private final DurationTimer timer = new DurationTimer();
    private boolean firstRender = true;
    private int frameCount;
    private final Time time = new SystemTime();
    private final float animRate = (float)Math.toRadians(-12.0);
    private String hdrFilename;
    private int win_w;
    private int win_h;
    private float win_scale;
    private int pbuffer_w;
    private int pbuffer_h;
    private int blurWidth;
    private int blur_scale;
    private int blur_w;
    private int blur_h;
    private float blurAmount = 0.5f;
    private int modelno = 4;
    private int numModels = 5;
    private final boolean hilo = false;
    private int hdr_tex;
    private int hdr_tex2;
    private int gamma_tex;
    private int vignette_tex;
    private GLOffscreenAutoDrawable pbuffer;
    private GLOffscreenAutoDrawable blur_pbuffer;
    private GLOffscreenAutoDrawable blur2_pbuffer;
    private GLOffscreenAutoDrawable tonemap_pbuffer;
    private int pbuffer_tex;
    private int blur_pbuffer_tex;
    private int blur2_pbuffer_tex;
    private int tonemap_pbuffer_tex;
    private static final int BLUR2_SHRINK_PASS = 0;
    private static final int BLUR2_VERT_BLUR_PASS = 1;
    private int blur2Pass;
    private int blurh_fprog;
    private int blurv_fprog;
    private int skybox_fprog;
    private int object_fprog;
    private int object_vprog;
    private int tonemap_fprog;
    private int shrink_fprog;
    private int blurAmount_param;
    private int windowSize_param;
    private int exposure_param;
    private int modelViewProj_param;
    private int model_param;
    private int eyePos_param;
    private float exposure = 32.0f;
    private final float[] identityMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private final float zNear = 0.1f;
    private final float zFar = 10.0f;
    private final GLU glu = new GLU();
    private final String shaderRoot = "demos/hdr/shaders/";

    public static void main(String[] stringArray) {
        GLCanvas gLCanvas = new GLCanvas();
        final HDR hDR = new HDR();
        gLCanvas.addGLEventListener((GLEventListener)hDR);
        gLCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                hDR.dispatchKey(keyEvent.getKeyCode(), keyEvent.getKeyChar());
            }
        });
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        hDR.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                HDR.runExit(animator);
            }

            @Override
            public void repaint() {
            }
        });
        hDR.setup(stringArray);
        Frame frame = new Frame("High Dynamic Range Rendering Demo");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(hDR.getPreferredWidth(), hDR.getPreferredHeight());
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HDR.runExit(animator);
            }
        });
        animator.start();
    }

    public void setup(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = defaultArgs;
        }
        if (stringArray.length < 6 || stringArray.length > 8) {
            this.usage();
        }
        try {
            int n = 0;
            if (stringArray[n].equals("-cg")) {
                this.useCg = true;
            }
            int n2 = ++n;
            this.hdrFilename = stringArray[n2];
            int n3 = ++n;
            this.pbuffer_w = Integer.parseInt(stringArray[n3]);
            int n4 = ++n;
            this.pbuffer_h = Integer.parseInt(stringArray[n4]);
            int n5 = ++n;
            this.win_scale = Float.parseFloat(stringArray[n5]);
            int n6 = ++n;
            this.blurWidth = Integer.parseInt(stringArray[n6]);
            int n7 = ++n;
            this.blur_scale = Integer.parseInt(stringArray[n7]);
            if (++n < stringArray.length) {
                this.modelFilename = stringArray[n++];
            }
            this.blur_w = this.pbuffer_w / this.blur_scale;
            this.blur_h = this.pbuffer_h / this.blur_scale;
            this.win_w = (int)((float)this.pbuffer_w * this.win_scale);
            this.win_h = (int)((float)this.pbuffer_h * this.win_scale);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            this.usage();
        }
        if (this.modelFilename != null) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.modelFilename);
                if (inputStream == null) {
                    throw new IOException("Unable to open model file " + this.modelFilename);
                }
                this.model = new ObjReader(inputStream);
                if (this.model.getVerticesPerFace() != 3) {
                    throw new IOException("Sorry, only triangle-based WaveFront OBJ files supported");
                }
                this.model.rescale(1.2f / this.model.getRadius());
                ++this.numModels;
                this.modelno = 5;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
        this.b[102] = true;
        this.b[103] = true;
        this.b[108] = true;
        this.b[32] = true;
        this.b[110] = true;
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.hdrFilename);
            if (inputStream == null) {
                throw new IOException("Unable to open HDR file " + this.hdrFilename);
            }
            this.hdr = new HDRTexture(inputStream);
            this.hdr.analyze();
            this.hdr.convert();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
    }

    public int getPreferredWidth() {
        return this.win_w;
    }

    public int getPreferredHeight() {
        return this.win_h;
    }

    @Override
    public void shutdownDemo() {
        if (null != this.drawable) {
            ManipManager.getManipManager().unregisterWindow((AWTGLAutoDrawable)this.drawable);
            this.drawable.removeGLEventListener((GLEventListener)this);
        }
        super.shutdownDemo();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.initComplete = false;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.checkExtension((GL)gL2, "GL_VERSION_1_3");
        this.checkExtension((GL)gL2, "GL_ARB_pbuffer");
        this.checkExtension((GL)gL2, "GL_ARB_vertex_program");
        this.checkExtension((GL)gL2, "GL_ARB_fragment_program");
        if (!gL2.isExtensionAvailable("GL_ARB_texture_rectangle") && !gL2.isExtensionAvailable("GL_EXT_texture_rectangle")) {
            this.unavailableExtension("Texture rectangle extension not available (need either GL_ARB_texture_rectangle or GL_EXT_texture_rectangle");
        }
        if (!(gL2.isExtensionAvailable("GL_NV_float_buffer") || gL2.isExtensionAvailable("GL_ATI_texture_float") || gL2.isExtensionAvailable("GL_APPLE_float_pixels"))) {
            this.unavailableExtension("Floating-point textures not available (need one of GL_NV_float_buffer, GL_ATI_texture_float, or GL_APPLE_float_pixels");
        }
        this.setOrthoProjection(gL2, 0, 0, this.win_w, this.win_h);
        this.gamma_tex = this.createGammaTexture(gL2, 1024, 0.45454544f);
        this.vignette_tex = this.createVignetteTexture((GL)gL2, this.pbuffer_w, this.pbuffer_h, 0.25f * (float)this.pbuffer_w, 0.7f * (float)this.pbuffer_w);
        int n = 16;
        int n2 = 0;
        int n3 = 1;
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setRedBits(n);
        gLCapabilities.setGreenBits(n);
        gLCapabilities.setBlueBits(n);
        gLCapabilities.setAlphaBits(n2);
        gLCapabilities.setDepthBits(n3);
        gLCapabilities.setPBuffer(true);
        int[] nArray = new int[1];
        if (!GLDrawableFactory.getFactory((GLProfile)GLProfile.getDefault()).canCreateGLPbuffer(null, gLCapabilities.getGLProfile())) {
            this.unavailableExtension("Can not create pbuffer");
        }
        if (this.pbuffer != null) {
            this.pbuffer.destroy();
            this.pbuffer = null;
        }
        if (this.blur_pbuffer != null) {
            this.blur_pbuffer.destroy();
            this.blur_pbuffer = null;
        }
        if (this.blur2_pbuffer != null) {
            this.blur2_pbuffer.destroy();
            this.blur2_pbuffer = null;
        }
        if (this.tonemap_pbuffer != null) {
            this.tonemap_pbuffer.destroy();
            this.tonemap_pbuffer = null;
        }
        GLContext gLContext = gLAutoDrawable.getContext();
        this.pbuffer = GLDrawableFactory.getFactory((GLProfile)GLProfile.getDefault()).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, this.pbuffer_w, this.pbuffer_h);
        this.pbuffer.setSharedContext(gLContext);
        this.pbuffer.addGLEventListener((GLEventListener)new PbufferListener());
        gL2.glGenTextures(1, nArray, 0);
        this.pbuffer_tex = nArray[0];
        this.blur_pbuffer = GLDrawableFactory.getFactory((GLProfile)GLProfile.getDefault()).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, this.blur_w, this.blur_h);
        this.blur_pbuffer.setSharedContext(gLContext);
        this.blur_pbuffer.addGLEventListener((GLEventListener)new BlurPbufferListener());
        gL2.glGenTextures(1, nArray, 0);
        this.blur_pbuffer_tex = nArray[0];
        this.blur2_pbuffer = GLDrawableFactory.getFactory((GLProfile)GLProfile.getDefault()).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, this.blur_w, this.blur_h);
        this.blur2_pbuffer.setSharedContext(gLContext);
        this.blur2_pbuffer.addGLEventListener((GLEventListener)new Blur2PbufferListener());
        gL2.glGenTextures(1, nArray, 0);
        this.blur2_pbuffer_tex = nArray[0];
        gLCapabilities.setRedBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setDepthBits(24);
        this.tonemap_pbuffer = GLDrawableFactory.getFactory((GLProfile)GLProfile.getDefault()).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, this.pbuffer_w, this.pbuffer_h);
        this.tonemap_pbuffer.setSharedContext(gLContext);
        this.tonemap_pbuffer.addGLEventListener((GLEventListener)new TonemapPbufferListener());
        gL2.glGenTextures(1, nArray, 0);
        this.tonemap_pbuffer_tex = nArray[0];
        this.doViewAll = true;
        ManipManager manipManager = ManipManager.getManipManager();
        manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
        this.drawable = gLAutoDrawable;
        this.viewer = new ExaminerViewer();
        this.viewer.setUpVector(Vec3f.Y_AXIS);
        this.viewer.setAutoRedrawMode(false);
        this.viewer.setNoAltKeyMode(true);
        this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new BSphereProvider(){

            public BSphere getBoundingSphere() {
                return new BSphere(new Vec3f(0.0f, 0.0f, 0.0f), 1.0f);
            }
        });
        this.viewer.setZNear(0.1f);
        this.viewer.setZFar(10.0f);
        this.initComplete = true;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.initComplete) {
            return;
        }
        if (!this.firstRender) {
            if (++this.frameCount == 30) {
                this.timer.stop();
                System.err.println("Frames per second: " + 30.0f / this.timer.getDurationAsSeconds());
                this.timer.reset();
                this.timer.start();
                this.frameCount = 0;
            }
        } else {
            this.firstRender = false;
            this.timer.start();
        }
        this.time.update();
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.b[32]) {
            this.viewer.rotateAboutFocalPoint(new Rotf(Vec3f.Y_AXIS, (float)(this.time.deltaT() * (double)this.animRate)));
        }
        this.pbuffer.display();
        if (this.pipeline == null) {
            return;
        }
        if (this.b[103]) {
            this.blur2Pass = 0;
            this.blur2_pbuffer.display();
        }
        this.blur_pbuffer.display();
        this.blur2Pass = 1;
        this.blur2_pbuffer.display();
        this.tonemap_pbuffer.display();
        gL2.glEnable(34037);
        gL2.glActiveTexture(33984);
        gL2.glBindTexture(34037, this.tonemap_pbuffer_tex);
        if (this.b[110]) {
            gL2.glTexParameteri(34037, 10240, 9729);
        } else {
            gL2.glTexParameteri(34037, 10240, 9728);
        }
        this.drawQuadRect4(gL2, this.win_w, this.win_h, this.pbuffer_w, this.pbuffer_h);
        gL2.glDisable(34037);
        Thread.yield();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.setOrthoProjection(gLAutoDrawable.getGL().getGL2(), n, n2, n3, n4);
        this.win_w = n3;
        this.win_h = n4;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void checkExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            this.unavailableExtension("Unable to initialize " + string + " OpenGL extension");
        }
    }

    private void unavailableExtension(String string) {
        JOptionPane.showMessageDialog(null, string, "Unavailable extension", 0);
        this.shutdownDemo();
        throw new GLException(string);
    }

    private void dispatchKey(int n, char c) {
        if (c < '\u0100') {
            this.b[c] = !this.b[c];
        }
        switch (n) {
            case 27: 
            case 81: {
                this.shutdownDemo();
                break;
            }
            case 61: {
                this.exposure *= 2.0f;
                break;
            }
            case 45: {
                this.exposure *= 0.5f;
                break;
            }
            case 521: {
                this.exposure += 1.0f;
                break;
            }
            case 523: {
                this.exposure -= 1.0f;
                break;
            }
            case 46: {
                this.blurAmount += 0.1f;
                break;
            }
            case 44: {
                this.blurAmount -= 0.1f;
                break;
            }
            case 71: {
                if (this.b[103]) {
                    this.blurAmount = 0.5f;
                    break;
                }
                this.blurAmount = 0.0f;
                break;
            }
            case 79: {
                this.modelno = (this.modelno + 1) % this.numModels;
                break;
            }
            case 86: {
                this.doViewAll = true;
            }
        }
    }

    private int createGammaTexture(GL2 gL2, int n, float f) {
        int[] nArray = new int[1];
        gL2.glGenTextures(1, nArray, 0);
        int n2 = nArray[0];
        int n3 = 3552;
        gL2.glBindTexture(n3, n2);
        gL2.glTexParameteri(n3, 10240, 9728);
        gL2.glTexParameteri(n3, 10241, 9728);
        gL2.glTexParameteri(n3, 10242, 33071);
        gL2.glPixelStorei(3317, 1);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f2 = (float)i / (float)n;
            fArray[i] = (float)Math.pow(f2, f);
        }
        gL2.glTexImage1D(n3, 0, 6409, n, 0, 6409, 5126, (Buffer)FloatBuffer.wrap(fArray));
        return n2;
    }

    int createVignetteTexture(GL gL, int n, int n2, float f, float f2) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n3 = nArray[0];
        gL.glBindTexture(34037, n3);
        gL.glTexParameteri(34037, 10240, 9728);
        gL.glTexParameteri(34037, 10241, 9728);
        gL.glTexParameteri(34037, 10242, 33071);
        gL.glTexParameteri(34037, 10243, 33071);
        gL.glPixelStorei(3317, 1);
        float[] fArray = new float[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                float f3 = (float)Math.sqrt((j - n / 2) * (j - n / 2) + (i - n2 / 2) * (i - n2 / 2));
                if (f3 > f) {
                    if (f3 < f2) {
                        float f4;
                        float f5 = 1.0f - (f3 - f) / (f2 - f);
                        float f6 = f5 * 2.0f - 1.0f;
                        fArray[i * n + j] = f4 = (float)((0.7853981633974483 + 0.5 * Math.asin(f6) + 0.5 * (double)f6 * Math.sqrt(1.0f - f6 * f6)) / 1.5707963267948966);
                        continue;
                    }
                    fArray[i * n + j] = 0.0f;
                    continue;
                }
                fArray[i * n + j] = 1.0f;
            }
        }
        gL.glTexImage2D(34037, 0, 6409, n, n2, 0, 6409, 5126, (Buffer)FloatBuffer.wrap(fArray));
        return n3;
    }

    private void setOrthoProjection(GL2 gL2, int n, int n2, int n3, int n4) {
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, (double)n3, 0.0, (double)n4, -1.0, 1.0);
        gL2.glMatrixMode(5890);
        gL2.glLoadIdentity();
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glViewport(n, n2, n3, n4);
    }

    private void setPerspectiveProjection(GL2 gL2, int n, int n2) {
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluPerspective(60.0, (double)((float)n / (float)n2), 0.1, 10.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glViewport(0, 0, n, n2);
    }

    private void glowPass(GL2 gL2) {
        gL2.glDisable(2929);
        gL2.glEnable(34820);
        this.setOrthoProjection(gL2, 0, 0, this.blur_w, this.blur_h);
        this.drawQuadRect(gL2, this.blur_w, this.blur_h);
        gL2.glDisable(34820);
    }

    private void drawQuadRect(GL2 gL2, int n, int n2) {
        gL2.glBegin(7);
        gL2.glTexCoord2f(0.0f, (float)n2);
        gL2.glMultiTexCoord2f(33985, 0.0f, (float)(n2 / this.blur_scale));
        gL2.glVertex3f(0.0f, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n, (float)n2);
        gL2.glMultiTexCoord2f(33985, (float)(n / this.blur_scale), (float)(n2 / this.blur_scale));
        gL2.glVertex3f((float)n, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n, 0.0f);
        gL2.glMultiTexCoord2f(33985, (float)(n / this.blur_scale), 0.0f);
        gL2.glVertex3f((float)n, 0.0f, 0.0f);
        gL2.glTexCoord2f(0.0f, 0.0f);
        gL2.glMultiTexCoord2f(33985, 0.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glEnd();
    }

    private void drawQuadRect2(GL2 gL2, int n, int n2, int n3, int n4) {
        gL2.glBegin(7);
        gL2.glTexCoord2f(0.0f, (float)n4);
        gL2.glVertex3f(0.0f, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n3, (float)n4);
        gL2.glVertex3f((float)n, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n3, 0.0f);
        gL2.glVertex3f((float)n, 0.0f, 0.0f);
        gL2.glTexCoord2f(0.0f, 0.0f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glEnd();
    }

    private void drawQuadRect4(GL2 gL2, int n, int n2, int n3, int n4) {
        float f = 0.5f;
        gL2.glBegin(7);
        gL2.glTexCoord2f(f, (float)n4 - f);
        gL2.glVertex3f(0.0f, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n3 - f, (float)n4 - f);
        gL2.glVertex3f((float)n, (float)n2, 0.0f);
        gL2.glTexCoord2f((float)n3 - f, f);
        gL2.glVertex3f((float)n, 0.0f, 0.0f);
        gL2.glTexCoord2f(f, f);
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glEnd();
    }

    private void disableTexGen(GL gL) {
        gL.glDisable(3168);
        gL.glDisable(3169);
        gL.glDisable(3170);
    }

    private void enableTexGen(GL gL) {
        gL.glEnable(3168);
        gL.glEnable(3169);
        gL.glEnable(3170);
    }

    private void drawSkyBox(GL2 gL2) {
        gL2.glActiveTexture(33984);
        gL2.glBindTexture(34067, this.hdr_tex);
        gL2.glEnable(34067);
        gL2.glActiveTexture(33984);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        gL2.glTexGenfv(8192, 9473, fArray, 0);
        gL2.glTexGenfv(8193, 9473, fArray2, 0);
        gL2.glTexGenfv(8194, 9473, fArray3, 0);
        gL2.glPopMatrix();
        gL2.glTexGeni(8192, 9472, 9217);
        gL2.glTexGeni(8193, 9472, 9217);
        gL2.glTexGeni(8194, 9472, 9217);
        this.enableTexGen((GL)gL2);
        gL2.glTexEnvi(8960, 8704, 7681);
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        this.viewer.updateInverseRotation(gL2);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        gL2.glScalef(10.0f, 10.0f, 10.0f);
        this.glut.glutSolidCube(1.0f);
        gL2.glPopMatrix();
        gL2.glDisable(34067);
        gL2.glMatrixMode(5890);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        this.disableTexGen((GL)gL2);
    }

    private void toneMappingPass(GL2 gL2) {
        gL2.glFinish();
        gL2.glActiveTexture(33984);
        gL2.glBindTexture(34037, this.pbuffer_tex);
        gL2.glActiveTexture(33985);
        if (this.blur2_pbuffer != null) {
            gL2.glBindTexture(34037, this.blur2_pbuffer_tex);
        }
        gL2.glActiveTexture(33986);
        gL2.glBindTexture(3552, this.gamma_tex);
        gL2.glActiveTexture(33987);
        this.pipeline.bindTexture(gL2, this.vignette_tex);
        this.pipeline.enableFragmentProgram(gL2, this.tonemap_fprog);
        this.pipeline.setFragmentProgramParameter1f(gL2, this.blurAmount_param, this.blurAmount);
        this.pipeline.setFragmentProgramParameter4f(gL2, this.windowSize_param, 2.0f / (float)this.win_w, 2.0f / (float)this.win_h, -1.0f, -1.0f);
        this.pipeline.setFragmentProgramParameter1f(gL2, this.exposure_param, this.exposure);
        this.drawQuadRect(gL2, this.win_w, this.win_h);
        this.pipeline.disableFragmentProgram(gL2);
    }

    private void initCg(GL2 gL2) {
        try {
            Class<?> clazz = Class.forName("demos.hdr.CgPipeline");
            this.pipeline = (Pipeline)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new GLException((Throwable)exception);
        }
        this.pipeline.init();
        try {
            this.tonemap_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/cg/tonemap.cg");
            this.blurAmount_param = this.pipeline.getNamedParameter(this.tonemap_fprog, "blurAmount");
            this.windowSize_param = this.pipeline.getNamedParameter(this.tonemap_fprog, "windowSize");
            this.exposure_param = this.pipeline.getNamedParameter(this.tonemap_fprog, "exposure");
            this.skybox_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/cg/skybox.cg");
            this.object_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/cg/object.cg");
            this.shrink_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/cg/shrink.cg");
            this.object_vprog = this.pipeline.loadVertexProgram(gL2, "demos/hdr/shaders/cg/object_vp.cg");
            this.modelViewProj_param = this.pipeline.getNamedParameter(this.object_vprog, "modelViewProj");
            this.model_param = this.pipeline.getNamedParameter(this.object_vprog, "model");
            this.eyePos_param = this.pipeline.getNamedParameter(this.object_vprog, "eyePos");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error loading shaders", iOException);
        }
    }

    private void initARBFP(GL2 gL2, int n) {
        this.pipeline = new ARBFPPipeline(n);
        this.pipeline.init();
        try {
            this.tonemap_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/arbfp1/tonemap.arbfp1");
            this.blurAmount_param = 1;
            this.windowSize_param = -1;
            this.exposure_param = 2;
            this.skybox_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/arbfp1/skybox.arbfp1");
            this.object_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/arbfp1/object.arbfp1");
            this.shrink_fprog = this.pipeline.loadFragmentProgram(gL2, "demos/hdr/shaders/arbfp1/shrink.arbfp1");
            this.object_vprog = this.pipeline.loadVertexProgram(gL2, "demos/hdr/shaders/arbfp1/object_vp.arbvp1");
            this.modelViewProj_param = 0;
            this.model_param = 4;
            this.eyePos_param = 8;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error loading shaders", iOException);
        }
    }

    private void initBlurCode(GL2 gL2, int n) {
        String string = this.generateBlurCodeFP2(n, false);
        this.blurh_fprog = this.loadProgram(gL2, 34820, string);
        string = this.generateBlurCodeFP2(n, true);
        this.blurv_fprog = this.loadProgram(gL2, 34820, string);
    }

    private int loadProgram(GL2 gL2, int n, String string) {
        int[] nArray = new int[1];
        gL2.glGenProgramsARB(1, nArray, 0);
        int n2 = nArray[0];
        gL2.glBindProgramARB(n, n2);
        gL2.glProgramStringARB(n, 34933, string.length(), string);
        int[] nArray2 = new int[1];
        gL2.glGetIntegerv(34379, nArray2, 0);
        if (nArray2[0] >= 0) {
            int n3;
            String string2 = "Program";
            if (n == 34336) {
                string2 = "Vertex program";
            } else if (n == 34820) {
                string2 = "Fragment program";
            }
            System.out.println(string2 + " failed to load:");
            String string3 = gL2.glGetString(34932);
            if (string3 == null) {
                System.out.println("[No error message available]");
            } else {
                System.out.println("Error message: \"" + string3 + "\"");
            }
            System.out.println("Error occurred at position " + nArray2[0] + " in program:");
            for (n3 = nArray2[0]; n3 < string.length() && string.charAt(n3) != '\n'; ++n3) {
            }
            System.out.println(string.substring(nArray2[0], n3));
            throw new GLException("Error loading " + string2);
        }
        if (n == 34820) {
            int[] nArray3 = new int[1];
            gL2.glGetProgramiv(34820, 34998, nArray3, 0);
            if (nArray3[0] != 1) {
                System.out.println("WARNING: fragment program is over native resource limits");
                Thread.dumpStack();
            }
        }
        return n2;
    }

    private float gaussian(float f, float f2) {
        return (float)(Math.exp(-f * f / (2.0f * f2 * f2)) / ((double)f2 * Math.sqrt(Math.PI * 2)));
    }

    private String generateBlurCodeFP2(int n, boolean bl) {
        float f;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        float f2 = 0.0f;
        for (n2 = -n; n2 <= n; ++n2) {
            f = this.gaussian(3.0f * (float)n2 / (float)n, 1.0f);
            f2 += f;
        }
        System.err.println("sum = " + f2);
        stringBuffer.append("!!ARBfp1.0\n");
        stringBuffer.append("TEMP H0, H1, H2;\n");
        for (n2 = -n; n2 <= n; n2 += 2) {
            int n3;
            int n4;
            int n5;
            int n6;
            f = this.gaussian(3.0f * (float)n2 / (float)n, 1.0f) / f2;
            float f3 = this.gaussian(3.0f * (float)(n2 + 1) / (float)n, 1.0f) / f2;
            if (bl) {
                n6 = 0;
                n5 = 0;
                n4 = n2;
                n3 = n2 + 1;
            } else {
                n6 = n2;
                n5 = n2 + 1;
                n4 = 0;
                n3 = 0;
            }
            stringBuffer.append("ADD H0, fragment.texcoord[0], {" + n6 + ", " + n4 + "};\n");
            if (n2 + 1 <= n) {
                stringBuffer.append("ADD H1, fragment.texcoord[0], {" + n5 + ", " + n3 + "};\n");
            }
            stringBuffer.append("TEX  H0, H0, texture[0], RECT;\n");
            if (n2 + 1 <= n) {
                stringBuffer.append("TEX  H1, H1, texture[0], RECT;\n");
            }
            if (n2 == -n) {
                stringBuffer.append("MUL H2, H0, {" + f + "}.x;\n");
                stringBuffer.append("MAD H2, H1, {" + f3 + "}.x, H2;\n");
                continue;
            }
            stringBuffer.append("MAD H2, H0, {" + f + "}.x, H2;\n");
            if (n2 + 1 > n) continue;
            stringBuffer.append("MAD H2, H1, {" + f3 + "}.x, H2;\n");
        }
        stringBuffer.append("MOV result.color, H2;\nEND\n");
        return stringBuffer.toString();
    }

    private void applyTransform(GL2 gL2, Mat4f mat4f) {
        float[] fArray = new float[16];
        mat4f.getColumnMajorData(fArray);
        gL2.glMultMatrixf(fArray, 0);
    }

    private void usage() {
        System.err.println("usage: java demos.hdr.HDR [-cg] image.hdr pbuffer_w pbuffer_h window_scale blur_width blur_decimate [obj file]");
        this.shutdownDemo();
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }

    class PbufferListener
    implements GLEventListener {
        PbufferListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glEnable(2929);
            HDR.this.setPerspectiveProjection(gL2, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
            GLOffscreenAutoDrawable gLOffscreenAutoDrawable = (GLOffscreenAutoDrawable)gLAutoDrawable;
            int n = 0;
            switch (n) {
                default: 
            }
            throw new RuntimeException("Unexpected floating-point mode " + n);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            this.renderScene(gL2);
            HDR.this.pipeline.copyToTexture(gL2, HDR.this.pbuffer_tex, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        private void renderScene(GL2 gL2) {
            gL2.glClear(16640);
            if (HDR.this.doViewAll) {
                HDR.this.viewer.viewAll(gL2);
            }
            if (HDR.this.b[119]) {
                gL2.glPolygonMode(1032, 6913);
            } else {
                gL2.glPolygonMode(1032, 6914);
            }
            if (HDR.this.b[109]) {
                gL2.glEnable(32925);
                gL2.glHint(34100, 4354);
            } else {
                gL2.glDisable(32925);
            }
            if (!HDR.this.b[101]) {
                HDR.this.pipeline.enableFragmentProgram(gL2, HDR.this.skybox_fprog);
                gL2.glDisable(2929);
                HDR.this.drawSkyBox(gL2);
                gL2.glEnable(2929);
            }
            HDR.this.pipeline.enableVertexProgram(gL2, HDR.this.object_vprog);
            HDR.this.pipeline.enableFragmentProgram(gL2, HDR.this.object_fprog);
            gL2.glMatrixMode(5890);
            gL2.glLoadIdentity();
            HDR.this.viewer.update();
            HDR.this.viewer.updateInverseRotation(gL2);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            CameraParameters cameraParameters = HDR.this.viewer.getCameraParameters();
            Mat4f mat4f = cameraParameters.getModelviewMatrix();
            HDR.this.applyTransform(gL2, mat4f);
            HDR.this.pipeline.trackModelViewProjectionMatrix(gL2, HDR.this.modelViewProj_param);
            HDR.this.pipeline.setMatrixParameterfc(gL2, HDR.this.model_param, HDR.this.identityMatrix);
            Vec3f vec3f = new Vec3f();
            Vec3f vec3f2 = new Vec3f();
            mat4f.invertRigid();
            mat4f.xformPt(vec3f, vec3f2);
            HDR.this.pipeline.setVertexProgramParameter3f(gL2, HDR.this.eyePos_param, vec3f2.x(), vec3f2.y(), vec3f2.z());
            gL2.glActiveTexture(33984);
            gL2.glBindTexture(34067, HDR.this.hdr_tex);
            gL2.glEnable(34067);
            boolean bl = HDR.this.b[108];
            if (bl) {
                gL2.glTexParameteri(34067, 10241, 9987);
                gL2.glTexParameteri(34067, 10240, 9729);
            } else {
                gL2.glTexParameteri(34067, 10241, 9728);
                gL2.glTexParameteri(34067, 10240, 9728);
            }
            gL2.glEnable(2884);
            switch (HDR.this.modelno) {
                case 0: {
                    HDR.this.glut.glutSolidTorus(0.25, 0.5, 40, 40);
                    break;
                }
                case 1: {
                    HDR.this.glut.glutSolidSphere(0.75, 40, 40);
                    break;
                }
                case 2: {
                    HDR.this.glut.glutSolidTetrahedron();
                    break;
                }
                case 3: {
                    HDR.this.glut.glutSolidCube(1.0f);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    gL2.glEnableClientState(32884);
                    gL2.glEnableClientState(32885);
                    gL2.glVertexPointer(3, 5126, 0, (Buffer)HDR.this.model.getVertices());
                    gL2.glNormalPointer(5126, 0, (Buffer)HDR.this.model.getVertexNormals());
                    int[] nArray = HDR.this.model.getFaceIndices();
                    gL2.glDrawElements(4, nArray.length, 5125, (Buffer)IntBuffer.wrap(nArray));
                    gL2.glDisableClientState(32884);
                    gL2.glDisableClientState(32885);
                }
            }
            gL2.glDisable(2884);
            HDR.this.pipeline.disableVertexProgram(gL2);
            HDR.this.pipeline.disableFragmentProgram(gL2);
            gL2.glPolygonMode(1032, 6914);
        }
    }

    class BlurPbufferListener
    implements GLEventListener {
        BlurPbufferListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            HDR.this.setOrthoProjection(gL2, 0, 0, HDR.this.blur_w, HDR.this.blur_h);
            HDR.this.pipeline.initFloatingPointTexture(gL2, HDR.this.blur_pbuffer_tex, HDR.this.blur_w, HDR.this.blur_h);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glBindProgramARB(34820, HDR.this.blurh_fprog);
            gL2.glActiveTexture(33984);
            HDR.this.pipeline.bindTexture(gL2, HDR.this.blur2_pbuffer_tex);
            HDR.this.glowPass(gL2);
            HDR.this.pipeline.copyToTexture(gL2, HDR.this.blur_pbuffer_tex, HDR.this.blur_w, HDR.this.blur_h);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }

    class Blur2PbufferListener
    implements GLEventListener {
        Blur2PbufferListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            HDR.this.setOrthoProjection(gL2, 0, 0, HDR.this.blur_w, HDR.this.blur_h);
            HDR.this.pipeline.initFloatingPointTexture(gL2, HDR.this.blur2_pbuffer_tex, HDR.this.blur_w, HDR.this.blur_h);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            if (HDR.this.blur2Pass == 0) {
                gL2.glClear(16384);
                HDR.this.pipeline.enableFragmentProgram(gL2, HDR.this.shrink_fprog);
                HDR.this.setOrthoProjection(gL2, 0, 0, HDR.this.blur_w, HDR.this.blur_h);
                gL2.glActiveTexture(33984);
                gL2.glBindTexture(34037, HDR.this.pbuffer_tex);
                HDR.this.drawQuadRect2(gL2, HDR.this.blur_w, HDR.this.blur_h, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
                HDR.this.pipeline.disableFragmentProgram(gL2);
            } else if (HDR.this.blur2Pass == 1) {
                gL2.glBindProgramARB(34820, HDR.this.blurv_fprog);
                gL2.glActiveTexture(33984);
                HDR.this.pipeline.bindTexture(gL2, HDR.this.blur_pbuffer_tex);
                HDR.this.glowPass(gL2);
            } else {
                throw new RuntimeException("Illegal value of blur2Pass: " + HDR.this.blur2Pass);
            }
            HDR.this.pipeline.copyToTexture(gL2, HDR.this.blur2_pbuffer_tex, HDR.this.blur_w, HDR.this.blur_h);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }

    class TonemapPbufferListener
    implements GLEventListener {
        TonemapPbufferListener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            HDR.this.setOrthoProjection(gL2, 0, 0, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
            HDR.this.pipeline.initTexture(gL2, HDR.this.tonemap_pbuffer_tex, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            HDR.this.toneMappingPass(gL2);
            HDR.this.pipeline.copyToTexture(gL2, HDR.this.tonemap_pbuffer_tex, HDR.this.pbuffer_w, HDR.this.pbuffer_h);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }
    }
}

