/*
 * Decompiled with CFR 0.152.
 */
package demos.hdr;

import com.jogamp.opengl.GL;
import demos.hdr.RGBE;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class HDRTexture {
    private RGBE.Header header;
    private byte[] m_data;
    private float[] m_floatdata;
    private int m_width;
    private int m_height;
    private float m_max_r;
    private float m_max_g;
    private float m_max_b;
    private float m_min_r;
    private float m_min_g;
    private float m_min_b;
    private float m_max;
    private int m_target;

    public HDRTexture(String string) throws IOException {
        this(new FileInputStream(string));
    }

    public HDRTexture(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.header = RGBE.readHeader(dataInputStream);
        this.m_width = this.header.getWidth();
        this.m_height = this.header.getHeight();
        this.m_data = new byte[this.m_width * this.m_height * 4];
        RGBE.readPixelsRawRLE(dataInputStream, this.m_data, 0, this.m_width, this.m_height);
        System.err.println("Loaded HDR image " + this.m_width + " x " + this.m_height);
    }

    public byte[] getData() {
        return this.m_data;
    }

    public int getPixelIndex(int n, int n2) {
        return (this.m_width * (this.m_height - 1 - n2) + n) * 4;
    }

    public float[] getFloatData() {
        return this.m_floatdata;
    }

    public int getPixelFloatIndex(int n, int n2) {
        return (this.m_width * (this.m_height - 1 - n2) + n) * 3;
    }

    public void analyze() {
        this.m_max_b = 0.0f;
        this.m_max_g = 0.0f;
        this.m_max_r = 0.0f;
        this.m_min_b = 1.0E10f;
        this.m_min_g = 1.0E10f;
        this.m_min_r = 1.0E10f;
        int n = 255;
        int n2 = 0;
        int n3 = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.m_width * this.m_height; ++i) {
            int n4 = this.m_data[n3 + 3] & 0xFF;
            if (n4 < n) {
                n = n4;
            }
            if (n4 > n2) {
                n2 = n4;
            }
            RGBE.rgbe2float(fArray, this.m_data, n3);
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (f > this.m_max_r) {
                this.m_max_r = f;
            }
            if (f2 > this.m_max_g) {
                this.m_max_g = f2;
            }
            if (f3 > this.m_max_b) {
                this.m_max_b = f3;
            }
            if (f < this.m_min_r) {
                this.m_min_r = f;
            }
            if (f2 < this.m_min_g) {
                this.m_min_g = f2;
            }
            if (f3 < this.m_min_b) {
                this.m_min_b = f3;
            }
            n3 += 4;
        }
        System.err.println("max intensity: " + this.m_max_r + " " + this.m_max_g + " " + this.m_max_b);
        System.err.println("min intensity: " + this.m_min_r + " " + this.m_min_g + " " + this.m_min_b);
        System.err.println("max e: " + n2 + " = " + RGBE.ldexp(1.0, n2 - 128));
        System.err.println("min e: " + n + " = " + RGBE.ldexp(1.0, n - 128));
        this.m_max = this.m_max_r;
        if (this.m_max_g > this.m_max) {
            this.m_max = this.m_max_g;
        }
        if (this.m_max_b > this.m_max) {
            this.m_max = this.m_max_b;
        }
        System.err.println("max: " + this.m_max);
    }

    public void convert() {
        this.m_floatdata = new float[this.m_width * this.m_height * 3];
        int n = 0;
        int n2 = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.m_width * this.m_height; ++i) {
            RGBE.rgbe2float(fArray, this.m_data, n);
            this.m_floatdata[n2++] = HDRTexture.remap(fArray[0], this.m_max);
            this.m_floatdata[n2++] = HDRTexture.remap(fArray[1], this.m_max);
            this.m_floatdata[n2++] = HDRTexture.remap(fArray[2], this.m_max);
            n += 4;
        }
    }

    public int create2DTextureRGBE(GL gL, int n) {
        this.m_target = n;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n2 = nArray[1];
        gL.glBindTexture(this.m_target, n2);
        gL.glTexParameteri(this.m_target, 10240, 9728);
        gL.glTexParameteri(this.m_target, 10241, 9728);
        gL.glTexParameteri(this.m_target, 10242, 33071);
        gL.glTexParameteri(this.m_target, 10243, 33071);
        gL.glPixelStorei(3317, 1);
        gL.glTexParameteri(this.m_target, 33169, 1);
        gL.glTexImage2D(this.m_target, 0, 6408, this.m_width, this.m_height, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(this.m_data));
        return n2;
    }

    public int create2DTextureHILO(GL gL, int n, boolean bl) {
        this.m_target = n;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n2 = nArray[0];
        gL.glBindTexture(this.m_target, n2);
        gL.glTexParameteri(this.m_target, 10240, 9728);
        gL.glTexParameteri(this.m_target, 10241, 9728);
        gL.glTexParameteri(this.m_target, 10242, 33071);
        gL.glTexParameteri(this.m_target, 10243, 33071);
        gL.glPixelStorei(3317, 1);
        gL.glTexParameteri(this.m_target, 33169, 1);
        float[] fArray = new float[this.m_width * this.m_height * 2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.m_height; ++i) {
            for (int j = 0; j < this.m_width; ++j) {
                if (bl) {
                    fArray[n4++] = this.m_floatdata[n3 + 0];
                    fArray[n4++] = this.m_floatdata[n3 + 1];
                } else {
                    fArray[n4++] = this.m_floatdata[n3 + 2];
                    fArray[n4++] = 0.0f;
                }
                n3 += 3;
            }
        }
        gL.glTexImage2D(this.m_target, 0, 34552, this.m_width, this.m_height, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        return n2;
    }

    public int createCubemapRGBE(GL gL) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_width / 3;
        int n5 = this.m_height / 4;
        byte[] byArray = new byte[n4 * n5 * 4];
        this.m_target = 34067;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n6 = nArray[0];
        gL.glBindTexture(this.m_target, n6);
        gL.glPixelStorei(3317, 1);
        gL.glTexParameteri(this.m_target, 33169, 1);
        gL.glTexParameteri(this.m_target, 10240, 9728);
        gL.glTexParameteri(this.m_target, 10241, 9728);
        gL.glTexParameteri(this.m_target, 10242, 33071);
        gL.glTexParameteri(this.m_target, 10243, 33071);
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(2 * n4 - (n2 + 1), 3 * n5 + n3);
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34071, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(n2, this.m_height - (n5 + n3 + 1));
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34069, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(n4 + n2, this.m_height - (n5 + n3 + 1));
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34074, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(2 * n4 + n2, this.m_height - (n5 + n3 + 1));
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34070, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(2 * n4 - (n2 + 1), n5 + n3);
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34072, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelIndex(2 * n4 - (n2 + 1), n3);
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
                byArray[n7++] = this.m_data[n++];
            }
        }
        gL.glTexImage2D(34073, 0, 6408, n4, n5, 0, 6408, 5121, (Buffer)ByteBuffer.wrap(byArray));
        return n6;
    }

    public int createCubemapHILO(GL gL, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_width / 3;
        int n5 = this.m_height / 4;
        float[] fArray = new float[n4 * n5 * 2];
        this.m_target = 34067;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n6 = nArray[0];
        gL.glBindTexture(this.m_target, n6);
        gL.glPixelStorei(3317, 1);
        gL.glTexParameteri(this.m_target, 33169, 1);
        gL.glTexParameteri(this.m_target, 10240, 9729);
        gL.glTexParameteri(this.m_target, 10241, 9987);
        gL.glTexParameteri(this.m_target, 10242, 33071);
        gL.glTexParameteri(this.m_target, 10243, 33071);
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(2 * n4 - (n2 + 1), 3 * n5 + n3);
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34071, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(n2, this.m_height - (n5 + n3 + 1));
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34069, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(n4 + n2, this.m_height - (n5 + n3 + 1));
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34074, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(2 * n4 + n2, this.m_height - (n5 + n3 + 1));
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34070, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(2 * n4 - (n2 + 1), n5 + n3);
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34072, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.getPixelFloatIndex(2 * n4 - (n2 + 1), n3);
                if (bl) {
                    fArray[n7++] = this.m_floatdata[n + 0];
                    fArray[n7++] = this.m_floatdata[n + 1];
                    continue;
                }
                fArray[n7++] = this.m_floatdata[n + 2];
                fArray[n7++] = 0.0f;
            }
        }
        gL.glTexImage2D(34073, 0, 34552, n4, n5, 0, 34548, 5126, (Buffer)FloatBuffer.wrap(fArray));
        return n6;
    }

    public int createCubemap(GL gL, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.m_width / 3;
        int n6 = this.m_height / 4;
        float[] fArray = new float[n5 * n6 * 3];
        this.m_target = 34067;
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        int n7 = nArray[0];
        gL.glBindTexture(this.m_target, n7);
        gL.glPixelStorei(3317, 1);
        gL.glTexParameteri(this.m_target, 33169, 1);
        gL.glTexParameteri(this.m_target, 10240, 9729);
        gL.glTexParameteri(this.m_target, 10241, 9987);
        gL.glTexParameteri(this.m_target, 10242, 33071);
        gL.glTexParameteri(this.m_target, 10243, 33071);
        int n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(2 * n5 - (n3 + 1), 3 * n6 + n4);
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34071, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(n3, this.m_height - (n6 + n4 + 1));
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34069, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(n5 + n3, this.m_height - (n6 + n4 + 1));
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34074, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(2 * n5 + n3, this.m_height - (n6 + n4 + 1));
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34070, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(2 * n5 - (n3 + 1), n6 + n4);
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34072, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        n8 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = this.getPixelFloatIndex(2 * n5 - (n3 + 1), n4);
                fArray[n8++] = this.m_floatdata[n2 + 0];
                fArray[n8++] = this.m_floatdata[n2 + 1];
                fArray[n8++] = this.m_floatdata[n2 + 2];
            }
        }
        gL.glTexImage2D(34073, 0, n, n5, n6, 0, 6407, 5126, (Buffer)FloatBuffer.wrap(fArray));
        return n7;
    }

    private static float remap(float f, float f2) {
        if (f > f2) {
            f = f2;
        }
        return (float)Math.sqrt(f / f2);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                HDRTexture hDRTexture = new HDRTexture(stringArray[i]);
                hDRTexture.analyze();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

