/*
 * Decompiled with CFR 0.152.
 */
package demos.infiniteShadowVolumes;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.util.MD2;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.HandleBoxManip;
import gleem.Manip;
import gleem.ManipManager;
import gleem.linalg.Mat4f;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import gleem.linalg.Vec4f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class InfiniteShadowVolumes
extends Demo {
    private static final int MAX_MODELS = 4;
    private Model[] m = new Model[4];
    private int curr_model = 0;
    private int num_models = 0;
    private static final int CAMERA_VIEW = 0;
    private static final int SCENE_VIEW = 1;
    private static final int CLIP_VIEW = 2;
    private int curr_view = 0;
    private GLU glu = new GLU();
    private GLUT glut = new GLUT();
    private GLAutoDrawable drawable;
    private ExaminerViewer viewer;
    private HandleBoxManip objectManip;
    private HandleBoxManip lightManip;
    private Mat4f objectManipXform;
    private Mat4f lightManipXform;
    int faceDisplayList;
    int wallTexObject;
    private boolean[] b = new boolean[256];
    Vec4f light_position = new Vec4f(0.0f, 0.0f, 0.0f, 1.0f);
    float light_object_scale = 1.0f;
    float volume_alpha = 0.1f;
    float room_ambient = 0.3f;
    boolean doViewAll = true;
    private boolean enableDepthClampNV;
    private boolean toggleDepthClampNV;
    private boolean animateContinually;
    private boolean animateForward;
    private boolean animateBackward;
    private boolean hideCurrentModel;
    private boolean toggleWireframe;

    public static void main(String[] stringArray) {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setStencilBits(16);
        final GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        InfiniteShadowVolumes infiniteShadowVolumes = new InfiniteShadowVolumes();
        gLCanvas.addGLEventListener((GLEventListener)infiniteShadowVolumes);
        infiniteShadowVolumes.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                InfiniteShadowVolumes.runExit();
            }

            @Override
            public void repaint() {
                gLCanvas.repaint();
            }
        });
        Frame frame = new Frame("Infinite Stenciled Shadow Volumes");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InfiniteShadowVolumes.runExit();
            }
        });
    }

    @Override
    public void shutdownDemo() {
        ManipManager.getManipManager().unregisterWindow((AWTGLAutoDrawable)this.drawable);
        this.drawable.removeGLEventListener((GLEventListener)this);
        super.shutdownDemo();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClearStencil(128);
        gL2.glEnable(2929);
        gL2.glDepthFunc(513);
        gL2.glEnable(2977);
        gL2.glLightModeli(2898, 0);
        float[] fArray = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
        gL2.glLightfv(16384, 4608, fArray, 0);
        this.faceDisplayList = gL2.glGenLists(1);
        gL2.glNewList(this.faceDisplayList, 4864);
        this.drawMesh(gL2, 20.0f, 40);
        gL2.glEndList();
        int[] nArray = new int[1];
        gL2.glGenTextures(1, nArray, 0);
        this.wallTexObject = nArray[0];
        gL2.glBindTexture(3553, this.wallTexObject);
        gL2.glTexParameteri(3553, 33169, 1);
        gL2.glTexParameteri(3553, 10241, 9987);
        gL2.glTexParameteri(3553, 10240, 9729);
        float[] fArray2 = new float[1024];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                fArray2[i + j * 32] = (i >> 4 ^ j >> 4) != 0 ? 1.0f : 0.9f;
            }
        }
        gL2.glTexImage2D(3553, 0, 6408, 32, 32, 0, 6409, 5126, (Buffer)FloatBuffer.wrap(fArray2));
        this.initModel();
        this.b[83] = true;
        this.b[118] = true;
        this.b[73] = true;
        this.b[76] = true;
        this.doViewAll = true;
        ManipManager manipManager = ManipManager.getManipManager();
        manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
        this.drawable = gLAutoDrawable;
        this.objectManip = new HandleBoxManip();
        manipManager.showManipInWindow((Manip)this.objectManip, (AWTGLAutoDrawable)gLAutoDrawable);
        this.objectManip.setTranslation(new Vec3f(0.0f, 0.0f, -2.0f));
        this.objectManip.setRotation(new Rotf(new Vec3f(1.0f, 0.0f, 0.0f), (float)Math.toRadians(-90.0)));
        this.lightManip = new HandleBoxManip();
        manipManager.showManipInWindow((Manip)this.lightManip, (AWTGLAutoDrawable)gLAutoDrawable);
        this.lightManip.setTranslation(new Vec3f(0.5f, 0.5f, -1.0f));
        this.lightManip.setGeometryScale(new Vec3f(0.1f, 0.1f, 0.1f));
        this.viewer = new ExaminerViewer();
        this.viewer.setUpVector(Vec3f.Y_AXIS);
        this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new BSphereProvider(){

            public BSphere getBoundingSphere() {
                return new BSphere(InfiniteShadowVolumes.this.objectManip.getTranslation(), 1.0f);
            }
        });
        this.viewer.setZNear(1.0f);
        this.viewer.setZFar(100.0f);
        this.viewer.setOrientation(new Rotf(new Vec3f(0.0f, 1.0f, 0.0f), (float)Math.toRadians(15.0)));
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glDeleteLists(this.faceDisplayList, 1);
        this.faceDisplayList = 0;
        int[] nArray = new int[]{this.wallTexObject};
        gL2.glDeleteTextures(1, nArray, 0);
        this.wallTexObject = 0;
        this.objectManip = null;
        this.lightManip = null;
        this.viewer = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        Object object;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        if (this.doViewAll) {
            this.viewer.viewAll(gL2);
            this.doViewAll = false;
        }
        this.objectManipXform = this.objectManip.getTransform();
        this.lightManipXform = this.lightManip.getTransform();
        if (this.b[32]) {
            this.animateForward = true;
        }
        if (this.animateForward) {
            object = this.m[this.curr_model];
            ((Model)object).frame_num += ((Model)object).frame_incr;
            if (((Model)object).frame_num >= (float)((Model)object).mod.f.length) {
                ((Model)object).frame_num = 0.0f;
            }
            this.interpolate_frame();
            this.animateForward = false;
        }
        if (this.animateBackward) {
            object = this.m[this.curr_model];
            ((Model)object).frame_num -= ((Model)object).frame_incr;
            if (((Model)object).frame_num < 0.0f) {
                ((Model)object).frame_num += (float)((Model)object).mod.f.length;
            }
            this.interpolate_frame();
            this.animateBackward = false;
        }
        if (this.hideCurrentModel) {
            gL2.glNewList(this.faceDisplayList, 4864);
            this.drawMesh(gL2, 20.0f, 40);
            gL2.glEndList();
            this.hideCurrentModel = false;
        }
        if (this.toggleWireframe) {
            if (this.b[119]) {
                gL2.glPolygonMode(1032, 6913);
            } else {
                gL2.glPolygonMode(1032, 6914);
            }
        }
        if (this.b[73]) {
            switch (this.curr_view) {
                case 0: {
                    this.viewer.update(gL2);
                    gL2.glMatrixMode(5889);
                    gL2.glLoadIdentity();
                    this.applyInfinitePerspective(gL2, this.viewer);
                    break;
                }
                case 1: {
                    this.applyInfinitePerspective(gL2, this.viewer);
                    break;
                }
                case 2: {
                    this.applyInfinitePerspective(gL2, this.viewer);
                    gL2.glScalef(10.0f, 10.0f, -10.0f);
                    this.applyInfinitePerspective(gL2, this.viewer);
                    break;
                }
            }
        } else {
            switch (this.curr_view) {
                case 0: {
                    this.viewer.update(gL2);
                    break;
                }
                case 1: {
                    this.applyInfinitePerspective(gL2, this.viewer);
                    break;
                }
                case 2: {
                    this.applyInfinitePerspective(gL2, this.viewer);
                    gL2.glScalef(10.0f, 10.0f, -10.0f);
                    break;
                }
            }
        }
        gL2.glMatrixMode(5888);
        if (this.b[88]) {
            gL2.glLoadIdentity();
            if (this.b[73]) {
                this.applyInfinitePerspectiveInverse(gL2, this.viewer);
            }
            object = new double[]{-1.0, 0.0, 0.0, 1.0};
            double[] dArray = new double[]{1.0, 0.0, 0.0, 1.0};
            double[] dArray2 = new double[]{0.0, -1.0, 0.0, 1.0};
            double[] dArray3 = new double[]{0.0, 1.0, 0.0, 1.0};
            double[] dArray4 = new double[]{0.0, 0.0, -1.0, 1.0};
            double[] dArray5 = new double[]{0.0, 0.0, 1.0, 1.0};
            gL2.glClipPlane(12288, (double[])object, 0);
            gL2.glClipPlane(12289, dArray, 0);
            gL2.glClipPlane(12290, dArray2, 0);
            gL2.glClipPlane(12291, dArray3, 0);
            gL2.glClipPlane(12292, dArray4, 0);
            gL2.glClipPlane(12293, dArray5, 0);
            gL2.glEnable(12288);
            gL2.glEnable(12289);
            gL2.glEnable(12290);
            gL2.glEnable(12291);
            gL2.glEnable(12292);
            gL2.glEnable(12293);
            gL2.glLoadIdentity();
        }
        gL2.glPushMatrix();
        gL2.glMultMatrixf(this.getData(this.lightManipXform), 0);
        gL2.glLightfv(16384, 4611, this.getData(this.light_position), 0);
        gL2.glPopMatrix();
        gL2.glEnable(16384);
        gL2.glPushMatrix();
        gL2.glClear(17664);
        ManipManager.getManipManager().updateCameraParameters((AWTGLAutoDrawable)gLAutoDrawable, this.viewer.getCameraParameters());
        ManipManager.getManipManager().render((AWTGLAutoDrawable)gLAutoDrawable, gL2);
        if (!this.b[82]) {
            this.drawRoom(gL2, false);
        }
        if (!this.b[109]) {
            for (int i = 0; i < this.num_models; ++i) {
                if (!this.m[i].draw) continue;
                this.drawModel(gL2, i, false);
            }
        }
        if (this.b[88]) {
            gL2.glDisable(12288);
            gL2.glDisable(12289);
            gL2.glDisable(12290);
            gL2.glDisable(12291);
            gL2.glDisable(12292);
            gL2.glDisable(12293);
        }
        if (!this.b[115]) {
            for (int i = 0; i < this.num_models; ++i) {
                if (!this.m[i].draw) continue;
                this.drawShadowVolumeToStencil(gL2, i);
            }
        }
        if (this.b[88]) {
            gL2.glEnable(12288);
            gL2.glEnable(12289);
            gL2.glEnable(12290);
            gL2.glEnable(12291);
            gL2.glEnable(12292);
            gL2.glEnable(12293);
        }
        if (!this.b[100]) {
            if (!this.b[82]) {
                this.drawRoom(gL2, true);
            }
            if (!this.b[109]) {
                for (int i = 0; i < this.num_models; ++i) {
                    if (!this.m[i].draw) continue;
                    this.drawModel(gL2, i, true);
                }
            }
        }
        if (!this.b[83]) {
            for (int i = 0; i < this.num_models; ++i) {
                if (!this.m[i].draw) continue;
                this.drawPossibleSilhouette(gL2, i);
            }
        }
        if (!this.b[118]) {
            for (int i = 0; i < this.num_models; ++i) {
                if (!this.m[i].draw) continue;
                this.drawShadowVolumeToColor(gL2, i);
            }
        }
        if (this.b[88]) {
            gL2.glDisable(12288);
            gL2.glDisable(12289);
            gL2.glDisable(12290);
            gL2.glDisable(12291);
            gL2.glDisable(12292);
            gL2.glDisable(12293);
        }
        this.drawLight(gL2);
        gL2.glPopMatrix();
        if (this.curr_view != 0) {
            gL2.glPushMatrix();
            if (this.b[73]) {
                this.applyInfinitePerspectiveInverse(gL2, this.viewer);
            }
            gL2.glColor3f(0.75f, 0.75f, 0.0f);
            gL2.glLineWidth(3.0f);
            this.glut.glutWireCube(2.0f);
            gL2.glLineWidth(1.0f);
            gL2.glPopMatrix();
        }
        if (this.b[32]) {
            this.demoListener.repaint();
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void dispatchKey(char c) {
        boolean bl = this.b[c] = !this.b[c];
        if (c == '\u001b' || c == 'q') {
            this.shutdownDemo();
            return;
        }
        if (';' == c) {
            this.volume_alpha *= 1.1f;
        }
        if (':' == c) {
            this.volume_alpha /= 1.1f;
        }
        if ('\'' == c) {
            this.room_ambient += 0.025f;
        }
        if ('\"' == c) {
            this.room_ambient -= 0.025f;
        }
        if (',' == c) {
            ++this.curr_model;
            this.curr_model %= this.num_models;
        }
        if ('.' == c) {
            boolean bl2 = this.m[this.curr_model].draw = !this.m[this.curr_model].draw;
        }
        if ('w' == c) {
            this.toggleWireframe = true;
        }
        if ('1' == c) {
            // empty if block
        }
        if ('2' == c) {
            // empty if block
        }
        if ('3' == c) {
            // empty if block
        }
        if ('4' == c) {
            // empty if block
        }
        if ('5' == c) {
            // empty if block
        }
        if ('6' == c) {
            // empty if block
        }
        if ('7' == c) {
            // empty if block
        }
        if ('[' == c) {
            this.viewer.setZNear(this.viewer.getZNear() / 2.0f);
        }
        if (']' == c) {
            this.viewer.setZNear(this.viewer.getZNear() * 2.0f);
        }
        if ('{' == c) {
            this.viewer.setZFar(this.viewer.getZFar() / 2.0f);
        }
        if ('}' == c) {
            this.viewer.setZFar(this.viewer.getZFar() * 2.0f);
        }
        if ('!' == c) {
            this.enableDepthClampNV = true;
            this.toggleDepthClampNV = true;
        }
        if ('~' == c) {
            this.enableDepthClampNV = false;
            this.toggleDepthClampNV = true;
        }
        if ('a' == c) {
            this.animateForward = true;
        }
        if ('b' == c) {
            this.animateBackward = true;
        }
        if ('.' == c) {
            this.hideCurrentModel = true;
        }
        if ('n' == c) {
            this.light_object_scale *= 1.1f;
        }
        if ('N' == c) {
            this.light_object_scale /= 1.1f;
        }
        if ('L' == c) {
            if (this.b[c]) {
                this.light_position.set(0.0f, 0.0f, 0.0f, 1.0f);
            } else {
                this.light_position.set(0.25f, 0.25f, 1.0f, 0.0f);
            }
        }
        if ('c' == c) {
            this.doViewAll = true;
        }
    }

    private void initModel() {
        int n = 0;
        try {
            MD2.Model model2 = MD2.loadMD2((InputStream)this.getClass().getClassLoader().getResourceAsStream("demos/data/models/knight.md2"));
            this.m[n] = new Model();
            this.m[n].mod = model2;
            this.m[n].interp_frame = (MD2.Frame)this.m[n].mod.f[0].clone();
            this.m[n].ambient.componentMul(this.m[n].diffuse);
            ++n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.num_models = n;
    }

    private void interpolate_frame() {
        MD2.PositionNormal positionNormal;
        int n;
        float f = this.m[this.curr_model].frame_num - (float)Math.floor(this.m[this.curr_model].frame_num);
        int n2 = (int)Math.floor(this.m[this.curr_model].frame_num);
        int n3 = (int)Math.ceil(this.m[this.curr_model].frame_num) % this.m[this.curr_model].mod.f.length;
        MD2.Frame frame = this.m[this.curr_model].mod.f[n2];
        MD2.Frame frame2 = this.m[this.curr_model].mod.f[n3];
        for (n = 0; n < frame.pn.length; ++n) {
            positionNormal = this.m[this.curr_model].interp_frame.pn[n];
            MD2.PositionNormal positionNormal2 = frame.pn[n];
            MD2.PositionNormal positionNormal3 = frame2.pn[n];
            positionNormal.x = (1.0f - f) * positionNormal2.x + f * positionNormal3.x;
            positionNormal.y = (1.0f - f) * positionNormal2.y + f * positionNormal3.y;
            positionNormal.z = (1.0f - f) * positionNormal2.z + f * positionNormal3.z;
            positionNormal.nx = (1.0f - f) * positionNormal2.nx + f * positionNormal3.nx;
            positionNormal.ny = (1.0f - f) * positionNormal2.ny + f * positionNormal3.ny;
            positionNormal.nz = (1.0f - f) * positionNormal2.nz + f * positionNormal3.nz;
        }
        for (n = 0; n < frame.triplane.length; ++n) {
            positionNormal = this.m[this.curr_model].interp_frame.triplane[n];
            MD2.computePlane((MD2.PositionNormal)this.m[this.curr_model].interp_frame.pn[this.m[this.curr_model].mod.tri[n].v[0].pn_index], (MD2.PositionNormal)this.m[this.curr_model].interp_frame.pn[this.m[this.curr_model].mod.tri[n].v[1].pn_index], (MD2.PositionNormal)this.m[this.curr_model].interp_frame.pn[this.m[this.curr_model].mod.tri[n].v[2].pn_index], (MD2.Plane)positionNormal);
        }
    }

    private void drawShadowVolumeEndCaps(GL2 gL2, int n) {
        Vec4f vec4f = new Vec4f();
        Mat4f mat4f = new Mat4f(this.objectManipXform);
        mat4f.invertRigid();
        mat4f = mat4f.mul(this.lightManipXform);
        mat4f.xformVec(this.light_position, vec4f);
        MD2.PositionNormal[] positionNormalArray = this.m[n].interp_frame.pn;
        gL2.glPushMatrix();
        gL2.glMultMatrixf(this.getData(this.objectManipXform), 0);
        gL2.glBegin(4);
        for (int i = 0; i < this.m[n].mod.tri.length; ++i) {
            if (this.m[n].mod.tri[i].kill) continue;
            MD2.Plane plane2 = this.m[n].interp_frame.triplane[i];
            boolean bl = plane2.a * vec4f.get(0) + plane2.b * vec4f.get(1) + plane2.c * vec4f.get(2) + plane2.d * vec4f.get(3) >= 0.0f;
            for (int j = 0; j < 3; ++j) {
                MD2.PositionNormal positionNormal = positionNormalArray[this.m[n].mod.tri[i].v[j].pn_index];
                if (bl) {
                    gL2.glVertex4f(positionNormal.x, positionNormal.y, positionNormal.z, 1.0f);
                    continue;
                }
                gL2.glVertex4f(positionNormal.x * vec4f.get(3) - vec4f.get(0), positionNormal.y * vec4f.get(3) - vec4f.get(1), positionNormal.z * vec4f.get(3) - vec4f.get(2), 0.0f);
            }
        }
        gL2.glEnd();
        gL2.glPopMatrix();
    }

    private void drawModel(GL2 gL2, int n, boolean bl) {
        MD2.PositionNormal[] positionNormalArray = this.m[n].interp_frame.pn;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[]{0.2f, 0.2f, 0.2f, 0.2f};
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        gL2.glMaterialfv(1032, 4608, this.getData(this.m[n].ambient), 0);
        gL2.glMaterialfv(1032, 4609, this.getData(this.m[n].diffuse), 0);
        gL2.glMaterialfv(1032, 4610, this.getData(this.m[n].specular), 0);
        gL2.glMaterialf(1032, 5633, this.m[n].shininess);
        if (!bl) {
            gL2.glGetLightfv(16384, 4609, fArray3, 0);
            gL2.glLightfv(16384, 4609, fArray2, 0);
            gL2.glGetLightfv(16384, 4610, fArray4, 0);
            gL2.glLightfv(16384, 4610, fArray, 0);
        } else {
            gL2.glBlendFunc(1, 1);
            gL2.glEnable(3042);
            gL2.glStencilFunc(514, 128, -1);
            gL2.glStencilOp(7680, 7680, 7680);
            gL2.glEnable(2960);
            gL2.glDepthFunc(514);
        }
        gL2.glPushMatrix();
        gL2.glMultMatrixf(this.getData(this.objectManipXform), 0);
        gL2.glEnable(2896);
        gL2.glPolygonOffset(0.0f, -2.0f);
        gL2.glEnable(32823);
        gL2.glBegin(4);
        for (int i = 0; i < this.m[n].mod.tri.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                MD2.PositionNormal positionNormal = positionNormalArray[this.m[n].mod.tri[i].v[j].pn_index];
                gL2.glNormal3f(positionNormal.nx, positionNormal.ny, positionNormal.nz);
                gL2.glVertex4f(positionNormal.x, positionNormal.y, positionNormal.z, 1.0f);
            }
        }
        gL2.glEnd();
        gL2.glDisable(32823);
        gL2.glDisable(2896);
        gL2.glPopMatrix();
        gL2.glMaterialfv(1032, 4609, new float[]{0.8f, 0.8f, 0.8f, 1.0f}, 0);
        gL2.glMaterialfv(1032, 4610, new float[]{0.3f, 0.3f, 0.3f, 1.0f}, 0);
        if (!bl) {
            gL2.glLightfv(16384, 4609, fArray3, 0);
            gL2.glLightfv(16384, 4610, fArray4, 0);
        } else {
            gL2.glDisable(3042);
            gL2.glStencilFunc(519, 128, -1);
            gL2.glStencilOp(7680, 7680, 7680);
            gL2.glDepthFunc(513);
        }
    }

    private void drawMesh(GL2 gL2, float f, int n) {
        float f2 = f / 2.0f;
        float f3 = f / (float)(n - 1);
        gL2.glPushMatrix();
        gL2.glTranslatef(-f2, -f2, f2);
        gL2.glNormal3f(0.0f, 0.0f, -1.0f);
        float f4 = 0.0f;
        for (int i = 0; i < n - 1; ++i) {
            float f5 = 0.0f;
            gL2.glBegin(8);
            for (int j = 0; j < n; ++j) {
                gL2.glTexCoord2f(f4, f5);
                gL2.glVertex2f(f4, f5);
                gL2.glTexCoord2f(f4 + f3, f5);
                gL2.glVertex2f(f4 + f3, f5);
                f5 += f3;
            }
            gL2.glEnd();
            f4 += f3;
        }
        gL2.glPopMatrix();
    }

    private void drawCube(GL2 gL2) {
        gL2.glBindTexture(3553, this.wallTexObject);
        gL2.glEnable(3553);
        gL2.glPushMatrix();
        gL2.glCallList(this.faceDisplayList);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2.glCallList(this.faceDisplayList);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2.glCallList(this.faceDisplayList);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2.glCallList(this.faceDisplayList);
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        gL2.glCallList(this.faceDisplayList);
        gL2.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        gL2.glCallList(this.faceDisplayList);
        gL2.glPopMatrix();
        gL2.glDisable(3553);
    }

    private void drawRoom(GL2 gL2, boolean bl) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] fArray2 = new float[]{this.room_ambient, this.room_ambient, this.room_ambient, 1.0f};
        float[] fArray3 = new float[]{0.1f, 0.1f, 0.1f, 0.1f};
        float[] fArray4 = new float[]{0.7f, 0.7f, 0.7f, 0.7f};
        float[] fArray5 = new float[]{0.7f, 0.7f, 0.7f, 0.7f};
        float[] fArray6 = new float[4];
        float[] fArray7 = new float[4];
        float[] fArray8 = new float[4];
        float[] fArray9 = new float[4];
        gL2.glMaterialfv(1032, 4608, fArray2, 0);
        gL2.glMaterialfv(1032, 4609, new float[]{0.8f, 0.8f, 0.8f, 1.0f}, 0);
        gL2.glMaterialfv(1032, 4610, new float[]{0.4f, 0.4f, 0.4f, 1.0f}, 0);
        gL2.glMaterialf(1032, 5633, 64.0f);
        if (!bl) {
            gL2.glGetLightfv(16384, 4609, fArray8, 0);
            gL2.glLightfv(16384, 4609, fArray3, 0);
            gL2.glGetLightfv(16384, 4610, fArray9, 0);
            gL2.glLightfv(16384, 4610, fArray, 0);
            gL2.glStencilFunc(519, 128, -1);
        } else {
            gL2.glGetLightfv(16384, 5632, fArray6, 0);
            gL2.glLightfv(16384, 5632, fArray, 0);
            gL2.glGetLightfv(16384, 4608, fArray7, 0);
            gL2.glLightfv(16384, 4608, fArray, 0);
            gL2.glLightfv(16384, 4609, fArray4, 0);
            gL2.glLightfv(16384, 4610, fArray5, 0);
            gL2.glBlendFunc(1, 1);
            gL2.glEnable(3042);
            gL2.glStencilFunc(514, 128, -1);
            gL2.glDepthFunc(514);
        }
        gL2.glPushMatrix();
        gL2.glTranslatef(0.0f, 9.0f, 0.0f);
        gL2.glEnable(2896);
        gL2.glStencilOp(7680, 7680, 7680);
        gL2.glEnable(2960);
        this.drawCube(gL2);
        gL2.glStencilFunc(519, 128, -1);
        gL2.glStencilOp(7680, 7680, 7680);
        gL2.glDisable(2896);
        gL2.glPopMatrix();
        if (!bl) {
            gL2.glLightfv(16384, 4609, fArray8, 0);
            gL2.glLightfv(16384, 4610, fArray9, 0);
        } else {
            gL2.glLightfv(16384, 5632, fArray6, 0);
            gL2.glLightfv(16384, 4608, fArray7, 0);
            gL2.glDisable(3042);
            gL2.glDepthFunc(513);
        }
    }

    private void drawShadowVolumeEdges(GL2 gL2, int n, int n2, boolean bl, boolean bl2) {
        Vec4f vec4f = new Vec4f();
        Mat4f mat4f = new Mat4f(this.objectManipXform);
        mat4f.invertRigid();
        mat4f = mat4f.mul(this.lightManipXform);
        mat4f.xformVec(this.light_position, vec4f);
        gL2.glPushMatrix();
        gL2.glMultMatrixf(this.getData(this.objectManipXform), 0);
        MD2.Frame frame = this.m[n].interp_frame;
        gL2.glBegin(n2);
        for (int i = 0; i < this.m[n].mod.edge.length; ++i) {
            Object object;
            MD2.WingedEdge wingedEdge = this.m[n].mod.edge[i];
            if (wingedEdge.w[0] == -1 || this.m[n].mod.tri[wingedEdge.w[0]].kill || wingedEdge.w[1] == -1 || this.m[n].mod.tri[wingedEdge.w[1]].kill) continue;
            MD2.Plane plane2 = frame.triplane[wingedEdge.w[0]];
            float f = plane2.a * vec4f.get(0) + plane2.b * vec4f.get(1) + plane2.c * vec4f.get(2) + plane2.d * vec4f.get(3);
            float f2 = -f;
            if (wingedEdge.w[1] != -1) {
                object = frame.triplane[wingedEdge.w[1]];
                f2 = object.a * vec4f.get(0) + object.b * vec4f.get(1) + object.c * vec4f.get(2) + object.d * vec4f.get(3);
            }
            object = new int[2];
            if (f >= 0.0f && f2 < 0.0f) {
                object[0] = wingedEdge.e[1];
                object[1] = wingedEdge.e[0];
            } else {
                if (!(f2 >= 0.0f) || !(f < 0.0f)) continue;
                object[0] = wingedEdge.e[0];
                object[1] = wingedEdge.e[1];
            }
            MD2.PositionNormal positionNormal = frame.pn[object[0]];
            MD2.PositionNormal positionNormal2 = frame.pn[object[1]];
            if (n2 == 7 || bl) {
                gL2.glVertex4f(positionNormal.x, positionNormal.y, positionNormal.z, 1.0f);
                gL2.glVertex4f(positionNormal2.x, positionNormal2.y, positionNormal2.z, 1.0f);
            }
            if (n2 != 7 && !bl2) continue;
            gL2.glVertex4f(positionNormal2.x * vec4f.get(3) - vec4f.get(0), positionNormal2.y * vec4f.get(3) - vec4f.get(1), positionNormal2.z * vec4f.get(3) - vec4f.get(2), 0.0f);
            gL2.glVertex4f(positionNormal.x * vec4f.get(3) - vec4f.get(0), positionNormal.y * vec4f.get(3) - vec4f.get(1), positionNormal.z * vec4f.get(3) - vec4f.get(2), 0.0f);
        }
        gL2.glEnd();
        gL2.glPopMatrix();
    }

    private void drawShadowVolumeExtrudedEdges(GL2 gL2, int n) {
        this.drawShadowVolumeEdges(gL2, n, 7, true, true);
    }

    private void drawPossibleSilhouette(GL2 gL2, int n) {
        gL2.glLineWidth(3.0f);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        this.drawShadowVolumeEdges(gL2, n, 1, true, !this.b[45]);
        gL2.glLineWidth(1.0f);
    }

    private void drawShadowVolumeToStencil(GL2 gL2, int n) {
        gL2.glDepthFunc(513);
        gL2.glDepthMask(false);
        gL2.glStencilFunc(519, 128, -1);
        gL2.glEnable(2960);
        gL2.glEnable(2884);
        gL2.glCullFace(1028);
        gL2.glStencilOp(7680, 7682, 7680);
        gL2.glColorMask(false, false, false, false);
        this.drawShadowVolumeExtrudedEdges(gL2, n);
        this.drawShadowVolumeEndCaps(gL2, n);
        gL2.glCullFace(1029);
        gL2.glStencilOp(7680, 7683, 7680);
        this.drawShadowVolumeExtrudedEdges(gL2, n);
        this.drawShadowVolumeEndCaps(gL2, n);
        gL2.glColorMask(true, true, true, true);
        gL2.glDisable(2884);
        gL2.glStencilFunc(519, 128, -1);
        gL2.glStencilOp(7680, 7680, 7680);
        gL2.glDepthMask(true);
        gL2.glDepthFunc(513);
    }

    private void drawShadowVolumeToColor(GL2 gL2, int n) {
        gL2.glDepthFunc(513);
        gL2.glDepthMask(false);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 771);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 0.7f * this.volume_alpha);
        this.drawShadowVolumeEndCaps(gL2, n);
        gL2.glColor4f(1.0f, 1.0f, 0.7f, 0.15f * this.volume_alpha);
        this.drawShadowVolumeExtrudedEdges(gL2, n);
        gL2.glDepthMask(true);
        gL2.glDepthFunc(513);
        gL2.glDisable(3042);
    }

    private void drawLight(GL2 gL2) {
        gL2.glColor3f(1.0f, 1.0f, 0.0f);
        gL2.glPushMatrix();
        gL2.glMultMatrixf(this.getData(this.lightManipXform), 0);
        gL2.glScalef(this.light_object_scale, this.light_object_scale, this.light_object_scale);
        if (this.b[76]) {
            this.glut.glutSolidSphere((double)0.01f, 20, 10);
        } else {
            Vec3f vec3f = new Vec3f(this.light_position.get(0), this.light_position.get(1), this.light_position.get(2));
            Rotf rotf = new Rotf(new Vec3f(0.0f, 0.0f, 1.0f), vec3f);
            Mat4f mat4f = new Mat4f();
            mat4f.makeIdent();
            mat4f.setRotation(rotf);
            mat4f = mat4f.mul(this.perspectiveInverse(30.0f, 1.0f, 0.001f, 0.04f));
            gL2.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            gL2.glTranslatef(0.0f, 0.0f, -0.02f);
            gL2.glMultMatrixf(this.getData(mat4f), 0);
            this.glut.glutSolidCube(2.0f);
        }
        gL2.glPopMatrix();
    }

    private Mat4f infiniteFrustum(float f, float f2, float f3, float f4, float f5) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, 2.0f * f5 / (f2 - f));
        mat4f.set(0, 2, (f2 + f) / (f2 - f));
        mat4f.set(1, 1, 2.0f * f5 / (f4 - f3));
        mat4f.set(1, 2, (f4 + f3) / (f4 - f3));
        float f6 = 0.9999999f;
        mat4f.set(2, 2, -1.0f * f6);
        mat4f.set(2, 3, -2.0f * f5 * f6);
        mat4f.set(3, 2, -1.0f);
        mat4f.set(3, 3, 0.0f);
        mat4f.transpose();
        return mat4f;
    }

    private Mat4f infiniteFrustumInverse(float f, float f2, float f3, float f4, float f5) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, (f2 - f) / (2.0f * f5));
        mat4f.set(0, 3, (f2 + f) / (2.0f * f5));
        mat4f.set(1, 1, (f4 - f3) / (2.0f * f5));
        mat4f.set(1, 3, (f4 + f3) / (2.0f * f5));
        mat4f.set(2, 2, 0.0f);
        mat4f.set(2, 3, -1.0f);
        mat4f.set(3, 2, -1.0f / (2.0f * f5));
        mat4f.set(3, 3, 1.0f / (2.0f * f5));
        return mat4f;
    }

    private Mat4f infinitePerspective(float f, float f2, float f3) {
        float f4 = (float)Math.tan((double)f / 2.0);
        float f5 = f4 * f3;
        float f6 = f2 * f5;
        return this.infiniteFrustum(-f6, f6, -f5, f5, f3);
    }

    private Mat4f infinitePerspectiveInverse(float f, float f2, float f3) {
        float f4 = (float)Math.tan((double)f / 2.0);
        float f5 = f4 * f3;
        float f6 = f2 * f5;
        return this.infiniteFrustumInverse(-f6, f6, -f5, f5, f3);
    }

    private void applyInfinitePerspective(GL2 gL2, ExaminerViewer examinerViewer) {
        CameraParameters cameraParameters = examinerViewer.getCameraParameters();
        float f = cameraParameters.getImagePlaneAspectRatio();
        gL2.glMultMatrixf(this.getData(this.infinitePerspective(cameraParameters.getVertFOV(), f, examinerViewer.getZNear())), 0);
    }

    private void applyInfinitePerspectiveInverse(GL2 gL2, ExaminerViewer examinerViewer) {
        CameraParameters cameraParameters = examinerViewer.getCameraParameters();
        float f = cameraParameters.getImagePlaneAspectRatio();
        gL2.glMultMatrixf(this.getData(this.infinitePerspectiveInverse(cameraParameters.getVertFOV(), f, examinerViewer.getZNear())), 0);
    }

    private Mat4f perspectiveInverse(float f, float f2, float f3, float f4) {
        float f5 = (float)Math.tan(Math.toRadians((double)f / 2.0));
        float f6 = f5 * f3;
        float f7 = f2 * f6;
        return this.frustumInverse(-f7, f7, -f6, f6, f3, f4);
    }

    private Mat4f frustumInverse(float f, float f2, float f3, float f4, float f5, float f6) {
        Mat4f mat4f = new Mat4f();
        mat4f.makeIdent();
        mat4f.set(0, 0, (f2 - f) / (2.0f * f5));
        mat4f.set(0, 3, (f2 + f) / (2.0f * f5));
        mat4f.set(1, 1, (f4 - f3) / (2.0f * f5));
        mat4f.set(1, 3, (f4 + f3) / (2.0f * f5));
        mat4f.set(2, 2, 0.0f);
        mat4f.set(2, 3, -1.0f);
        mat4f.set(3, 2, -(f6 - f5) / (2.0f * f6 * f5));
        mat4f.set(3, 3, (f6 + f5) / (2.0f * f6 * f5));
        return mat4f;
    }

    private float[] getData(Vec4f vec4f) {
        return new float[]{vec4f.x(), vec4f.y(), vec4f.z(), vec4f.w()};
    }

    private float[] getData(Mat4f mat4f) {
        float[] fArray = new float[16];
        mat4f.getColumnMajorData(fArray);
        return fArray;
    }

    private static void runExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        }).start();
    }

    static class Model {
        MD2.Model mod;
        MD2.Frame interp_frame;
        float frame_num = 0.0f;
        float frame_incr = 0.25f;
        Vec4f ambient = new Vec4f(0.1f, 0.1f, 0.1f, 1.0f);
        Vec4f diffuse = new Vec4f(0.8f, 0.0f, 0.0f, 1.0f);
        Vec4f specular = new Vec4f(0.6f, 0.6f, 0.6f, 1.0f);
        float shininess = 64.0f;
        boolean draw = true;

        Model() {
        }
    }
}

