/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.TextRenderer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import demos.common.Demo;
import demos.util.FPSCounter;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.linalg.Vec2f;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlyingText
extends Demo {
    private static final float INIT_ANG_VEL_MAG = 0.3f;
    private static final float INIT_VEL_MAG = 400.0f;
    private static final int DEFAULT_DROP_SHADOW_DIST = 20;
    private final List<TextInfo> textInfo = new ArrayList<TextInfo>();
    private int dropShadowDistance = 20;
    private Time time;
    private Texture backgroundTexture;
    private TextRenderer renderer;
    private final Random random = new Random();
    private final GLU glu = new GLU();
    private int width;
    private int height;
    private int maxTextWidth;
    private FPSCounter fps;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Flying Text");
        jFrame.getContentPane().setLayout(new BorderLayout());
        GLCanvas gLCanvas = new GLCanvas();
        FlyingText flyingText = new FlyingText();
        gLCanvas.addGLEventListener((GLEventListener)flyingText);
        jFrame.getContentPane().add((Component)gLCanvas, "Center");
        jFrame.getContentPane().add((Component)flyingText.buildGUI(), "North");
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        jFrame.setSize((int)(0.75f * (float)displayMode.getWidth()), (int)(0.75f * (float)displayMode.getHeight()));
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        jFrame.setVisible(true);
        animator.start();
    }

    public Container buildGUI() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Less Text");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlyingText.this.lessText();
            }
        });
        jPanel.add(jButton);
        final JSlider jSlider = new JSlider(0, this.getMinDropShadowDistance(), this.getMaxDropShadowDistance(), this.getDropShadowDistance());
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FlyingText.this.setDropShadowDistance(jSlider.getValue());
            }
        });
        jPanel.add(jSlider);
        jButton = new JButton("More Text");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlyingText.this.moreText();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    public void moreText() {
        int n = (int)((float)this.textInfo.size() * 0.5f);
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.textInfo.add(this.randomTextInfo());
        }
    }

    public void lessText() {
        if (this.textInfo.size() == 1) {
            return;
        }
        int n = this.textInfo.size() / 3;
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            this.textInfo.remove(this.textInfo.size() - 1);
        }
    }

    public int getDropShadowDistance() {
        return this.dropShadowDistance;
    }

    public int getMinDropShadowDistance() {
        return 1;
    }

    public int getMaxDropShadowDistance() {
        return 30;
    }

    public void setDropShadowDistance(int n) {
        this.dropShadowDistance = n;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        BufferedImage bufferedImage = new BufferedImage(2, 2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(new Color(0.3f, 0.3f, 0.3f));
        graphics2D.fillRect(0, 0, 2, 2);
        graphics2D.setColor(new Color(0.7f, 0.7f, 0.7f));
        graphics2D.fillRect(0, 0, 1, 1);
        graphics2D.fillRect(1, 1, 1, 1);
        graphics2D.dispose();
        this.backgroundTexture = AWTTextureIO.newTexture((GLProfile)gL.getGLProfile(), (BufferedImage)bufferedImage, (boolean)false);
        this.backgroundTexture.bind(gL);
        this.backgroundTexture.setTexParameteri(gL, 10241, 9728);
        this.backgroundTexture.setTexParameteri(gL, 10240, 9728);
        this.backgroundTexture.setTexParameteri(gL, 10242, 10497);
        this.backgroundTexture.setTexParameteri(gL, 10243, 10497);
        this.renderer = new TextRenderer(new Font("Serif", 0, 72), true, true);
        this.fps = new FPSCounter((GLDrawable)gLAutoDrawable, 36);
        this.width = gLAutoDrawable.getSurfaceWidth();
        this.height = gLAutoDrawable.getSurfaceHeight();
        this.maxTextWidth = (int)this.renderer.getBounds("Java 2D").getWidth();
        this.maxTextWidth = Math.max(this.maxTextWidth, (int)this.renderer.getBounds("OpenGL").getWidth());
        this.textInfo.clear();
        for (int i = 0; i < 100; ++i) {
            this.textInfo.add(this.randomTextInfo());
        }
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        gL.glDisable(2929);
        gL.setSwapInterval(0);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.backgroundTexture = null;
        this.renderer = null;
        this.fps = null;
        this.time = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        int n;
        TextInfo textInfo2;
        this.time.update();
        float f = (float)this.time.deltaT();
        Vec2f vec2f = new Vec2f();
        for (TextInfo textInfo2 : this.textInfo) {
            if (this.random.nextInt(1000) == 0) {
                textInfo2.angularVelocity = 0.3f * (this.randomAngle() - 180.0f);
                textInfo2.velocity = this.randomVelocityVec2f(400.0f, 400.0f);
            }
            textInfo2.angle += textInfo2.angularVelocity * f;
            vec2f.set(textInfo2.velocity);
            vec2f.scale(f);
            textInfo2.position.add(vec2f);
            textInfo2.curTime += f;
            if ((double)textInfo2.curTime > Math.PI * 2) {
                textInfo2.curTime = (float)((double)textInfo2.curTime - Math.PI * 2);
            }
            n = Color.HSBtoRGB(textInfo2.h, (float)(0.5 * (1.0 + Math.sin(textInfo2.curTime)) * (double)textInfo2.s), textInfo2.v);
            textInfo2.r = (float)(n >> 16 & 0xFF) / 255.0f;
            textInfo2.g = (float)(n >> 8 & 0xFF) / 255.0f;
            textInfo2.b = (float)(n & 0xFF) / 255.0f;
            if (textInfo2.angle < 0.0f) {
                textInfo2.angle += 360.0f;
            } else if (textInfo2.angle > 360.0f) {
                textInfo2.angle -= 360.0f;
            }
            if (textInfo2.position.x() < (float)(-this.maxTextWidth)) {
                textInfo2.position.setX(textInfo2.position.x() + (float)gLAutoDrawable.getSurfaceWidth() + (float)(2 * this.maxTextWidth));
            } else if (textInfo2.position.x() > (float)(gLAutoDrawable.getSurfaceWidth() + this.maxTextWidth)) {
                textInfo2.position.setX(textInfo2.position.x() - (float)gLAutoDrawable.getSurfaceWidth() - (float)(2 * this.maxTextWidth));
            }
            if (textInfo2.position.y() < (float)(-this.maxTextWidth)) {
                textInfo2.position.setY(textInfo2.position.y() + (float)gLAutoDrawable.getSurfaceHeight() + (float)(2 * this.maxTextWidth));
                continue;
            }
            if (!(textInfo2.position.y() > (float)(gLAutoDrawable.getSurfaceHeight() + this.maxTextWidth))) continue;
            textInfo2.position.setY(textInfo2.position.y() - (float)gLAutoDrawable.getSurfaceHeight() - (float)(2 * this.maxTextWidth));
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16384);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, (float)gLAutoDrawable.getSurfaceWidth(), 0.0f, (float)gLAutoDrawable.getSurfaceHeight());
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        this.backgroundTexture.enable((GL)gL2);
        this.backgroundTexture.bind((GL)gL2);
        textInfo2 = this.backgroundTexture.getImageTexCoords();
        n = gLAutoDrawable.getSurfaceWidth();
        int n2 = gLAutoDrawable.getSurfaceHeight();
        float f2 = (float)n / 100.0f;
        float f3 = (float)n2 / 100.0f;
        gL2.glTexEnvi(8960, 8704, 7681);
        gL2.glBegin(7);
        gL2.glTexCoord2f(f2 * textInfo2.left(), f3 * textInfo2.bottom());
        gL2.glVertex3f(0.0f, 0.0f, 0.0f);
        gL2.glTexCoord2f(f2 * textInfo2.right(), f3 * textInfo2.bottom());
        gL2.glVertex3f((float)n, 0.0f, 0.0f);
        gL2.glTexCoord2f(f2 * textInfo2.right(), f3 * textInfo2.top());
        gL2.glVertex3f((float)n, (float)n2, 0.0f);
        gL2.glTexCoord2f(f2 * textInfo2.left(), f3 * textInfo2.top());
        gL2.glVertex3f(0.0f, (float)n2, 0.0f);
        gL2.glEnd();
        this.backgroundTexture.disable((GL)gL2);
        this.renderer.beginRendering(gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        gL2.glMatrixMode(5888);
        this.renderer.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        for (TextInfo textInfo3 : this.textInfo) {
            gL2.glLoadIdentity();
            gL2.glTranslatef(textInfo3.position.x() + (float)this.dropShadowDistance, textInfo3.position.y() - (float)this.dropShadowDistance, 0.0f);
            gL2.glRotatef(textInfo3.angle, 0.0f, 0.0f, 1.0f);
            this.renderer.draw(textInfo3.text, 0, 0);
            this.renderer.flush();
        }
        for (TextInfo textInfo3 : this.textInfo) {
            gL2.glLoadIdentity();
            gL2.glTranslatef(textInfo3.position.x(), textInfo3.position.y(), 0.0f);
            gL2.glRotatef(textInfo3.angle, 0.0f, 0.0f, 1.0f);
            this.renderer.setColor(textInfo3.r, textInfo3.g, textInfo3.b, 1.0f);
            this.renderer.draw(textInfo3.text, 0, 0);
            this.renderer.flush();
        }
        this.renderer.endRendering();
        this.fps.draw();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private TextInfo randomTextInfo() {
        TextInfo textInfo = new TextInfo();
        textInfo.text = this.randomString();
        textInfo.angle = this.randomAngle();
        textInfo.position = this.randomVec2f(this.width, this.height);
        textInfo.angularVelocity = 0.3f * (this.randomAngle() - 180.0f);
        textInfo.velocity = this.randomVelocityVec2f(400.0f, 400.0f);
        Color color = this.randomColor();
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        textInfo.h = fArray[0];
        textInfo.s = fArray[1];
        textInfo.v = fArray[2];
        textInfo.curTime = (float)(Math.PI * 2 * (double)this.random.nextFloat());
        return textInfo;
    }

    private String randomString() {
        switch (this.random.nextInt(3)) {
            case 0: {
                return "OpenGL";
            }
            case 1: {
                return "Java 2D";
            }
        }
        return "Text";
    }

    private float randomAngle() {
        return 360.0f * this.random.nextFloat();
    }

    private Vec2f randomVec2f(float f, float f2) {
        return new Vec2f(f * this.random.nextFloat(), f2 * this.random.nextFloat());
    }

    private Vec2f randomVelocityVec2f(float f, float f2) {
        return new Vec2f(f * (this.random.nextFloat() - 0.5f), f2 * (this.random.nextFloat() - 0.5f));
    }

    private Color randomColor() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        do {
            f = this.random.nextFloat();
            f2 = this.random.nextFloat();
            f3 = this.random.nextFloat();
            float[] fArray = Color.RGBtoHSB((int)(255.0f * f), (int)(255.0f * f2), (int)(255.0f * f3), null);
            f4 = fArray[1];
        } while (f < 0.8f && f2 < 0.8f && f3 < 0.8f || f4 < 0.8f);
        return new Color(f, f2, f3);
    }

    private static class TextInfo {
        float angularVelocity;
        Vec2f velocity;
        float angle;
        Vec2f position;
        float h;
        float s;
        float v;
        float curTime;
        float r;
        float g;
        float b;
        String text;

        private TextInfo() {
        }
    }
}

