/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.TextureRenderer;
import demos.gears.Gears;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.linalg.Vec2f;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.text.DecimalFormat;

public class TestTextureRenderer
implements GLEventListener {
    private TextureRenderer renderer;
    private Time time;
    private Font font;
    private final Color TRANSPARENT_BLACK = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private final Vec2f velocity = new Vec2f(100.0f, 150.0f);
    private Vec2f position;
    private Rectangle textBounds;
    private Rectangle fpsBounds;
    private final String TEST_STRING = "Java 2D Text";
    private long startTime;
    private int frameCount;
    private final DecimalFormat format = new DecimalFormat("####.00");

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Java 2D Renderer Test");
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        gLCapabilities.setAlphaBits(8);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        gLCanvas.addGLEventListener((GLEventListener)new Gears());
        gLCanvas.addGLEventListener((GLEventListener)new TestTextureRenderer());
        frame.add((Component)gLCanvas);
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        frame.setVisible(true);
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(0);
        this.renderer = new TextureRenderer(256, 256, true);
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
        this.position = new Vec2f(0.0f, (float)(gLAutoDrawable.getSurfaceHeight() / 2));
        this.font = new Font("SansSerif", 1, 36);
        Graphics2D graphics2D = this.renderer.createGraphics();
        graphics2D.setFont(this.font);
        graphics2D.setComposite(AlphaComposite.Src);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, "Java 2D Text");
        graphics2D.setColor(this.TRANSPARENT_BLACK);
        graphics2D.fillRect(0, 0, this.renderer.getWidth(), this.renderer.getHeight());
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString("Java 2D Text", 10, 50);
        this.textBounds = glyphVector.getPixelBounds(fontRenderContext, 10.0f, 50.0f);
        this.renderer.markDirty(this.textBounds.x, this.textBounds.y, this.textBounds.width, this.textBounds.height);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.renderer = null;
        this.textBounds = null;
        this.position = null;
        this.time = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (++this.frameCount == 100) {
            long l = System.currentTimeMillis();
            float f = 100.0f / (float)(l - this.startTime) * 1000.0f;
            this.frameCount = 0;
            this.startTime = System.currentTimeMillis();
            Graphics2D graphics2D = this.renderer.createGraphics();
            graphics2D.setFont(this.font);
            graphics2D.setComposite(AlphaComposite.Src);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string = "FPS: " + this.format.format(f);
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, "Java 2D Text");
            this.fpsBounds = glyphVector.getPixelBounds(fontRenderContext, 10.0f, 100.0f);
            graphics2D.setColor(this.TRANSPARENT_BLACK);
            graphics2D.fillRect(this.fpsBounds.x, this.fpsBounds.y, this.fpsBounds.width, this.fpsBounds.height);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(string, 10, 100);
            this.renderer.markDirty(this.fpsBounds.x, this.fpsBounds.y, this.fpsBounds.width, this.fpsBounds.height);
        }
        this.time.update();
        this.position = this.position.plus(this.velocity.times((float)this.time.deltaT()));
        Rectangle rectangle = new Rectangle((int)this.position.x(), (int)this.position.y(), this.textBounds.width, this.textBounds.height);
        if (rectangle.getMinX() < 0.0) {
            this.velocity.setX(Math.abs(this.velocity.x()));
        } else if (rectangle.getMaxX() > (double)gLAutoDrawable.getSurfaceWidth()) {
            this.velocity.setX(-1.0f * Math.abs(this.velocity.x()));
        }
        if (rectangle.getMinY() < 0.0) {
            this.velocity.setY(Math.abs(this.velocity.y()));
        } else if (rectangle.getMaxY() > (double)gLAutoDrawable.getSurfaceHeight()) {
            this.velocity.setY(-1.0f * Math.abs(this.velocity.y()));
        }
        this.renderer.beginOrthoRendering(gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        this.renderer.drawOrthoRect((int)this.position.x(), (int)this.position.y(), this.textBounds.x, this.renderer.getHeight() - this.textBounds.y - this.textBounds.height, this.textBounds.width, this.textBounds.height);
        if (this.fpsBounds != null) {
            this.renderer.drawOrthoRect(gLAutoDrawable.getSurfaceWidth() - this.fpsBounds.width, 20, this.fpsBounds.x, this.renderer.getHeight() - this.fpsBounds.y - this.fpsBounds.height, this.fpsBounds.width, this.fpsBounds.height);
        }
        this.renderer.endOrthoRendering();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

