/*
 * Decompiled with CFR 0.152.
 */
package demos.j2d;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.awt.TextRenderer;
import demos.common.Demo;
import demos.util.FPSCounter;
import demos.util.SystemTime;
import demos.util.Time;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;

public class TextCube
extends Demo {
    private float xAng;
    private float yAng;
    private GLU glu = new GLU();
    private Time time;
    private TextRenderer renderer;
    private FPSCounter fps;
    private float textScaleFactor;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Text Cube");
        frame.setLayout(new BorderLayout());
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        TextCube textCube = new TextCube();
        gLCanvas.addGLEventListener((GLEventListener)textCube);
        frame.add((Component)gLCanvas, "Center");
        frame.setSize(512, 512);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        frame.setVisible(true);
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.renderer = new TextRenderer(new Font("SansSerif", 0, 72));
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glEnable(2929);
        Rectangle2D rectangle2D = this.renderer.getBounds("Bottom");
        float f = (float)rectangle2D.getWidth();
        this.textScaleFactor = 1.0f / (f * 1.1f);
        this.fps = new FPSCounter((GLDrawable)gLAutoDrawable, 36);
        this.time = new SystemTime();
        ((SystemTime)this.time).rebase();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        this.glu.gluLookAt(0.0f, 0.0f, 10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        gL2.glRotatef(this.xAng, 1.0f, 0.0f, 0.0f);
        gL2.glRotatef(this.yAng, 0.0f, 1.0f, 0.0f);
        gL2.glPushMatrix();
        gL2.glRotatef(-90.0f, 1.0f, 0.0f, 0.0f);
        this.drawFace(gL2, 1.0f, 0.2f, 0.2f, 0.8f, "Top");
        gL2.glPopMatrix();
        this.drawFace(gL2, 1.0f, 0.8f, 0.2f, 0.2f, "Front");
        gL2.glPushMatrix();
        gL2.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL2, 1.0f, 0.2f, 0.8f, 0.2f, "Right");
        gL2.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL2, 1.0f, 0.8f, 0.8f, 0.2f, "Back");
        gL2.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.drawFace(gL2, 1.0f, 0.2f, 0.8f, 0.8f, "Left");
        gL2.glPopMatrix();
        gL2.glPushMatrix();
        gL2.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        this.drawFace(gL2, 1.0f, 0.8f, 0.2f, 0.8f, "Bottom");
        gL2.glPopMatrix();
        this.fps.draw();
        this.time.update();
        this.xAng += 200.0f * (float)this.time.deltaT();
        this.yAng += 150.0f * (float)this.time.deltaT();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluPerspective(15.0f, (float)n3 / (float)n4, 5.0f, 15.0f);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void drawFace(GL2 gL2, float f, float f2, float f3, float f4, String string) {
        float f5 = f / 2.0f;
        gL2.glColor3f(f2, f3, f4);
        gL2.glBegin(7);
        gL2.glVertex3f(-f5, -f5, f5);
        gL2.glVertex3f(f5, -f5, f5);
        gL2.glVertex3f(f5, f5, f5);
        gL2.glVertex3f(-f5, f5, f5);
        gL2.glEnd();
        this.renderer.begin3DRendering();
        gL2.glDisable(2929);
        gL2.glEnable(2884);
        Rectangle2D rectangle2D = this.renderer.getBounds(string);
        float f6 = (float)rectangle2D.getWidth();
        float f7 = (float)rectangle2D.getHeight();
        this.renderer.draw3D(string, f6 / -2.0f * this.textScaleFactor, f7 / -2.0f * this.textScaleFactor, f5, this.textScaleFactor);
        this.renderer.end3DRendering();
    }
}

