/*
 * Decompiled with CFR 0.152.
 */
package demos.jgears;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.Animator;
import demos.gears.Gears;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JGears
extends GLJPanel {
    private static GLCapabilities caps;
    private long startTime;
    private int frameCount;
    private float fps;
    private static Font fpsFont;
    private final DecimalFormat format = new DecimalFormat("####.00");
    private BufferedImage javaImage;
    private BufferedImage openglImage;

    public JGears() {
        super((GLCapabilitiesImmutable)caps, null);
        this.addGLEventListener(new Gears());
        try {
            InputStream inputStream = JGears.class.getClassLoader().getResourceAsStream("demos/data/images/java_logo.png");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            this.javaImage = this.scaleImage(bufferedImage, 0.25f, 0.25f);
            inputStream = JGears.class.getClassLoader().getResourceAsStream("demos/data/images/opengl_logo.png");
            bufferedImage = ImageIO.read(inputStream);
            this.openglImage = this.scaleImage(bufferedImage, 0.45f, 0.45f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (++this.frameCount == 30) {
            long l = System.currentTimeMillis();
            this.fps = 30.0f / (float)(l - this.startTime) * 1000.0f;
            this.frameCount = 0;
            this.startTime = System.currentTimeMillis();
        }
        if (this.fps > 0.0f) {
            graphics.setColor(Color.WHITE);
            graphics.setFont(fpsFont);
            graphics.drawString("FPS: " + this.format.format(this.fps), this.getWidth() - 140, this.getHeight() - 30);
        }
        int n = 10;
        if (this.javaImage != null) {
            graphics.drawImage(this.javaImage, n, this.getHeight() - this.javaImage.getHeight() - n, null);
            if (this.openglImage != null) {
                graphics.drawImage(this.openglImage, n + this.javaImage.getWidth() + n, this.getHeight() - this.openglImage.getHeight() - n, null);
            }
        }
    }

    public static JPanel createGradientPanel() {
        JPanel jPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                ((Graphics2D)graphics).setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, this.getWidth(), this.getHeight(), Color.DARK_GRAY));
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        jPanel.setLayout(new BorderLayout());
        return jPanel;
    }

    private BufferedImage scaleImage(BufferedImage bufferedImage, float f, float f2) {
        BufferedImage bufferedImage2 = new BufferedImage((int)((float)bufferedImage.getWidth() * f), (int)((float)bufferedImage.getHeight() * f2), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawRenderedImage(bufferedImage, AffineTransform.getScaleInstance(f, f2));
        return bufferedImage2;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Gear Demo");
        jFrame.getContentPane().setLayout(new BorderLayout());
        final JGears jGears = new JGears();
        jGears.setOpaque(false);
        JPanel jPanel = JGears.createGradientPanel();
        jFrame.getContentPane().add((Component)jPanel, "Center");
        jPanel.add((Component)((Object)jGears), "Center");
        final JCheckBox jCheckBox = new JCheckBox("Transparent", true);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jGears.setOpaque(!jCheckBox.isSelected());
            }
        });
        jFrame.getContentPane().add((Component)jCheckBox, "South");
        jFrame.setSize(300, 300);
        final Animator animator = new Animator((GLAutoDrawable)jGears);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        });
        jFrame.setVisible(true);
        animator.start();
    }

    static {
        fpsFont = new Font("SansSerif", 1, 24);
        caps = new GLCapabilities(GLProfile.get((String)"GL2"));
        caps.setAlphaBits(8);
    }
}

