/*
 * Decompiled with CFR 0.152.
 */
package demos.joal;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALut;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SingleStaticSource {
    static final String audioFile = "demos/data/sound/FancyPants.wav";
    private AL al;
    private int[] buffer = new int[1];
    private int[] source = new int[1];
    private float[] sourcePos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] sourceVel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerPos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerVel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] listenerOri = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private boolean initialized = false;

    public SingleStaticSource(boolean bl) {
        this(bl, null, true);
    }

    public SingleStaticSource(boolean bl, Container container, boolean bl2) {
        if (bl) {
            JFrame jFrame = null;
            if (container == null) {
                jFrame = new JFrame("Single Static Source - DevMaster OpenAL Lesson 1");
                jFrame.setDefaultCloseOperation(3);
                container = jFrame.getContentPane();
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(bl2 ? 4 : 3, 1));
            JButton jButton = new JButton("Play sound");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SingleStaticSource.this.initialize()) {
                        System.exit(1);
                    }
                    SingleStaticSource.this.al.alSourcePlay(SingleStaticSource.this.source[0]);
                }
            });
            jPanel.add(jButton);
            jButton = new JButton("Stop playing");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SingleStaticSource.this.initialize()) {
                        System.exit(1);
                    }
                    SingleStaticSource.this.al.alSourceStop(SingleStaticSource.this.source[0]);
                }
            });
            jPanel.add(jButton);
            jButton = new JButton("Pause sound");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!SingleStaticSource.this.initialize()) {
                        System.exit(1);
                    }
                    SingleStaticSource.this.al.alSourcePause(SingleStaticSource.this.source[0]);
                }
            });
            jPanel.add(jButton);
            if (bl2) {
                jButton = new JButton("Quit");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!SingleStaticSource.this.initialize()) {
                            System.exit(1);
                        }
                        SingleStaticSource.this.killAllData();
                        System.exit(0);
                    }
                });
                jPanel.add(jButton);
            }
            container.add(jPanel);
            if (jFrame != null) {
                jFrame.pack();
                jFrame.setVisible(true);
            }
        } else {
            if (!this.initialize()) {
                System.exit(1);
            }
            char[] cArray = new char[1];
            while (cArray[0] != 'q') {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                    System.out.println("Press a key and hit ENTER: \n'p' to play, 's' to stop, 'h' to pause and 'q' to quit");
                    bufferedReader.read(cArray);
                    switch (cArray[0]) {
                        case 'p': {
                            this.al.alSourcePlay(this.source[0]);
                            break;
                        }
                        case 's': {
                            this.al.alSourceStop(this.source[0]);
                            break;
                        }
                        case 'h': {
                            this.al.alSourcePause(this.source[0]);
                            break;
                        }
                        case 'q': {
                            this.killAllData();
                        }
                    }
                }
                catch (IOException iOException) {
                    System.exit(1);
                }
            }
        }
    }

    private boolean initialize() {
        if (this.initialized) {
            return true;
        }
        try {
            ALut.alutInit();
            this.al = ALFactory.getAL();
            this.al.alGetError();
        }
        catch (ALException aLException) {
            aLException.printStackTrace();
            return false;
        }
        try {
            if (this.loadALData() == 0) {
                return false;
            }
        }
        catch (ALException aLException) {
            aLException.printStackTrace();
            return false;
        }
        this.setListenerValues();
        this.initialized = true;
        return true;
    }

    private int loadALData() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ByteBuffer[] byteBufferArray = new ByteBuffer[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        this.al.alGenBuffers(1, this.buffer, 0);
        if (this.al.alGetError() != 0) {
            throw new ALException("Error generating OpenAL buffers");
        }
        InputStream inputStream = SingleStaticSource.class.getClassLoader().getResourceAsStream(audioFile);
        if (null == inputStream) {
            throw new RuntimeException("File 'demos/data/sound/FancyPants.wav' not found");
        }
        System.err.println("File demos/data/sound/FancyPants.wav opened");
        ALut.alutLoadWAVFile((InputStream)inputStream, (int[])nArray, (ByteBuffer[])byteBufferArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
        if (byteBufferArray[0] == null) {
            throw new RuntimeException("Error loading WAV file");
        }
        System.out.println("sound size = " + nArray2[0]);
        System.out.println("sound freq = " + nArray3[0]);
        this.al.alBufferData(this.buffer[0], nArray[0], (Buffer)byteBufferArray[0], nArray2[0], nArray3[0]);
        this.al.alGenSources(1, this.source, 0);
        if (this.al.alGetError() != 0) {
            throw new ALException("Error generating OpenAL source");
        }
        this.al.alSourcei(this.source[0], 4105, this.buffer[0]);
        this.al.alSourcef(this.source[0], 4099, 1.0f);
        this.al.alSourcef(this.source[0], 4106, 1.0f);
        this.al.alSourcei(this.source[0], 4103, nArray4[0]);
        if (this.al.alGetError() != 0) {
            throw new ALException("Error setting up OpenAL source");
        }
        this.al.alSourcefv(this.source[0], 4100, this.sourcePos, 0);
        this.al.alSourcefv(this.source[0], 4102, this.sourceVel, 0);
        return 1;
    }

    private void setListenerValues() {
        this.al.alListenerfv(4100, this.listenerPos, 0);
        this.al.alListenerfv(4102, this.listenerVel, 0);
        this.al.alListenerfv(4111, this.listenerOri, 0);
    }

    private void killAllData() {
        this.al.alDeleteBuffers(1, this.buffer, 0);
        this.al.alDeleteSources(1, this.source, 0);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-gui")) continue;
            bl = true;
        }
        new SingleStaticSource(bl);
    }
}

