/*
 * Decompiled with CFR 0.152.
 */
package demos.jrefract;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.AnimatorBase;
import com.jogamp.opengl.util.FPSAnimator;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.hwShadowmapsSimple.HWShadowmapsSimple;
import demos.infiniteShadowVolumes.InfiniteShadowVolumes;
import demos.j2d.FlyingText;
import demos.jgears.JGears;
import demos.proceduralTexturePhysics.ProceduralTexturePhysics;
import demos.vertexBufferObject.VertexBufferObject;
import demos.vertexProgRefract.VertexProgRefract;
import demos.vertexProgWarp.VertexProgWarp;
import demos.xtrans.XTDesktopPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class JRefract {
    private AnimatorBase animator;
    private JDesktopPane desktop;
    private static final int GEARS = 1;
    private static final int HWSHADOWS = 3;
    private static final int INFINITE = 4;
    private static final int REFRACT = 5;
    private static final int TEXT = 6;
    private static final int VBO = 7;
    private static final int WARP = 8;
    private static final int WATER = 9;
    private JInternalFrame curFrame;

    public static void main(String[] stringArray) {
        new JRefract().run(stringArray);
    }

    private JInternalFrame addWindow(int n) {
        System.gc();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.gc();
        String string = "";
        switch (n) {
            case 1: {
                string = "Gears Demo";
                break;
            }
            case 3: {
                string = "ARB_shadow Shadows";
                break;
            }
            case 4: {
                string = "Infinite Shadow Volumes";
                break;
            }
            case 5: {
                string = "Refraction Using Vertex Programs";
                break;
            }
            case 6: {
                string = "Flying Text";
                break;
            }
            case 7: {
                string = "Very Simple vertex_buffer_object demo";
                break;
            }
            case 9: {
                string = "Procedural Texture Waves";
            }
        }
        final JInternalFrame jInternalFrame = new JInternalFrame(string);
        jInternalFrame.setResizable(true);
        jInternalFrame.setClosable(true);
        jInternalFrame.setVisible(true);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        if (n == 4) {
            gLCapabilities.setStencilBits(16);
        }
        final JGears jGears = n == 1 ? new JGears() : new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        DemoListener demoListener = new DemoListener(){

            @Override
            public void shutdownDemo() {
                JRefract.this.removeJPanel(jGears);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jInternalFrame.doDefaultCloseAction();
                    }
                });
            }

            @Override
            public void repaint() {
                jGears.repaint();
            }
        };
        Demo demo = null;
        switch (n) {
            case 1: {
                break;
            }
            case 3: {
                demo = new HWShadowmapsSimple();
                break;
            }
            case 4: {
                demo = new InfiniteShadowVolumes();
                break;
            }
            case 5: {
                demo = new VertexProgRefract();
                break;
            }
            case 6: {
                demo = new FlyingText();
                break;
            }
            case 7: {
                demo = new VertexBufferObject();
                break;
            }
            case 8: {
                demo = new VertexProgWarp();
                ((VertexProgWarp)demo).setTitleSetter(new VertexProgWarp.TitleSetter(){

                    @Override
                    public void setTitle(final String string) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jInternalFrame.setTitle(string);
                            }
                        });
                    }
                });
                break;
            }
            case 9: {
                demo = new ProceduralTexturePhysics();
            }
        }
        if (n != 1) {
            demo.setDemoListener(demoListener);
            jGears.addGLEventListener(demo);
        }
        jGears.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                jGears.requestFocus();
            }
        });
        this.addJPanel(jGears);
        final Demo demo2 = demo;
        jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                if (demo2 != null) {
                    demo2.shutdownDemo();
                }
            }
        });
        jInternalFrame.getContentPane().setLayout(new BorderLayout());
        if (n == 1) {
            jGears.setOpaque(false);
            JPanel jPanel = JGears.createGradientPanel();
            jInternalFrame.getContentPane().add((Component)jPanel, "Center");
            jPanel.add((Component)((Object)jGears), "Center");
            final JCheckBox jCheckBox = new JCheckBox("Transparent", true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jGears.setOpaque(!jCheckBox.isSelected());
                }
            });
            jInternalFrame.getContentPane().add((Component)jCheckBox, "South");
        } else if (n == 6) {
            FlyingText flyingText = (FlyingText)demo;
            jInternalFrame.getContentPane().add((Component)flyingText.buildGUI(), "North");
            jInternalFrame.getContentPane().add((Component)((Object)jGears), "Center");
        } else {
            jInternalFrame.getContentPane().add((Component)((Object)jGears), "Center");
        }
        jInternalFrame.setSize(512, 512);
        this.desktop.add(jInternalFrame);
        return jInternalFrame;
    }

    public void run(String[] stringArray) {
        JFrame jFrame = new JFrame("JOGL and Swing Interoperability");
        if (stringArray.length > 0 && stringArray[0].equals("-xt")) {
            this.desktop = new XTDesktopPane();
            ((XTDesktopPane)this.desktop).setAlwaysRedraw(true);
        } else {
            this.desktop = new JDesktopPane();
        }
        this.desktop.setSize(1024, 768);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)this.desktop, "Center");
        JInternalFrame jInternalFrame = new JInternalFrame("Hello, World");
        JLabel jLabel = new JLabel("Hello, World!");
        jLabel.setFont(new Font("SansSerif", 0, 128));
        jInternalFrame.getContentPane().add(jLabel);
        jInternalFrame.pack();
        jInternalFrame.setResizable(true);
        this.desktop.add(jInternalFrame);
        jInternalFrame.setVisible(true);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Actions");
        JMenuItem jMenuItem = new JMenuItem("Gears");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(1);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Hardware Shadow Maps");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(3);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Infinite Shadow Volumes");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(4);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Refraction");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(5);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Text");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(6);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Vertex Buffer Object");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(7);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Warp");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(8);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Water");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.addWindow(9);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Loop Gears Demo");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.startAutoMode();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRefract.this.runExit();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JRefract.this.runExit();
            }
        });
        jFrame.setSize(this.desktop.getSize());
        jFrame.setVisible(true);
        this.animator = new FPSAnimator(60);
        this.animator.start();
    }

    private void runExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                JRefract.this.animator.stop();
                System.exit(0);
            }
        }).start();
    }

    private synchronized void addJPanel(GLJPanel gLJPanel) {
        this.animator.add((GLAutoDrawable)gLJPanel);
    }

    private synchronized void removeJPanel(GLJPanel gLJPanel) {
        this.animator.remove((GLAutoDrawable)gLJPanel);
    }

    private void startAutoMode() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JRefract.this.curFrame = JRefract.this.addWindow(1);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                JRefract.this.curFrame.doDefaultCloseAction();
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }).start();
    }
}

