/*
 * Decompiled with CFR 0.152.
 */
package demos.misc;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.FPSAnimator;
import demos.gears.Gears;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class GLCapsTableDemo
extends JFrame
implements GLCapabilitiesChooser {
    private final String[] colNames = new String[]{"Pfd", "H/W", "DblBfr", "Stereo", "CBits", "cR", "cG", "cB", "cA", "ABits", "aR", "aG", "aB", "aA", "Z", "S", "AA|AAS", "PBuf(Float|RTT|RTTRec)"};
    private final ArrayList<GLCapabilities> available = new ArrayList();
    private final ArrayList<Integer> indices = new ArrayList();
    private Object[][] data;
    private JTable capsTable;
    private int desiredCapIndex;
    protected JPanel pane;
    protected JPanel pane2;
    private boolean updateLR;
    private final DefaultGLCapabilitiesChooser choiceExaminer = new DefaultGLCapabilitiesChooser(){

        public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List list3, int n) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)capabilitiesImmutable;
            if (list3 != null && list3.size() > 0) {
                for (int i = 0; i < list3.size(); ++i) {
                    GLCapabilitiesImmutable gLCapabilitiesImmutable2 = (GLCapabilitiesImmutable)list3.get(i);
                    if (gLCapabilitiesImmutable2 == null) continue;
                    GLCapsTableDemo.this.available.add((GLCapabilities)gLCapabilitiesImmutable2.cloneMutable());
                    GLCapsTableDemo.this.indices.add(i);
                }
            }
            GLCapsTableDemo.this.desiredCapIndex = super.chooseCapabilities((CapabilitiesImmutable)gLCapabilitiesImmutable, list3, n);
            System.out.println("valid" + GLCapsTableDemo.this.desiredCapIndex);
            GLCapsTableDemo.this.capsTable = GLCapsTableDemo.this.tabulateTable(GLCapsTableDemo.this.available, GLCapsTableDemo.this.indices);
            JScrollPane jScrollPane = new JScrollPane(GLCapsTableDemo.this.capsTable, 20, 30);
            GLCapsTableDemo.this.getContentPane().add(jScrollPane);
            GLCapsTableDemo.this.pane.setBorder(BorderFactory.createTitledBorder(null, "" + GLCapsTableDemo.this.desiredCapIndex, 5, 0));
            GLCapsTableDemo.this.pane2.setBorder(BorderFactory.createTitledBorder(null, "" + GLCapsTableDemo.this.desiredCapIndex, 4, 0));
            GLCapsTableDemo.this.validate();
            System.out.println("valid");
            return GLCapsTableDemo.this.desiredCapIndex;
        }
    };
    private final GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private JSplitPane canvasPane;
    private GLCanvas canvas;
    private GLCanvas canvas2;
    private final Gears topRenderer = new Gears();
    private final Gears bottomRenderer = new Gears();
    private FPSAnimator animator;
    private final Dimension defdim = new Dimension(512, 256);
    private final String visTip = "If no gears are visible, it may be that the current desktop color resolution doesn't match the GLCapabilities chosen. Check CBits column.";

    public GLCapsTableDemo() {
        super(GLCapsTableDemo.class.getName());
        this.initComponents();
    }

    public int chooseCapabilities(CapabilitiesImmutable capabilitiesImmutable, List list3, int n) {
        int n2 = this.capsTable.getSelectedRow();
        if (0 > n2 || n2 >= this.indices.size()) {
            return n;
        }
        int n3 = this.indices.get(n2);
        if (this.updateLR) {
            this.pane.setBorder(BorderFactory.createTitledBorder(null, "" + n3, 5, 0));
        } else {
            this.pane2.setBorder(BorderFactory.createTitledBorder(null, "" + n3, 4, 0));
        }
        return n3;
    }

    public void run(String[] stringArray) {
        this.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension((int)((double)dimension.width * 0.75), (int)((double)dimension.height * 0.75)));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.validate();
        this.animator.start();
    }

    public static void main(String[] stringArray) {
        GLCapsTableDemo gLCapsTableDemo = new GLCapsTableDemo();
        gLCapsTableDemo.run(stringArray);
    }

    private void initComponents() {
        this.pane = new JPanel();
        this.pane2 = new JPanel();
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setSampleBuffers(true);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)this.choiceExaminer, this.device);
        this.canvas.addGLEventListener((GLEventListener)this.topRenderer);
        this.canvas.setSize(this.defdim);
        this.animator = new FPSAnimator((GLAutoDrawable)this.canvas, 30);
        this.canvas2 = new GLCanvas(null, null, this.device);
        this.canvas2.addGLEventListener((GLEventListener)this.bottomRenderer);
        this.canvas2.setSize(this.defdim);
        this.animator.add((GLAutoDrawable)this.canvas2);
        this.pane.add((Component)this.canvas);
        this.pane2.add((Component)this.canvas2);
        this.canvasPane = new JSplitPane();
        this.canvasPane.setResizeWeight(0.5);
        this.canvasPane.setOrientation(1);
        this.canvasPane.setLeftComponent(this.pane);
        this.canvasPane.setRightComponent(this.pane2);
        this.getContentPane().add((Component)this.canvasPane, "South");
        this.getContentPane().add((Component)this.buildControls(), "North");
    }

    private JTable tabulateTable(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        Object object;
        arrayList.trimToSize();
        this.data = new Object[arrayList.size()][this.colNames.length];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.data[i][0] = arrayList2.get(i);
            object = (GLCapabilities)arrayList.get(i);
            this.data[i][1] = "" + (object.getHardwareAccelerated() ? "F" : "F");
            this.data[i][2] = "" + (object.getDoubleBuffered() ? "T" : "F");
            this.data[i][3] = "" + (object.getStereo() ? "T" : "F");
            n = object.getRedBits();
            int n2 = object.getGreenBits();
            int n3 = object.getBlueBits();
            int n4 = object.getAlphaBits();
            this.data[i][4] = "" + (n + n2 + n3 + n4);
            this.data[i][5] = n;
            this.data[i][6] = n2;
            this.data[i][7] = n3;
            this.data[i][8] = n4;
            n = object.getAccumRedBits();
            n2 = object.getAccumGreenBits();
            n3 = object.getAccumBlueBits();
            n4 = object.getAccumAlphaBits();
            this.data[i][9] = "" + (n + n2 + n3 + n4);
            this.data[i][10] = n;
            this.data[i][11] = n2;
            this.data[i][12] = n3;
            this.data[i][13] = n4;
            this.data[i][14] = "" + object.getDepthBits();
            this.data[i][15] = "" + object.getStencilBits();
            this.data[i][16] = "" + (object.getSampleBuffers() ? "T" : "F") + " | " + object.getNumSamples();
            this.data[i][17] = "FFf";
        }
        JTable jTable = new JTable(this.data, this.colNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setAutoResizeMode(4);
        object = null;
        for (n = 0; n < this.colNames.length; ++n) {
            object = jTable.getColumnModel().getColumn(n);
            if (n == this.colNames.length - 1) {
                ((TableColumn)object).setPreferredWidth(100);
                continue;
            }
            ((TableColumn)object).setPreferredWidth(7);
        }
        jTable.setDoubleBuffered(true);
        return jTable;
    }

    private JPanel buildControls() {
        JPanel jPanel = new JPanel();
        final JButton jButton = new JButton("Respawn Left");
        JButton jButton2 = new JButton("Respawn Right");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GLCapsTableDemo.this.animator.stop();
                if (actionEvent.getSource() == jButton) {
                    GLCapsTableDemo.this.updateLR = true;
                    GLCapsTableDemo.this.animator.remove((GLAutoDrawable)GLCapsTableDemo.this.canvas);
                    GLCapsTableDemo.this.pane.remove((Component)GLCapsTableDemo.this.canvas);
                    GLCapsTableDemo.this.canvas = GLCapsTableDemo.this.newCanvas(true, true);
                    GLCapsTableDemo.this.pane.add((Component)GLCapsTableDemo.this.canvas);
                    GLCapsTableDemo.this.animator.add((GLAutoDrawable)GLCapsTableDemo.this.canvas);
                } else {
                    GLCapsTableDemo.this.updateLR = false;
                    GLCapsTableDemo.this.animator.remove((GLAutoDrawable)GLCapsTableDemo.this.canvas2);
                    GLCapsTableDemo.this.pane2.remove((Component)GLCapsTableDemo.this.canvas2);
                    GLCapsTableDemo.this.canvas2 = GLCapsTableDemo.this.newCanvas(true, false);
                    GLCapsTableDemo.this.pane2.add((Component)GLCapsTableDemo.this.canvas2);
                    GLCapsTableDemo.this.animator.add((GLAutoDrawable)GLCapsTableDemo.this.canvas2);
                }
                new Thread(){

                    @Override
                    public void run() {
                        GLCapsTableDemo.this.animator.start();
                    }
                }.start();
                GLCapsTableDemo.this.validate();
            }
        };
        jButton.setToolTipText("If no gears are visible, it may be that the current desktop color resolution doesn't match the GLCapabilities chosen. Check CBits column.");
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private GLCanvas newCanvas(boolean bl, boolean bl2) {
        GLCanvas gLCanvas = null;
        gLCanvas = !bl ? new GLCanvas(null, (GLCapabilitiesChooser)this.choiceExaminer, this.device) : new GLCanvas(null, (GLCapabilitiesChooser)this, this.device);
        if (bl2) {
            gLCanvas.addGLEventListener((GLEventListener)this.topRenderer);
        } else {
            gLCanvas.addGLEventListener((GLEventListener)this.bottomRenderer);
        }
        gLCanvas.setSize(this.defdim);
        return gLCanvas;
    }

    private void exitRunner() {
        new Thread(){

            @Override
            public void run() {
                GLCapsTableDemo.this.animator.stop();
            }
        };
    }
}

