/*
 * Decompiled with CFR 0.152.
 */
package demos.misc;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.IntBuffer;

public class Picking {
    public static void main(String[] stringArray) {
        new Picking();
    }

    Picking() {
        Frame frame = new Frame("Picking Example");
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        Renderer renderer = new Renderer();
        gLCanvas.addGLEventListener((GLEventListener)renderer);
        gLCanvas.addMouseListener((MouseListener)renderer);
        gLCanvas.addMouseMotionListener((MouseMotionListener)renderer);
        frame.add((Component)gLCanvas);
        frame.setSize(400, 400);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                animator.stop();
                System.exit(0);
            }
        });
        frame.setVisible(true);
        animator.start();
    }

    static class Renderer
    implements GLEventListener,
    MouseListener,
    MouseMotionListener {
        static final int NOTHING = 0;
        static final int UPDATE = 1;
        static final int SELECT = 2;
        int cmd = 1;
        int mouse_x;
        int mouse_y;
        private GLU glu = new GLU();

        Renderer() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glEnable(2884);
            gL2.glEnable(2929);
            gL2.glEnable(2977);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glViewport(0, 0, n3, n4);
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            this.glu.gluOrtho2D(0.0f, 1.0f, 0.0f, 1.0f);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            switch (this.cmd) {
                case 1: {
                    this.drawScene(gL2);
                    break;
                }
                case 2: {
                    int n = 512;
                    double d = this.mouse_x;
                    double d2 = this.mouse_y;
                    int[] nArray = new int[4];
                    IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)n);
                    int n2 = 0;
                    gL2.glGetIntegerv(2978, nArray, 0);
                    gL2.glSelectBuffer(n, intBuffer);
                    gL2.glRenderMode(7170);
                    gL2.glInitNames();
                    gL2.glMatrixMode(5889);
                    gL2.glPushMatrix();
                    gL2.glLoadIdentity();
                    this.glu.gluPickMatrix(d, (double)nArray[3] - d2, 5.0, 5.0, nArray, 0);
                    this.glu.gluOrtho2D(0.0, 1.0, 0.0, 1.0);
                    this.drawScene(gL2);
                    gL2.glMatrixMode(5889);
                    gL2.glPopMatrix();
                    gL2.glFlush();
                    n2 = gL2.glRenderMode(7168);
                    this.processHits(n2, intBuffer);
                    this.cmd = 1;
                }
            }
        }

        public void processHits(int n, IntBuffer intBuffer) {
            System.out.println("---------------------------------");
            System.out.println(" HITS: " + n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                System.out.println("- - - - - - - - - - - -");
                System.out.println(" hit: " + (i + 1));
                int n3 = intBuffer.get(n2);
                float f = (float)((long)intBuffer.get(++n2) & 0xFFFFFFFFL) / 2.1474836E9f;
                float f2 = (float)((long)intBuffer.get(++n2) & 0xFFFFFFFFL) / 2.1474836E9f;
                ++n2;
                System.out.println(" number of names: " + n3);
                System.out.println(" z1: " + f);
                System.out.println(" z2: " + f2);
                System.out.println(" names: ");
                for (int j = 0; j < n3; ++j) {
                    System.out.print("       " + intBuffer.get(n2));
                    if (j == n3 - 1) {
                        System.out.println("<-");
                    } else {
                        System.out.println();
                    }
                    ++n2;
                }
                System.out.println("- - - - - - - - - - - -");
            }
            System.out.println("---------------------------------");
        }

        public int viewPortWidth(GL2 gL2) {
            int[] nArray = new int[4];
            gL2.glGetIntegerv(2978, nArray, 0);
            return nArray[2];
        }

        public int viewPortHeight(GL2 gL2) {
            int[] nArray = new int[4];
            gL2.glGetIntegerv(2978, nArray, 0);
            return nArray[3];
        }

        public void drawScene(GL2 gL2) {
            gL2.glClear(16640);
            float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
            float[] fArray3 = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
            GLRectangleEntity gLRectangleEntity = new GLRectangleEntity(gL2, this.glu);
            gLRectangleEntity.x = 0.15f;
            gLRectangleEntity.y = 0.25f;
            gLRectangleEntity.z = 0.75f;
            gLRectangleEntity.w = 0.4f;
            gLRectangleEntity.h = 0.4f;
            gLRectangleEntity.c = fArray;
            gLRectangleEntity.id = 10;
            gLRectangleEntity.draw();
            GLRectangleEntity gLRectangleEntity2 = new GLRectangleEntity(gL2, this.glu);
            gLRectangleEntity2.x = 0.35f;
            gLRectangleEntity2.y = 0.45f;
            gLRectangleEntity2.z = 0.5f;
            gLRectangleEntity2.w = 0.4f;
            gLRectangleEntity2.h = 0.4f;
            gLRectangleEntity2.c = fArray2;
            gLRectangleEntity2.id = 20;
            gLRectangleEntity2.draw();
            GLRectangleEntity gLRectangleEntity3 = new GLRectangleEntity(gL2, this.glu);
            gLRectangleEntity3.x = 0.45f;
            gLRectangleEntity3.y = 0.15f;
            gLRectangleEntity3.z = 0.25f;
            gLRectangleEntity3.w = 0.4f;
            gLRectangleEntity3.h = 0.4f;
            gLRectangleEntity3.c = fArray3;
            gLRectangleEntity3.id = 30;
            gLRectangleEntity3.draw();
            gL2.glFlush();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.cmd = 2;
            this.mouse_x = mouseEvent.getX();
            this.mouse_y = mouseEvent.getY();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public class GLRectangleEntity
        extends GLEntity {
            float w;
            float h;

            public GLRectangleEntity(GL2 gL2, GLU gLU) {
                super(gL2, gLU);
                this.w = 0.1f;
                this.h = 0.1f;
            }

            @Override
            public void _draw() {
                if (this.outline) {
                    this.gl.glPolygonMode(1028, 6913);
                } else {
                    this.gl.glPolygonMode(1028, 6914);
                }
                this.gl.glColor4fv(this.c, 0);
                this.gl.glBegin(9);
                this.gl.glVertex3f(this.x, this.y, this.z);
                this.gl.glVertex3f(this.x + this.w, this.y, this.z);
                this.gl.glVertex3f(this.x + this.w, this.y + this.h, this.z);
                this.gl.glVertex3f(this.x, this.y + this.h, this.z);
                this.gl.glEnd();
            }
        }

        public abstract class GLEntity {
            float x;
            float y;
            float z;
            float[] c;
            int id = 0;
            boolean outline = false;
            GL2 gl;
            GLU glu;

            public GLEntity(GL2 gL2, GLU gLU) {
                this.gl = gL2;
                this.glu = gLU;
            }

            public void draw() {
                this.gl.glPushName(this.id);
                this._draw();
            }

            public abstract void _draw();
        }
    }
}

