/*
 * Decompiled with CFR 0.152.
 */
package demos.multisample;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

public class Multisample {
    private GLCanvas canvas;

    public static void main(String[] stringArray) {
        new Multisample().run(stringArray);
    }

    public void run(String[] stringArray) {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        MultisampleChooser multisampleChooser = new MultisampleChooser();
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)multisampleChooser, null);
        this.canvas.addGLEventListener((GLEventListener)new Listener());
        Frame frame = new Frame("Full-scene antialiasing");
        frame.setLayout(new BorderLayout());
        this.canvas.setSize(512, 512);
        frame.add((Component)this.canvas, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.setLocation(0, 0);
        this.canvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Multisample.this.runExit();
            }
        });
        gLCapabilities.setSampleBuffers(false);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        this.canvas.addGLEventListener((GLEventListener)new Listener());
        frame = new Frame("No antialiasing");
        frame.setLayout(new BorderLayout());
        this.canvas.setSize(512, 512);
        frame.add((Component)this.canvas, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.setLocation(512, 0);
        this.canvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Multisample.this.runExit();
            }
        });
    }

    private void runExit() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        }).start();
    }

    static class MultisampleChooser
    extends DefaultGLCapabilitiesChooser {
        MultisampleChooser() {
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, List<? extends CapabilitiesImmutable> list3, int n) {
            GLCapabilitiesImmutable gLCapabilitiesImmutable;
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < list3.size(); ++n2) {
                gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list3.get(n2);
                if (gLCapabilitiesImmutable == null || !gLCapabilitiesImmutable.getSampleBuffers()) continue;
                bl = true;
                break;
            }
            n2 = super.chooseCapabilities((CapabilitiesImmutable)gLCapabilities, list3, n);
            if (!bl) {
                System.err.println("WARNING: antialiasing will be disabled because none of the available pixel formats had it to offer");
            } else if (n2 >= 0 && !(gLCapabilitiesImmutable = (GLCapabilitiesImmutable)list3.get(n2)).getSampleBuffers()) {
                System.err.println("WARNING: antialiasing will be disabled because the DefaultGLCapabilitiesChooser didn't supply it");
            }
            return n2;
        }
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            System.err.println("Info: " + gLAutoDrawable);
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            gL2.glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16640);
            int n = 20;
            double d = Math.PI / (double)n;
            double d2 = 1.0;
            gL2.glBegin(1);
            for (int i = n - 1; i >= 0; --i) {
                gL2.glVertex3d(d2 * Math.cos((double)i * d), d2 * Math.sin((double)i * d), 0.0);
                gL2.glVertex3d(-1.0 * d2 * Math.cos((double)i * d), -1.0 * d2 * Math.sin((double)i * d), 0.0);
            }
            gL2.glEnd();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

