/*
 * Decompiled with CFR 0.152.
 */
package demos.newt;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import demos.newt.util.TaskManager;

public class TaskManagerTest1
implements WindowListener,
KeyListener,
MouseListener {
    static final TaskManager eventMgr;
    static final TaskManager renderMgr;
    Window window;
    Display display;

    public static void main(String[] stringArray) {
        new TaskManagerTest1().run();
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
        System.err.println("windowRepaint " + windowUpdateEvent);
    }

    public void windowResized(WindowEvent windowEvent) {
        System.err.println("windowResized " + windowEvent);
    }

    public void windowMoved(WindowEvent windowEvent) {
        System.err.println("windowMoved " + windowEvent);
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        System.err.println("windowGainedFocus " + windowEvent);
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        System.err.println("windowLostFocus " + windowEvent);
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.err.println("windowDestroyNotify " + windowEvent);
        System.err.println("Window Event Listener DestroyNotify send stop request - START");
        renderMgr.stop();
        eventMgr.stop();
        System.err.println("Window Event Listener DestroyNotify send stop request - DONE");
    }

    public void windowDestroyed(WindowEvent windowEvent) {
        System.err.println("windowDestroyed " + windowEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.err.println("keyPressed " + keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.err.println("keyReleased " + keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.err.println("mouseClicked " + mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        System.err.println("mouseEntered " + mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        System.err.println("mouseExited " + mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        System.err.println("mousePressed " + mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        System.err.println("mouseReleased " + mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        System.err.println("mouseMoved " + mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        System.err.println("mouseDragged " + mouseEvent);
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
        System.err.println("mouseWheelMoved " + mouseEvent);
    }

    void render(long l) {
    }

    void run() {
        try {
            Capabilities capabilities = new Capabilities();
            capabilities.setRedBits(8);
            capabilities.setGreenBits(8);
            capabilities.setBlueBits(8);
            this.display = NewtFactory.createDisplay(null);
            Screen screen = NewtFactory.createScreen((Display)this.display, (int)0);
            this.window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)capabilities);
            this.window.setTitle("GlassPrism");
            this.window.setUndecorated(false);
            this.window.setSize(256, 256);
            this.window.addKeyListener((KeyListener)this);
            this.window.addMouseListener((MouseListener)this);
            this.window.addWindowListener((WindowListener)this);
            this.window.setVisible(true);
            eventMgr.addTask(new EventThread());
            renderMgr.addTask(new RenderThread());
            System.out.println("Main - wait until finished");
            renderMgr.waitUntilStopped();
            eventMgr.waitUntilStopped();
            System.out.println("Main - finished");
            this.window.destroy();
            System.out.println("Main - window destroyed");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
        eventMgr = new TaskManager("Event Manager");
        eventMgr.start();
        renderMgr = new TaskManager("Render Manager");
        renderMgr.start();
    }

    private class EventThread
    implements Runnable {
        private EventThread() {
        }

        @Override
        public void run() {
            try {
                if (null != TaskManagerTest1.this.display) {
                    TaskManagerTest1.this.display.dispatchMessages();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private class RenderThread
    implements Runnable {
        private RenderThread() {
        }

        @Override
        public void run() {
            if (null == TaskManagerTest1.this.window) {
                return;
            }
            try {
                TaskManagerTest1.this.window.lockSurface();
                System.out.print(".");
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                TaskManagerTest1.this.window.unlockSurface();
            }
        }
    }
}

