/*
 * Decompiled with CFR 0.152.
 */
package demos.newt;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import demos.newt.util.TaskToolWM;

public class TaskManagerTest2
implements WindowListener,
KeyListener,
MouseListener {
    public static void main(String[] stringArray) {
        new TaskManagerTest2().run();
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
        System.err.println("windowRepaint " + windowUpdateEvent);
    }

    public void windowResized(WindowEvent windowEvent) {
        System.err.println("windowResized " + windowEvent);
    }

    public void windowMoved(WindowEvent windowEvent) {
        System.err.println("windowMoved " + windowEvent);
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        System.err.println("windowGainedFocus " + windowEvent);
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        System.err.println("windowLostFocus " + windowEvent);
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.err.println("windowDestroyNotify " + windowEvent);
        System.err.println("Window Event Listener DestroyNotify send stop request - START");
        TaskToolWM.unregisterWindowEvent((Window)windowEvent.getSource());
        System.err.println("Window Event Listener DestroyNotify send stop request - DONE");
    }

    public void windowDestroyed(WindowEvent windowEvent) {
        System.err.println("windowDestroyed " + windowEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        System.err.println("keyPressed " + keyEvent);
        if (keyEvent.getKeyChar() == 'q') {
            System.err.println("Key Event Listener 'q' - ..");
            TaskToolWM.unregisterWindowEvent((Window)keyEvent.getSource());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.err.println("keyReleased " + keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.err.println("mouseClicked " + mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        System.err.println("mouseEntered " + mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        System.err.println("mouseExited " + mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        System.err.println("mousePressed " + mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        System.err.println("mouseReleased " + mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        System.err.println("mouseMoved " + mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        System.err.println("mouseDragged " + mouseEvent);
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
        System.err.println("mouseWheelMoved " + mouseEvent);
    }

    void run() {
        try {
            Capabilities capabilities = new Capabilities();
            capabilities.setRedBits(8);
            capabilities.setGreenBits(8);
            capabilities.setBlueBits(8);
            Display display = NewtFactory.createDisplay(null);
            Screen screen = NewtFactory.createScreen((Display)display, (int)0);
            Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)capabilities);
            window.setTitle("GlassPrism");
            window.setUndecorated(false);
            window.setSize(256, 256);
            window.addKeyListener((KeyListener)this);
            window.addMouseListener((MouseListener)this);
            window.addWindowListener((WindowListener)this);
            window.setVisible(true);
            TaskToolWM.registerWindowEvent(window);
            TaskToolWM.addRenderTask(window, new RenderThread(window));
            System.out.println("Main - wait until finished");
            TaskToolWM.waitUntilWindowUnregistered(window);
            System.out.println("Main - finished");
            window.destroy();
            System.out.println("Main - window destroyed");
            TaskToolWM.exit(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private class RenderThread
    implements Runnable {
        Window window;

        public RenderThread(Window window) {
            this.window = window;
        }

        @Override
        public void run() {
            if (null == this.window) {
                return;
            }
            try {
                this.window.lockSurface();
                System.out.println("Render: " + this.window);
                Thread.sleep(200L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.window.unlockSurface();
            }
        }
    }
}

