/*
 * Decompiled with CFR 0.152.
 */
package demos.newt.util;

import java.util.ArrayList;
import java.util.Iterator;

public class TaskManager {
    private ThreadGroup threadGroup;
    private volatile boolean shouldStop = false;
    private TaskWorker taskWorker = null;
    private Object taskWorkerLock = new Object();
    private ArrayList tasks = new ArrayList();
    private String name;

    public TaskManager(String string) {
        this.threadGroup = new ThreadGroup(string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void start() {
        this.start(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable start(boolean bl) {
        Object object = this.taskWorkerLock;
        synchronized (object) {
            if (null == this.taskWorker) {
                this.taskWorker = new TaskWorker(this.name);
            }
            if (!this.taskWorker.isRunning()) {
                this.shouldStop = false;
                this.taskWorker.start(bl);
            }
            this.taskWorkerLock.notifyAll();
        }
        return this.taskWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.taskWorkerLock;
        synchronized (object) {
            if (null != this.taskWorker && this.taskWorker.isRunning()) {
                this.shouldStop = true;
            }
            this.taskWorkerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Object object = this.taskWorkerLock;
        synchronized (object) {
            this.tasks.add(runnable);
            this.taskWorkerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Object object = this.taskWorkerLock;
        synchronized (object) {
            this.tasks.remove(runnable);
            this.taskWorkerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] getTasks() {
        Runnable[] runnableArray;
        Object object = this.taskWorkerLock;
        synchronized (object) {
            runnableArray = (Runnable[])this.tasks.toArray();
        }
        return runnableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnWorker() {
        Object object = this.taskWorkerLock;
        synchronized (object) {
            if (null != this.taskWorker && this.taskWorker.isRunning()) {
                try {
                    this.taskWorkerLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilStopped() {
        Object object = this.taskWorkerLock;
        synchronized (object) {
            while (null != this.taskWorker && this.taskWorker.isRunning()) {
                try {
                    this.taskWorkerLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    class TaskWorker
    extends Thread {
        volatile boolean isRunning;
        volatile boolean externalStimuli;

        public TaskWorker(String string) {
            super(TaskManager.this.threadGroup, string);
            this.isRunning = false;
            this.externalStimuli = false;
        }

        public synchronized boolean isRunning() {
            return this.isRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(boolean bl) throws IllegalThreadStateException {
            TaskWorker taskWorker = this;
            synchronized (taskWorker) {
                this.externalStimuli = bl;
                this.isRunning = true;
            }
            if (!bl) {
                super.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (!TaskManager.this.shouldStop) {
                try {
                    Iterator iterator = TaskManager.this.taskWorkerLock;
                    synchronized (iterator) {
                        while (!TaskManager.this.shouldStop && TaskManager.this.tasks.size() == 0) {
                            try {
                                TaskManager.this.taskWorkerLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        object = (ArrayList)TaskManager.this.tasks.clone();
                    }
                    iterator = ((ArrayList)object).iterator();
                    while (iterator.hasNext()) {
                        Runnable runnable = (Runnable)iterator.next();
                        runnable.run();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (!this.externalStimuli) continue;
            }
            object = this;
            synchronized (object) {
                this.isRunning = !TaskManager.this.shouldStop;
            }
            if (!this.isRunning) {
                object = TaskManager.this.taskWorkerLock;
                synchronized (object) {
                    TaskManager.this.taskWorkerLock.notifyAll();
                }
            }
        }
    }
}

