/*
 * Decompiled with CFR 0.152.
 */
package demos.newt.util;

import com.jogamp.newt.Display;
import com.jogamp.newt.Window;
import demos.newt.util.TaskManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TaskToolWM {
    static final boolean externalStimuli;
    static final TaskManager eventMgr;
    static final Runnable eventMgrRunnable;
    static final TaskManager renderMgr;
    static final Runnable renderMgrRunnable;
    static final Map window2Event;
    static final Map window2Set;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerWindowEvent(Window window) {
        boolean bl;
        Map map = window2Event;
        synchronized (map) {
            Runnable runnable = (Runnable)window2Event.get(window);
            if (null == runnable) {
                runnable = new EventThread(window.getScreen().getDisplay());
                window2Event.put(window, runnable);
                eventMgr.addTask(runnable);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterWindowEvent(Window window) {
        boolean bl;
        Map map = window2Event;
        synchronized (map) {
            Runnable runnable = (Runnable)window2Event.remove(window);
            if (null != runnable) {
                eventMgr.removeTask(runnable);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWindowEventRegistered(Window window) {
        boolean bl;
        Map map = window2Event;
        synchronized (map) {
            bl = null != window2Event.get(window);
        }
        return bl;
    }

    public static void waitUntilWindowsUnregistered() {
        while (window2Event.size() > 0) {
            eventMgr.waitOnWorker();
        }
    }

    public static void waitUntilWindowUnregistered(Window window) {
        while (TaskToolWM.isWindowEventRegistered(window)) {
            eventMgr.waitOnWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addRenderTask(Window window, Runnable runnable) {
        boolean bl;
        Map map = window2Set;
        synchronized (map) {
            HashSet<Runnable> hashSet = (HashSet<Runnable>)window2Set.get(window);
            if (null == hashSet) {
                hashSet = new HashSet<Runnable>();
                window2Set.put(window, hashSet);
            }
            if (hashSet.add(runnable)) {
                renderMgr.addTask(runnable);
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeRenderTasks(Window window) {
        boolean bl;
        Map map = window2Set;
        synchronized (map) {
            Set set = (Set)window2Set.get(window);
            if (null == set) {
                bl = false;
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Runnable runnable = (Runnable)iterator.next();
                    renderMgr.removeTask(runnable);
                    iterator.remove();
                }
                window2Set.remove(window);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeRenderTask(Window window, Runnable runnable) {
        boolean bl;
        Map map = window2Set;
        synchronized (map) {
            Set set = (Set)window2Set.get(window);
            if (null == set) {
                bl = false;
            } else if (set.remove(runnable)) {
                renderMgr.removeTask(runnable);
                if (set.size() == 0) {
                    window2Set.remove(window);
                }
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Runnable[] getRenderTasks(Window window) {
        Runnable[] runnableArray = null;
        Map map = window2Set;
        synchronized (map) {
            Set set = (Set)window2Set.get(window);
            if (null != set) {
                runnableArray = (Runnable[])set.toArray();
            }
        }
        return runnableArray;
    }

    public static void exit(boolean bl) {
        eventMgr.stop();
        renderMgr.stop();
        if (bl) {
            System.exit(0);
        }
    }

    static {
        System.setProperty("java.awt.headless", "true");
        window2Event = new HashMap();
        window2Set = new HashMap();
        externalStimuli = Boolean.getBoolean("demos.newt.util.TaskToolWM.externalStimuli");
        eventMgr = new TaskManager("Event Manager");
        eventMgrRunnable = eventMgr.start(externalStimuli);
        renderMgr = new TaskManager("Render Manager");
        renderMgrRunnable = renderMgr.start(externalStimuli);
    }

    private static class EventThread
    implements Runnable {
        Display display;

        EventThread(Display display) {
            this.display = display;
        }

        @Override
        public void run() {
            try {
                if (null != this.display) {
                    this.display.dispatchMessages();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

