/*
 * Decompiled with CFR 0.152.
 */
package demos.particles.engine;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.FPSAnimator;
import demos.particles.engine.Engine;
import demos.particles.engine.RGBA;

public class GLComponent
extends GLCanvas
implements GLEventListener {
    private final GLU glu;
    private FPSAnimator animator;
    private final RGBA background;
    private final RGBA ambient;
    private Engine engine;

    public GLComponent(int n, RGBA rGBA, RGBA rGBA2, Engine engine) {
        super((GLCapabilitiesImmutable)GLComponent.getCapabilities());
        this.addGLEventListener(this);
        this.glu = new GLU();
        this.background = rGBA2;
        this.ambient = rGBA;
        this.engine = engine;
        this.animator = new FPSAnimator((GLAutoDrawable)this, n);
    }

    private static GLCapabilities getCapabilities() {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        return gLCapabilities;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.engine = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.engine.draw(gL2);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glShadeModel(7425);
        gL2.glClearColor(this.background.r, this.background.g, this.background.b, this.background.a);
        gL2.glClearDepth(1.0);
        gL2.glDisable(2929);
        gL2.glEnable(3042);
        gL2.glBlendFunc(770, 1);
        gL2.glHint(3152, 4354);
        gL2.glHint(3153, 4354);
        gL2.glEnable(3553);
        this.animator.start();
        this.engine.init((GL)gL2);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glViewport(0, 0, n3, n4);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        double d = (double)n3 / (double)n4;
        this.glu.gluPerspective(45.0, d, 1.1920928955078125E-7, 1.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
    }

    public void setFPS(int n) {
        this.animator.stop();
        this.animator = new FPSAnimator((GLAutoDrawable)this, n);
        this.animator.start();
    }

    public void kill() {
        this.animator.stop();
    }
}

