/*
 * Decompiled with CFR 0.152.
 */
package demos.proceduralTexturePhysics;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.proceduralTexturePhysics.Water;
import demos.util.DurationTimer;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.CameraParameters;
import gleem.ExaminerViewer;
import gleem.ManipManager;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;

public class ProceduralTexturePhysics
extends Demo {
    private volatile boolean drawing;
    private volatile int mousePosX;
    private volatile int mousePosY;
    private GLAutoDrawable drawable;
    private Water water = new Water();
    private volatile ExaminerViewer viewer;
    private final boolean[] b = new boolean[256];
    private boolean doViewAll = true;
    private final float zNear = 0.1f;
    private final float zFar = 10.0f;
    private DurationTimer timer = new DurationTimer();
    private boolean firstRender = true;
    private int frameCount;
    private final float blurIncrement = 0.01f;
    private final float bumpIncrement = 0.01f;
    private final float frequencyIncrement = 0.1f;

    public static void main(String[] stringArray) {
        GLCanvas gLCanvas = new GLCanvas();
        final ProceduralTexturePhysics proceduralTexturePhysics = new ProceduralTexturePhysics();
        gLCanvas.addGLEventListener((GLEventListener)proceduralTexturePhysics);
        gLCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                proceduralTexturePhysics.dispatchKey(keyEvent.getKeyChar());
            }
        });
        gLCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                proceduralTexturePhysics.dispatchMousePress(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                proceduralTexturePhysics.dispatchMouseRelease(mouseEvent);
            }
        });
        gLCanvas.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                proceduralTexturePhysics.dispatchMouseDrag(mouseEvent);
            }
        });
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        proceduralTexturePhysics.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                ProceduralTexturePhysics.runExit(animator);
            }

            @Override
            public void repaint() {
            }
        });
        Frame frame = new Frame("Procedural Texture Waves");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProceduralTexturePhysics.runExit(animator);
            }
        });
        animator.start();
    }

    @Override
    public void shutdownDemo() {
        this.viewer.detach();
        ManipManager.getManipManager().unregisterWindow((AWTGLAutoDrawable)this.drawable);
        this.drawable.removeGLEventListener((GLEventListener)this);
        super.shutdownDemo();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.water.destroy();
        this.water.initialize("demos/data/images/nvfixed.tga", "demos/data/images/nvspin.tga", "demos/data/images/droplet.tga", "demos/data/cubemaps/CloudyHills_", "tga", gLAutoDrawable);
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(1);
        try {
            this.checkExtension(gL, "GL_VERSION_1_3");
            this.checkExtension(gL, "GL_ARB_vertex_program");
            this.checkExtension(gL, "GL_ARB_fragment_program");
            this.checkExtension(gL, "GL_ARB_pbuffer");
            this.checkExtension(gL, "GL_ARB_pixel_format");
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
            throw gLException;
        }
        gL.glClearColor(0.0f, 0.2f, 0.5f, 0.0f);
        gL.glDisable(2896);
        gL.glDisable(2929);
        gL.glDisable(2884);
        this.doViewAll = true;
        if (this.firstRender) {
            this.firstRender = false;
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
            this.drawable = gLAutoDrawable;
            this.viewer = new ExaminerViewer();
            this.viewer.setUpVector(Vec3f.Y_AXIS);
            this.viewer.setAutoRedrawMode(false);
            this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new BSphereProvider(){

                public BSphere getBoundingSphere() {
                    return new BSphere(new Vec3f(0.0f, 0.0f, 0.0f), 1.2f);
                }
            });
            this.viewer.setVertFOV(1.4726216f);
            this.viewer.setZNear(0.1f);
            this.viewer.setZFar(10.0f);
            this.timer.start();
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.water.destroy();
        this.water = null;
        this.viewer = null;
        this.timer = null;
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (++this.frameCount == 30) {
            this.timer.stop();
            System.err.println("Frames per second: " + 30.0f / this.timer.getDurationAsSeconds());
            this.timer.reset();
            this.timer.start();
            this.frameCount = 0;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        if (this.doViewAll) {
            this.viewer.viewAll(gL2);
            this.doViewAll = false;
        }
        this.viewer.update(gL2);
        ManipManager.getManipManager().updateCameraParameters((AWTGLAutoDrawable)gLAutoDrawable, this.viewer.getCameraParameters());
        ManipManager.getManipManager().render((AWTGLAutoDrawable)gLAutoDrawable, gL2);
        if (this.drawing) {
            int n = gLAutoDrawable.getSurfaceWidth();
            int n2 = gLAutoDrawable.getSurfaceHeight();
            this.water.addDroplet(new Water.Droplet(2.0f * ((float)this.mousePosX / (float)n - 0.5f), -2.0f * ((float)this.mousePosY / (float)n2 - 0.5f), 0.08f));
        }
        this.water.tick();
        CameraParameters cameraParameters = this.viewer.getCameraParameters();
        this.water.draw(gL2, cameraParameters.getOrientation().inverse());
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void setFlag(char c, boolean bl) {
        this.b[c & 0xFF] = bl;
    }

    private boolean getFlag(char c) {
        return this.b[c & 0xFF];
    }

    private void checkExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            String string2 = "Unable to initialize " + string + " OpenGL extension";
            JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
            this.shutdownDemo();
        }
    }

    private void dispatchKey(char c) {
        this.setFlag(c, !this.getFlag(c));
        switch (c) {
            case '\u001b': 
            case 'q': {
                this.shutdownDemo();
                break;
            }
            case 'w': {
                this.water.enableWireframe(this.getFlag('w'));
                break;
            }
            case 'd': {
                break;
            }
            case ' ': {
                this.water.enableAnimation(this.getFlag(' '));
                break;
            }
            case 'b': {
                this.water.enableBorderWrapping(this.getFlag('b'));
                break;
            }
            case 'n': {
                this.water.singleStep();
                break;
            }
            case 's': {
                this.water.enableSlowAnimation(this.getFlag('s'));
                break;
            }
            case '1': {
                this.water.setRenderMode(0);
                break;
            }
            case '2': {
                this.water.setRenderMode(2);
                break;
            }
            case '3': {
                this.water.setRenderMode(1);
                break;
            }
            case '4': {
                this.water.setRenderMode(3);
                break;
            }
            case '5': {
                this.water.setRenderMode(4);
                break;
            }
            case 'r': {
                this.water.reset();
                break;
            }
            case 'i': {
                this.doViewAll = true;
                break;
            }
            case 'c': {
                float f = this.water.getBlurDistance();
                if (!(f > 0.01f)) break;
                this.water.setBlurDistance(f - 0.01f);
                break;
            }
            case 'v': {
                float f = this.water.getBlurDistance();
                if (!(f < 1.0f)) break;
                this.water.setBlurDistance(f + 0.01f);
                break;
            }
            case '-': {
                float f = this.water.getBumpScale();
                if (!(f > -1.0f)) break;
                this.water.setBumpScale(f - 0.01f);
                break;
            }
            case '=': {
                float f = this.water.getBumpScale();
                if (!(f < 1.0f)) break;
                this.water.setBumpScale(f + 0.01f);
                break;
            }
            case 'l': {
                this.water.enableBoundaryApplication(this.getFlag('l'));
                break;
            }
            case 'o': {
                this.water.enableSpinningLogo(this.getFlag('o'));
                break;
            }
            case '.': {
                float f = this.water.getBumpScale();
                if (!(f < 1.0f)) break;
                this.water.setDropFrequency(f + 0.1f);
                break;
            }
            case ',': {
                float f = this.water.getBumpScale();
                if (!(f > 0.0f)) break;
                this.water.setDropFrequency(f - 0.1f);
                break;
            }
        }
    }

    private void dispatchMousePress(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown()) {
            this.drawing = true;
        }
    }

    private void dispatchMouseRelease(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.drawing = false;
        }
    }

    public void dispatchMouseDrag(MouseEvent mouseEvent) {
        this.mousePosX = mouseEvent.getX();
        this.mousePosY = mouseEvent.getY();
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }
}

