/*
 * Decompiled with CFR 0.152.
 */
package demos.readbuffer;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import demos.readbuffer.ReadBuffer2File;
import demos.readbuffer.ReadBuffer2Screen;
import demos.readbuffer.Surface2File;
import java.lang.reflect.Field;

public class Main
implements WindowListener,
MouseListener,
SurfaceUpdatedListener {
    public boolean quit = false;
    public GLWindow window = null;
    public static int USE_NEWT = 0;
    public static int USE_AWT = 1;
    public static int TEST_SURFACE2FILE = 0;
    public static int TEST_READBUFFER2FILE = 1;
    public static int TEST_READBUFFER2SCREEN = 2;

    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        if (null != nativeSurface) {
            this.window.display();
        }
    }

    public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
    }

    public void windowResized(WindowEvent windowEvent) {
    }

    public void windowMoved(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowDestroyNotify(WindowEvent windowEvent) {
        System.err.println("********** quit **************");
        this.quit = true;
    }

    public void windowDestroyed(WindowEvent windowEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("mouseevent: " + mouseEvent);
        switch (mouseEvent.getClickCount()) {
            case 1: {
                if (null == this.window) break;
                this.window.setFullscreen(!this.window.isFullscreen());
                break;
            }
            default: {
                this.quit = true;
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseEvent mouseEvent) {
    }

    public GLWindow createOffscreen(GLCapabilities gLCapabilities, int n, int n2, boolean bl) {
        GLCapabilities gLCapabilities2 = (GLCapabilities)gLCapabilities.clone();
        gLCapabilities2.setOnscreen(false);
        gLCapabilities2.setPBuffer(bl);
        gLCapabilities2.setDoubleBuffered(false);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen((Display)display, (int)0);
        Window window = NewtFactory.createWindow((Screen)screen, (CapabilitiesImmutable)gLCapabilities2);
        GLWindow gLWindow = GLWindow.create((Window)window);
        gLWindow.setUpdateFPSFrames(300, System.err);
        gLWindow.setSize(n, n2);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    private void run(String string, int n, boolean bl, int n2, GLEventListener gLEventListener, boolean bl2) {
        GLProfile gLProfile = GLProfile.get((String)string);
        int n3 = 800;
        int n4 = 480;
        System.out.println("readbuffer.Main.run() Test: " + n2);
        try {
            Object object;
            GLDrawable gLDrawable;
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            GLWindow gLWindow = this.createOffscreen(gLCapabilities, n3, n4, bl2);
            if (!Main.setField(gLEventListener, "window", gLWindow)) {
                Main.setField(gLEventListener, "glWindow", gLWindow);
            }
            gLWindow.addGLEventListener(gLEventListener);
            if (TEST_SURFACE2FILE < n2) {
                Window window;
                System.out.println("readbuffer.Main.run() Using a target onscreen window with read drawable attachment");
                if (0 != (n & USE_AWT)) {
                    gLDrawable = NewtFactory.createDisplay((String)".awt", null);
                    object = NewtFactory.createScreen((Display)gLDrawable, (int)0);
                    window = NewtFactory.createWindow((Screen)object, (CapabilitiesImmutable)gLCapabilities);
                    this.window = GLWindow.create((Window)window);
                } else {
                    gLDrawable = NewtFactory.createDisplay(null);
                    object = NewtFactory.createScreen((Display)gLDrawable, (int)0);
                    window = NewtFactory.createWindow((Screen)object, (CapabilitiesImmutable)gLCapabilities);
                    this.window = GLWindow.create((Window)window);
                }
                this.window.addWindowListener((WindowListener)this);
                this.window.addMouseListener((MouseListener)this);
                this.window.setSize(n3, n4);
                this.window.setFullscreen(bl);
                this.window.setVisible(true);
            }
            gLDrawable = gLWindow.getContext().getGLDrawable();
            if (TEST_SURFACE2FILE == n2) {
                object = new Surface2File();
                gLWindow.addSurfaceUpdatedListener((SurfaceUpdatedListener)object);
            } else if (TEST_READBUFFER2FILE == n2) {
                object = new ReadBuffer2File(gLDrawable);
                this.window.addGLEventListener((GLEventListener)object);
            } else if (TEST_READBUFFER2SCREEN == n2) {
                object = new ReadBuffer2Screen(gLDrawable);
                this.window.addGLEventListener((GLEventListener)object);
            }
            if (null != this.window) {
                gLWindow.addSurfaceUpdatedListener((SurfaceUpdatedListener)this);
            }
            System.out.println("+++++++++++++++++++++++++++");
            System.out.println(gLWindow);
            System.out.println("+++++++++++++++++++++++++++");
            while (!this.quit) {
                gLWindow.display();
                if (!(TEST_READBUFFER2SCREEN == n2 ? gLWindow.getTotalFPSDuration() >= 10000L : gLWindow.getTotalFPSFrames() >= 10)) continue;
            }
            gLWindow.destroy();
            if (null != this.window) {
                this.window.destroy();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("readbuffer.Main shut down cleanly.");
        }
        catch (GLException gLException) {
            gLException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        GLEventListener gLEventListener;
        int n;
        String string = null;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = USE_NEWT;
        int n3 = TEST_SURFACE2FILE;
        for (n = 0; n < stringArray.length - 1; ++n) {
            if (stringArray[n].equals("-awt")) {
                n2 |= USE_AWT;
                continue;
            }
            if (stringArray[n].equals("-fs")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-nopbuffer")) {
                bl2 = false;
                continue;
            }
            if (stringArray[n].equals("-test")) {
                n3 = Main.str2int(stringArray[++n], n3);
                continue;
            }
            if (!stringArray[n].startsWith("-GL")) continue;
            string = stringArray[n].substring(1);
        }
        String string2 = stringArray[n];
        Object var8_8 = null;
        try {
            gLEventListener = Class.forName(string2);
            var8_8 = gLEventListener.newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException("Error while instantiating demo: " + string2);
        }
        if (!(var8_8 instanceof GLEventListener)) {
            throw new RuntimeException("Not a GLEventListener: " + string2);
        }
        gLEventListener = var8_8;
        new Main().run(string, n2, bl, n3, gLEventListener, bl2);
        System.exit(0);
    }

    public static int str2int(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public static boolean setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            if (object2 instanceof Boolean || field.getType().isInstance(object2)) {
                field.set(object, object2);
                return true;
            }
            System.out.println(object.getClass() + " '" + string + "' field not assignable with " + object2.getClass() + ", it's a: " + field.getType());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.out.println(object.getClass() + " has no '" + string + "' field");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }
}

