/*
 * Decompiled with CFR 0.152.
 */
package demos.readbuffer;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.fixedfunc.GLLightingFunc;
import com.jogamp.opengl.fixedfunc.GLMatrixFunc;
import com.jogamp.opengl.util.GLArrayDataClient;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.texture.TextureCoords;
import demos.readbuffer.ReadBufferBase;
import java.nio.FloatBuffer;

public class ReadBuffer2Screen
extends ReadBufferBase {
    PMVMatrix pmvMatrix;
    GLArrayDataClient readTextureVertices = null;
    GLArrayDataClient readTextureCoords = null;
    boolean enableBufferAlways = false;
    boolean enableBufferVBO = true;

    public ReadBuffer2Screen(GLDrawable gLDrawable) {
        super(gLDrawable);
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        GL gL = gLAutoDrawable.getGL();
        this.pmvMatrix = new PMVMatrix();
        if (null == this.readTextureVertices) {
            this.readTextureVertices = GLArrayDataServer.createFixed((int)32884, (int)2, (int)5126, (boolean)true, (int)4, (int)35044);
            this.readTextureVertices.setEnableAlways(this.enableBufferAlways);
            this.readTextureVertices.setVBOEnabled(this.enableBufferVBO);
            FloatBuffer floatBuffer = (FloatBuffer)this.readTextureVertices.getBuffer();
            floatBuffer.put(-1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(-1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            floatBuffer.put(1.0f);
            this.readTextureVertices.seal(gL, true);
            System.out.println(this.readTextureVertices);
        }
        gL.glClearColor(0.5f, 0.5f, 0.5f, 0.4f);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        super.reshape(gLAutoDrawable, n, n2, n3, n4);
        GL gL = gLAutoDrawable.getGL();
        gL.glViewport(0, 0, n3, n4);
        if (gL instanceof GLLightingFunc) {
            ((GLLightingFunc)gL).glShadeModel(7425);
        }
        float[] fArray = new float[16];
        if (!(gL instanceof GLMatrixFunc)) {
            throw new GLException("ES2 currently unhandled .. ");
        }
        GLMatrixFunc gLMatrixFunc = (GLMatrixFunc)gL;
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glTranslatef(0.0f, 0.0f, -2.5f);
        if (null != gLMatrixFunc) {
            gLMatrixFunc.glMatrixMode(5888);
            gLMatrixFunc.glLoadMatrixf(this.pmvMatrix.getMv().get(fArray), 0);
        }
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.gluPerspective(45.0f, (float)n3 / (float)n4, 1.0f, 100.0f);
        if (null != gLMatrixFunc) {
            gLMatrixFunc.glMatrixMode(5889);
            gLMatrixFunc.glLoadMatrixf(this.pmvMatrix.getP().get(fArray), 0);
        }
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        super.dispose(gLAutoDrawable);
    }

    void renderOffscreenTexture(GL gL) {
        if (!this.readBufferUtil.isValid()) {
            return;
        }
        this.readBufferUtil.getTexture().enable(gL);
        this.readBufferUtil.getTexture().bind(gL);
        if (gL.isGL2ES1()) {
            gL.getGL2ES1().glTexEnvi(8960, 8704, 8448);
        }
        this.updateTextureCoords(gL, false);
        this.readTextureVertices.enableBuffer(gL, true);
        if (null != this.readTextureCoords) {
            this.readTextureCoords.enableBuffer(gL, true);
        }
        gL.glDrawArrays(5, 0, this.readTextureVertices.getElemCount());
        this.readBufferUtil.getTexture().disable(gL);
    }

    void updateTextureCoords(GL gL, boolean bl) {
        if (bl || null == this.readTextureCoords) {
            this.readTextureCoords = GLArrayDataServer.createFixed((int)32888, (int)2, (int)5126, (boolean)true, (int)4, (int)35044);
            this.readTextureCoords.setEnableAlways(this.enableBufferAlways);
            this.readTextureCoords.setVBOEnabled(this.enableBufferVBO);
            TextureCoords textureCoords = this.readBufferUtil.getTexture().getImageTexCoords();
            FloatBuffer floatBuffer = (FloatBuffer)this.readTextureCoords.getBuffer();
            floatBuffer.put(textureCoords.left());
            floatBuffer.put(textureCoords.bottom());
            floatBuffer.put(textureCoords.right());
            floatBuffer.put(textureCoords.bottom());
            floatBuffer.put(textureCoords.left());
            floatBuffer.put(textureCoords.top());
            floatBuffer.put(textureCoords.right());
            floatBuffer.put(textureCoords.top());
            this.readTextureCoords.seal(gL, true);
            System.out.println(this.readTextureCoords);
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        super.display(gLAutoDrawable);
        GL gL = gLAutoDrawable.getGL();
        gL.glClear(16640);
        if (gL instanceof GLLightingFunc) {
            ((GLLightingFunc)gL).glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        this.renderOffscreenTexture(gL);
    }
}

