/*
 * Decompiled with CFR 0.152.
 */
package demos.readbuffer;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import java.nio.Buffer;

public class ReadBufferUtil {
    protected int readPixelSizeLast = 0;
    protected Buffer readPixelBuffer = null;
    protected TextureData readTextureData = null;
    protected Texture readTexture = new Texture(3553);

    public Buffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        this.readPixelBuffer.rewind();
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public boolean isValid() {
        return null != this.readTexture && null != this.readTextureData && null != this.readPixelBuffer;
    }

    public void fetchOffscreenTexture(GLDrawable gLDrawable, GL gL) {
        int n = gLDrawable.getSurfaceWidth() * gLDrawable.getSurfaceHeight() * 3;
        boolean bl = false;
        if (n > this.readPixelSizeLast) {
            this.readPixelBuffer = GLBuffers.newDirectGLBuffer((int)5121, (int)n);
            this.readPixelSizeLast = n;
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), 6407, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0, 6407, 5121, false, false, false, this.readPixelBuffer, null);
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.readTextureData = null;
                this.readPixelBuffer = null;
                this.readPixelSizeLast = 0;
            }
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.clear();
            gL.glReadPixels(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 6407, 5121, this.readPixelBuffer);
            this.readPixelBuffer.rewind();
            if (bl) {
                this.readTexture.updateImage(gL, this.readTextureData);
            } else {
                this.readTexture.updateSubImage(gL, this.readTextureData, 0, 0, 0, 0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
            }
            this.readPixelBuffer.rewind();
        }
    }

    public void dispose(GL gL) {
        this.readTexture.destroy(gL);
        this.readTextureData = null;
        this.readPixelBuffer.clear();
        this.readPixelBuffer = null;
        this.readPixelSizeLast = 0;
    }
}

