/*
 * Decompiled with CFR 0.152.
 */
package demos.readbuffer;

import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.SurfaceUpdatedListener;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import demos.readbuffer.ReadBufferUtil;
import java.io.File;
import java.io.IOException;

public class Surface2File
implements SurfaceUpdatedListener {
    ReadBufferUtil readBufferUtil = new ReadBufferUtil();
    int shotNum = 0;

    public void dispose(GL gL) {
        this.readBufferUtil.dispose(gL);
    }

    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
        if (object instanceof GLDrawable) {
            GLDrawable gLDrawable = (GLDrawable)object;
            GLContext gLContext = GLContext.getCurrent();
            if (null != gLContext && gLContext.getGLDrawable() == gLDrawable) {
                this.readBufferUtil.fetchOffscreenTexture(gLDrawable, gLContext.getGL());
                this.surface2File("shot");
            }
        }
    }

    public void surface2File(String string) {
        if (!this.readBufferUtil.isValid()) {
            return;
        }
        try {
            File file = File.createTempFile(string + this.shotNum + "-", ".ppm");
            TextureIO.write((TextureData)this.readBufferUtil.getTextureData(), (File)file);
            if (0 == this.shotNum) {
                System.out.println("Wrote: " + file.getAbsolutePath() + ", ...");
            }
            ++this.shotNum;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.readBufferUtil.rewindPixelBuffer();
    }
}

