/*
 * Decompiled with CFR 0.152.
 */
package demos.tess;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import com.jogamp.opengl.glu.GLUtessellatorCallbackAdapter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Tess {
    public static void main(String[] stringArray) {
        try {
            Frame frame = new Frame("Tess Demo");
            frame.setSize(500, 500);
            GLCanvas gLCanvas = new GLCanvas();
            frame.add((Component)gLCanvas);
            gLCanvas.addGLEventListener((GLEventListener)new TessRenderer());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            System.exit(0);
                        }
                    }).start();
                }
            });
            frame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class TessRenderer
    implements GLEventListener {
        private GL2 gl;
        private GLU glu = new GLU();
        private int startList;

        public void init(GLAutoDrawable gLAutoDrawable) {
            this.gl = gLAutoDrawable.getGL().getGL2();
            gLAutoDrawable.setGL((GL)new DebugGL2(this.gl));
            double[][] dArrayArray = new double[][]{{50.0, 50.0, 0.0}, {200.0, 50.0, 0.0}, {200.0, 200.0, 0.0}, {50.0, 200.0, 0.0}};
            double[][] dArrayArray2 = new double[][]{{75.0, 75.0, 0.0}, {125.0, 175.0, 0.0}, {175.0, 75.0, 0.0}};
            double[][] dArrayArray3 = new double[][]{{250.0, 50.0, 0.0, 1.0, 0.0, 1.0}, {325.0, 200.0, 0.0, 1.0, 1.0, 0.0}, {400.0, 50.0, 0.0, 0.0, 1.0, 1.0}, {250.0, 150.0, 0.0, 1.0, 0.0, 0.0}, {400.0, 150.0, 0.0, 0.0, 1.0, 0.0}};
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.startList = this.gl.glGenLists(2);
            TessRenderer tessRenderer = this;
            GLUtessellator gLUtessellator = tessRenderer.glu.gluNewTess();
            TessCallback tessCallback = new TessCallback(this.gl, this.glu);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100101, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100100, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100102, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100103, (GLUtessellatorCallback)tessCallback);
            this.gl.glNewList(this.startList, 4864);
            this.gl.glShadeModel(7424);
            GLU.gluTessBeginPolygon((GLUtessellator)gLUtessellator, null);
            GLU.gluTessBeginContour((GLUtessellator)gLUtessellator);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray[0], (int)0, (Object)dArrayArray[0]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray[1], (int)0, (Object)dArrayArray[1]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray[2], (int)0, (Object)dArrayArray[2]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray[3], (int)0, (Object)dArrayArray[3]);
            GLU.gluTessEndContour((GLUtessellator)gLUtessellator);
            GLU.gluTessBeginContour((GLUtessellator)gLUtessellator);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray2[0], (int)0, (Object)dArrayArray2[0]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray2[1], (int)0, (Object)dArrayArray2[1]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray2[2], (int)0, (Object)dArrayArray2[2]);
            GLU.gluTessEndContour((GLUtessellator)gLUtessellator);
            GLU.gluTessEndPolygon((GLUtessellator)gLUtessellator);
            this.gl.glEndList();
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100101, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100100, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100102, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100103, (GLUtessellatorCallback)tessCallback);
            GLU.gluTessCallback((GLUtessellator)gLUtessellator, (int)100105, (GLUtessellatorCallback)tessCallback);
            this.gl.glNewList(this.startList + 1, 4864);
            this.gl.glShadeModel(7425);
            GLU.gluTessProperty((GLUtessellator)gLUtessellator, (int)100140, (double)100132.0);
            GLU.gluTessBeginPolygon((GLUtessellator)gLUtessellator, null);
            GLU.gluTessBeginContour((GLUtessellator)gLUtessellator);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray3[0], (int)0, (Object)dArrayArray3[0]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray3[1], (int)0, (Object)dArrayArray3[1]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray3[2], (int)0, (Object)dArrayArray3[2]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray3[3], (int)0, (Object)dArrayArray3[3]);
            GLU.gluTessVertex((GLUtessellator)gLUtessellator, (double[])dArrayArray3[4], (int)0, (Object)dArrayArray3[4]);
            GLU.gluTessEndContour((GLUtessellator)gLUtessellator);
            GLU.gluTessEndPolygon((GLUtessellator)gLUtessellator);
            this.gl.glEndList();
            GLU.gluDeleteTess((GLUtessellator)gLUtessellator);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glOrtho(0.0, 450.0, 0.0, 250.0, -1.0, 1.0);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            this.gl = null;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            this.gl.glClear(16384);
            this.gl.glColor3d(1.0, 1.0, 1.0);
            this.gl.glCallList(this.startList);
            this.gl.glCallList(this.startList + 1);
            this.gl.glFlush();
        }
    }

    public static class TessCallback
    extends GLUtessellatorCallbackAdapter {
        GL2 gl;
        GLU glu;

        public TessCallback(GL2 gL2, GLU gLU) {
            this.gl = gL2;
            this.glu = gLU;
        }

        public void begin(int n) {
            this.gl.glBegin(n);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void vertex(Object object) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                if (dArray.length == 6) {
                    this.gl.glColor3dv(dArray, 3);
                }
                this.gl.glVertex3dv(dArray, 0);
            }
        }

        public void error(int n) {
            String string = this.glu.gluErrorString(n);
            System.out.println("Tessellation Error: " + string);
            throw new RuntimeException();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[6];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            for (int i = 3; i < 6; ++i) {
                dArray2[i] = (double)fArray[0] * ((double[])objectArray[0])[i] + (double)fArray[1] * ((double[])objectArray[1])[i] + (double)fArray[2] * ((double[])objectArray[2])[i] + (double)fArray[3] * ((double[])objectArray[3])[i];
            }
            objectArray2[0] = dArray2;
        }
    }
}

