/*
 * Decompiled with CFR 0.152.
 */
package demos.testContextDestruction;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

public class TestContextDestruction {
    private int gearDisplayList;
    private Frame frame1;
    private Frame frame2;
    private Component frame1ContainedComponent;
    private Component frame1RemovedComponent;
    private Component frame2ContainedComponent;
    private Component frame2RemovedComponent;
    private Canvas emptyCanvas;
    private float angle = 0.0f;
    private static final int BORDER_WIDTH = 6;

    public static void main(String[] stringArray) {
        new TestContextDestruction().run(stringArray);
    }

    public void run(String[] stringArray) {
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)new Listener());
        gLCanvas.setSize(256, 256);
        this.frame1 = new Frame("Frame 1");
        this.frame1.setLayout(new BorderLayout());
        this.frame1.add((Component)gLCanvas, "Center");
        this.emptyCanvas = new Canvas();
        this.emptyCanvas.setBackground(Color.GRAY);
        this.emptyCanvas.setSize(256, 256);
        this.frame2 = new Frame("Frame 2");
        this.frame2.setLayout(new BorderLayout());
        this.frame2.add((Component)this.emptyCanvas, "Center");
        this.frame1ContainedComponent = gLCanvas;
        this.frame2ContainedComponent = this.emptyCanvas;
        this.frame1.pack();
        this.frame1.setVisible(true);
        this.frame2.pack();
        this.frame2.setVisible(true);
        this.frame2.setLocation(262, 0);
        JFrame jFrame = new JFrame("Controls");
        jFrame.getContentPane().setLayout(new GridLayout(3, 1));
        JButton jButton = new JButton("Toggle Frame 1's component");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestContextDestruction.this.frame1ContainedComponent == null) {
                    TestContextDestruction.this.frame1ContainedComponent = TestContextDestruction.this.frame1RemovedComponent;
                    TestContextDestruction.this.frame1RemovedComponent = null;
                    TestContextDestruction.this.frame1.add(TestContextDestruction.this.frame1ContainedComponent);
                } else {
                    TestContextDestruction.this.frame1RemovedComponent = TestContextDestruction.this.frame1ContainedComponent;
                    TestContextDestruction.this.frame1ContainedComponent = null;
                    TestContextDestruction.this.frame1.remove(TestContextDestruction.this.frame1RemovedComponent);
                }
            }
        });
        jFrame.getContentPane().add(jButton);
        jButton = new JButton("Swap Frame 1's and Frame 2's components");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Swapping Frame 1's and Frame 2's components");
                Component component = null;
                Component component2 = null;
                component = TestContextDestruction.this.frame1ContainedComponent;
                component2 = TestContextDestruction.this.frame2ContainedComponent;
                if (component != null) {
                    TestContextDestruction.this.frame1.remove(component);
                }
                if (component2 != null) {
                    TestContextDestruction.this.frame2.remove(component2);
                }
                if (component != null) {
                    TestContextDestruction.this.frame2.add(component);
                }
                if (component2 != null) {
                    TestContextDestruction.this.frame1.add(component2);
                }
                TestContextDestruction.this.frame1ContainedComponent = component2;
                TestContextDestruction.this.frame2ContainedComponent = component;
                component = TestContextDestruction.this.frame1RemovedComponent;
                TestContextDestruction.this.frame1RemovedComponent = TestContextDestruction.this.frame2RemovedComponent;
                TestContextDestruction.this.frame2RemovedComponent = component;
            }
        });
        jFrame.getContentPane().add(jButton);
        jButton = new JButton("Toggle Frame 2's component");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TestContextDestruction.this.frame2ContainedComponent == null) {
                    TestContextDestruction.this.frame2ContainedComponent = TestContextDestruction.this.frame2RemovedComponent;
                    TestContextDestruction.this.frame2RemovedComponent = null;
                    TestContextDestruction.this.frame2.add(TestContextDestruction.this.frame2ContainedComponent);
                } else {
                    TestContextDestruction.this.frame2RemovedComponent = TestContextDestruction.this.frame2ContainedComponent;
                    TestContextDestruction.this.frame2ContainedComponent = null;
                    TestContextDestruction.this.frame2.remove(TestContextDestruction.this.frame2RemovedComponent);
                }
            }
        });
        jFrame.getContentPane().add(jButton);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setLocation(524, 0);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        System.exit(0);
                    }
                }).start();
            }
        };
        this.frame1.addWindowListener(windowAdapter);
        this.frame2.addWindowListener(windowAdapter);
        jFrame.addWindowListener(windowAdapter);
        animator.start();
    }

    private synchronized void initializeDisplayList(GL2 gL2) {
        this.gearDisplayList = gL2.glGenLists(1);
        gL2.glNewList(this.gearDisplayList, 4864);
        float[] fArray = new float[]{0.8f, 0.1f, 0.0f, 1.0f};
        gL2.glMaterialfv(1028, 5634, fArray, 0);
        this.gear(gL2, 1.0f, 4.0f, 1.0f, 20, 0.7f);
        gL2.glEndList();
    }

    private void gear(GL2 gL2, float f, float f2, float f3, int n, float f4) {
        float f5;
        int n2;
        float f6 = f;
        float f7 = f2 - f4 / 2.0f;
        float f8 = f2 + f4 / 2.0f;
        float f9 = (float)Math.PI * 2 / (float)n / 4.0f;
        gL2.glShadeModel(7424);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            if (n2 >= n) continue;
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(7);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
        }
        gL2.glEnd();
        gL2.glBegin(8);
        for (n2 = 0; n2 < n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5), f7 * (float)Math.sin(f5), -f3 * 0.5f);
            float f10 = f8 * (float)Math.cos(f5 + f9) - f7 * (float)Math.cos(f5);
            float f11 = f8 * (float)Math.sin(f5 + f9) - f7 * (float)Math.sin(f5);
            float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
            gL2.glNormal3f(f11 /= f12, -(f10 /= f12), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + f9), f8 * (float)Math.sin(f5 + f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f8 * (float)Math.cos(f5 + 2.0f * f9), f8 * (float)Math.sin(f5 + 2.0f * f9), -f3 * 0.5f);
            f10 = f7 * (float)Math.cos(f5 + 3.0f * f9) - f8 * (float)Math.cos(f5 + 2.0f * f9);
            f11 = f7 * (float)Math.sin(f5 + 3.0f * f9) - f8 * (float)Math.sin(f5 + 2.0f * f9);
            gL2.glNormal3f(f11, -f10, 0.0f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), f3 * 0.5f);
            gL2.glVertex3f(f7 * (float)Math.cos(f5 + 3.0f * f9), f7 * (float)Math.sin(f5 + 3.0f * f9), -f3 * 0.5f);
            gL2.glNormal3f((float)Math.cos(f5), (float)Math.sin(f5), 0.0f);
        }
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), f3 * 0.5f);
        gL2.glVertex3f(f7 * (float)Math.cos(0.0), f7 * (float)Math.sin(0.0), -f3 * 0.5f);
        gL2.glEnd();
        gL2.glShadeModel(7425);
        gL2.glBegin(8);
        for (n2 = 0; n2 <= n; ++n2) {
            f5 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
            gL2.glNormal3f(-((float)Math.cos(f5)), -((float)Math.sin(f5)), 0.0f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), -f3 * 0.5f);
            gL2.glVertex3f(f6 * (float)Math.cos(f5), f6 * (float)Math.sin(f5), f3 * 0.5f);
        }
        gL2.glEnd();
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            System.out.println("Listener.init()");
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gLAutoDrawable.setGL((GL)new DebugGL2(gL2));
            float[] fArray = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
            gL2.glLightfv(16384, 4611, fArray, 0);
            gL2.glEnable(2884);
            gL2.glEnable(2896);
            gL2.glEnable(16384);
            gL2.glEnable(2929);
            TestContextDestruction.this.initializeDisplayList(gL2);
            gL2.glEnable(2977);
            this.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
            System.out.println("Listener.dispose()");
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            TestContextDestruction.this.angle += 2.0f;
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16640);
            gL2.glPushMatrix();
            gL2.glRotatef(TestContextDestruction.this.angle, 0.0f, 0.0f, 1.0f);
            gL2.glCallList(TestContextDestruction.this.gearDisplayList);
            gL2.glPopMatrix();
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            System.out.println("Listener.reshape()");
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            float f = (float)n4 / (float)n3;
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            gL2.glFrustum(-1.0, 1.0, (double)(-f), (double)f, 5.0, 60.0);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
            gL2.glTranslatef(0.0f, 0.0f, -40.0f);
        }

        public void destroy(GLAutoDrawable gLAutoDrawable) {
            System.out.println("Listener.destroy()");
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glDeleteLists(TestContextDestruction.this.gearDisplayList, 1);
            TestContextDestruction.this.gearDisplayList = 0;
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

