/*
 * Decompiled with CFR 0.152.
 */
package demos.texture;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureIO;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class TestSubImage {
    private boolean haveForcedImageType;
    private int forcedImageType;
    private List imageTypeMenuItems = new ArrayList();
    private GLU glu = new GLU();
    private GLCanvas mainCanvas;
    private Rectangle curRect;
    private Rectangle lastRect;
    private TextureData textureData;
    private Texture texture;
    private BufferedImage baseImage;
    private BufferedImage convertedImage;
    private int CURSOR_SIZE = 10;

    private JMenuItem newItem(final int n, String string) {
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBoxMenuItem.isSelected()) {
                    for (JCheckBoxMenuItem jCheckBoxMenuItem2 : TestSubImage.this.imageTypeMenuItems) {
                        if (jCheckBoxMenuItem2 == jCheckBoxMenuItem) continue;
                        jCheckBoxMenuItem2.setSelected(false);
                    }
                    TestSubImage.this.haveForcedImageType = true;
                    TestSubImage.this.forcedImageType = n;
                } else {
                    TestSubImage.this.haveForcedImageType = false;
                }
                if (TestSubImage.this.convertedImage != null) {
                    TestSubImage.this.convertedImage.flush();
                    TestSubImage.this.convertedImage = null;
                }
                TestSubImage.this.lastRect = null;
                TestSubImage.this.mainCanvas.repaint();
            }
        });
        this.imageTypeMenuItems.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private void run() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame jFrame = new JFrame("Texture Sub Image Test");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Quit");
        jMenuItem.setMnemonic(81);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        JMenu jMenu2 = new JMenu("Force BufferedImage Type");
        jMenu2.setMnemonic(70);
        jMenu2.add(this.newItem(5, "TYPE_3BYTE_BGR"));
        jMenu2.add(this.newItem(6, "TYPE_4BYTE_ABGR"));
        jMenu2.add(this.newItem(7, "TYPE_4BYTE_ABGR_PRE"));
        jMenu2.add(this.newItem(12, "TYPE_BYTE_BINARY"));
        jMenu2.add(this.newItem(10, "TYPE_BYTE_GRAY"));
        jMenu2.add(this.newItem(13, "TYPE_BYTE_INDEXED"));
        jMenu2.add(this.newItem(2, "TYPE_INT_ARGB"));
        jMenu2.add(this.newItem(3, "TYPE_INT_ARGB_PRE"));
        jMenu2.add(this.newItem(4, "TYPE_INT_BGR"));
        jMenu2.add(this.newItem(1, "TYPE_INT_RGB"));
        jMenu2.add(this.newItem(9, "TYPE_USHORT_555_RGB"));
        jMenu2.add(this.newItem(8, "TYPE_USHORT_565_RGB"));
        jMenu2.add(this.newItem(11, "TYPE_USHORT_GRAY"));
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setDefaultCloseOperation(3);
        this.baseImage = new BufferedImage(256, 256, 1);
        Graphics2D graphics2D = this.baseImage.createGraphics();
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.CYAN, this.baseImage.getWidth(), this.baseImage.getHeight(), Color.BLUE));
        graphics2D.fillRect(0, 0, this.baseImage.getWidth(), this.baseImage.getHeight());
        graphics2D.dispose();
        this.mainCanvas = new GLCanvas();
        this.mainCanvas.addGLEventListener((GLEventListener)new Listener());
        this.mainCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TestSubImage.this.curRect = null;
                TestSubImage.this.mainCanvas.repaint();
            }
        });
        this.mainCanvas.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = (int)((float)mouseEvent.getX() * (float)TestSubImage.this.baseImage.getWidth() / (float)mouseEvent.getComponent().getWidth());
                int n2 = (int)((float)mouseEvent.getY() * (float)TestSubImage.this.baseImage.getHeight() / (float)mouseEvent.getComponent().getHeight());
                int n3 = Math.max(0, n - TestSubImage.this.CURSOR_SIZE);
                int n4 = Math.min(TestSubImage.this.baseImage.getWidth(), n + TestSubImage.this.CURSOR_SIZE);
                int n5 = Math.max(0, n2 - TestSubImage.this.CURSOR_SIZE);
                int n6 = Math.min(TestSubImage.this.baseImage.getHeight(), n2 + TestSubImage.this.CURSOR_SIZE);
                TestSubImage.this.curRect = new Rectangle(n3, n5, n4 - n3, n6 - n5);
                TestSubImage.this.mainCanvas.repaint();
            }
        });
        jFrame.getContentPane().add((Component)this.mainCanvas);
        jFrame.setSize(512, 512);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        new TestSubImage().run();
    }

    class Listener
    implements GLEventListener {
        Listener() {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glMatrixMode(5889);
            gL2.glLoadIdentity();
            TestSubImage.this.glu.gluOrtho2D(0.0f, 1.0f, 0.0f, 1.0f);
            gL2.glMatrixMode(5888);
            gL2.glLoadIdentity();
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            Object object;
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            gL2.glClear(16640);
            if (TestSubImage.this.convertedImage == null) {
                if (TestSubImage.this.texture != null) {
                    TestSubImage.this.texture.destroy((GL)gL2);
                    TestSubImage.this.texture = null;
                }
                int n = 1;
                if (TestSubImage.this.haveForcedImageType) {
                    n = TestSubImage.this.forcedImageType;
                }
                TestSubImage.this.convertedImage = new BufferedImage(TestSubImage.this.baseImage.getWidth(), TestSubImage.this.baseImage.getHeight(), n);
                object = TestSubImage.this.convertedImage.createGraphics();
                ((Graphics2D)object).setComposite(AlphaComposite.Src);
                ((Graphics)object).drawImage(TestSubImage.this.baseImage, 0, 0, null);
                ((Graphics)object).dispose();
                TestSubImage.this.textureData = AWTTextureIO.newTextureData((GLProfile)gL2.getGLProfile(), (BufferedImage)TestSubImage.this.convertedImage, (boolean)false);
                TestSubImage.this.texture = TextureIO.newTexture((TextureData)TestSubImage.this.textureData);
            }
            Graphics2D graphics2D = TestSubImage.this.convertedImage.createGraphics();
            graphics2D.setColor(Color.RED);
            graphics2D.setXORMode(Color.WHITE);
            if (TestSubImage.this.lastRect != null) {
                graphics2D.fillRect(((TestSubImage)TestSubImage.this).lastRect.x, ((TestSubImage)TestSubImage.this).lastRect.y, ((TestSubImage)TestSubImage.this).lastRect.width, ((TestSubImage)TestSubImage.this).lastRect.height);
            }
            if (TestSubImage.this.curRect != null) {
                graphics2D.fillRect(((TestSubImage)TestSubImage.this).curRect.x, ((TestSubImage)TestSubImage.this).curRect.y, ((TestSubImage)TestSubImage.this).curRect.width, ((TestSubImage)TestSubImage.this).curRect.height);
            }
            object = null;
            if (TestSubImage.this.lastRect != null) {
                object = new Rectangle(TestSubImage.this.lastRect);
                if (TestSubImage.this.curRect != null) {
                    ((Rectangle)object).add(TestSubImage.this.curRect);
                }
            } else if (TestSubImage.this.curRect != null) {
                object = TestSubImage.this.curRect;
            }
            TestSubImage.this.lastRect = TestSubImage.this.curRect;
            TestSubImage.this.curRect = null;
            if (object != null) {
                int n = ((Rectangle)object).y;
                if (!TestSubImage.this.texture.getMustFlipVertically()) {
                    n = TestSubImage.this.texture.getHeight() - n;
                }
                TestSubImage.this.texture.updateSubImage((GL)gL2, TestSubImage.this.textureData, 0, ((Rectangle)object).x, n, ((Rectangle)object).x, n, ((Rectangle)object).width, ((Rectangle)object).height);
            }
            TestSubImage.this.texture.enable((GL)gL2);
            TestSubImage.this.texture.bind((GL)gL2);
            gL2.glTexEnvi(8960, 8704, 7681);
            TextureCoords textureCoords = TestSubImage.this.texture.getImageTexCoords();
            gL2.glBegin(7);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL2.glVertex3f(0.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL2.glVertex3f(1.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL2.glVertex3f(1.0f, 1.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL2.glVertex3f(0.0f, 1.0f, 0.0f);
            gL2.glEnd();
            TestSubImage.this.texture.disable((GL)gL2);
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

