/*
 * Decompiled with CFR 0.152.
 */
package demos.texture;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class TestTexture
implements GLEventListener {
    private File curDir;
    private boolean newTexture;
    private boolean flushTexture;
    private File file;
    private Texture texture;
    private GLU glu = new GLU();

    public static void main(String[] stringArray) {
        new TestTexture().run(stringArray);
    }

    private void run(String[] stringArray) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JFrame jFrame = new JFrame("Texture Loader Demo");
        jFrame.setDefaultCloseOperation(3);
        final GLCanvas gLCanvas = new GLCanvas();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open texture...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser(TestTexture.this.curDir);
                int n = jFileChooser.showOpenDialog(null);
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    TestTexture.this.curDir = file.getParentFile();
                    TestTexture.this.setTextureFile(file);
                    gLCanvas.repaint();
                }
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Flush texture");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TestTexture.this.flushTexture();
                gLCanvas.repaint();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        gLCanvas.addGLEventListener((GLEventListener)this);
        jFrame.getContentPane().add((Component)gLCanvas);
        jFrame.setJMenuBar(jMenuBar);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
    }

    public void setTextureFile(File file) {
        this.file = file;
        this.newTexture = true;
    }

    public void flushTexture() {
        this.flushTexture = true;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gLAutoDrawable.setGL((GL)new DebugGL2(gL2.getGL2()));
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glEnable(2929);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D(0.0f, 1.0f, 0.0f, 1.0f);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        if (this.flushTexture) {
            this.flushTexture = false;
            if (this.texture != null) {
                this.texture.destroy((GL)gL2);
                this.texture = null;
            }
        }
        if (this.newTexture) {
            this.newTexture = false;
            if (this.texture != null) {
                this.texture.destroy((GL)gL2);
                this.texture = null;
            }
            try {
                System.err.println("Loading texture...");
                this.texture = TextureIO.newTexture((File)this.file, (boolean)true);
                System.err.println("Texture estimated memory size = " + this.texture.getEstimatedMemorySize());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
                JOptionPane.showMessageDialog(null, byteArrayOutputStream.toString(), "Error loading texture", 0);
                return;
            }
        }
        if (this.texture != null) {
            this.texture.enable((GL)gL2);
            this.texture.bind((GL)gL2);
            gL2.glTexEnvi(8960, 8704, 7681);
            TextureCoords textureCoords = this.texture.getImageTexCoords();
            gL2.glBegin(7);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
            gL2.glVertex3f(0.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
            gL2.glVertex3f(1.0f, 0.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
            gL2.glVertex3f(1.0f, 1.0f, 0.0f);
            gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
            gL2.glVertex3f(0.0f, 1.0f, 0.0f);
            gL2.glEnd();
            this.texture.disable((GL)gL2);
        }
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }
}

