/*
 * Decompiled with CFR 0.152.
 */
package demos.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;

public class TextureConvert {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.out.println("Usage: java demos.texture.TextureConvert [input file] [output file]");
            System.out.println("Converts texture from input file format to output file format.");
            System.out.println("If output file format is DDS, compresses texture with DXT3 compression");
            System.out.println("if available.");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setDoubleBuffered(false);
        if (!GLDrawableFactory.getFactory((GLProfile)gLProfile).canCreateGLPbuffer(null, gLProfile)) {
            System.out.println("Pbuffer support not available (required to run this demo)");
            System.exit(1);
        }
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = GLDrawableFactory.getFactory((GLProfile)gLProfile).createOffscreenAutoDrawable(null, (GLCapabilitiesImmutable)gLCapabilities, null, 2, 2);
        gLOffscreenAutoDrawable.display();
        gLOffscreenAutoDrawable.getContext().makeCurrent();
        GL gL = gLOffscreenAutoDrawable.getGL();
        boolean bl = false;
        if ("dds".equals(IOUtil.getFileSuffix((String)string2)) && (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc"))) {
            bl = true;
        }
        TextureData textureData = TextureIO.newTextureData((GLProfile)gLProfile, (File)new File(string), (boolean)false, null);
        if (bl && !textureData.isDataCompressed()) {
            textureData.setInternalFormat(33778);
        }
        Texture texture = TextureIO.newTexture((TextureData)textureData);
        TextureIO.write((Texture)texture, (File)new File(string2));
    }
}

