/*
 * Decompiled with CFR 0.152.
 */
package demos.vertexBufferObject;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.Animator;
import demos.common.Demo;
import demos.common.DemoListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class VertexBufferObject
extends Demo {
    private GLU glu = new GLU();
    private boolean initComplete;
    private boolean[] b = new boolean[256];
    private static final int SIZEOF_FLOAT = 4;
    private static final int STRIP_SIZE = 144;
    private int tileSize = 432;
    private int numBuffers = 1;
    private int bufferLength = 1000000;
    private int bufferSize = this.bufferLength * 4;
    private static final int SIN_ARRAY_SIZE = 1024;
    private int bigBufferObject;
    private boolean vboEnabled = true;
    private ByteBuffer bigArrayVBOBytes;
    private FloatBuffer bigArrayVBO;
    private FloatBuffer bigArraySystem;
    private FloatBuffer bigArray;
    private IntBuffer[] elements;
    private int elementBufferObject;
    private float[] xyArray;
    private VBOBuffer[] buffers;
    private float[] sinArray;
    private float[] cosArray;
    private int primitive = 8;
    private float hicoef = 0.06f;
    private float locoef = 0.1f;
    private float hifreq = 6.1f;
    private float lofreq = 2.5f;
    private float phaseRate = 0.02f;
    private float phase2Rate = -0.12f;
    private float phase = 0.0f;
    private float phase2 = 0.0f;
    float[] ysinlo = new float[144];
    float[] ycoslo = new float[144];
    float[] ysinhi = new float[144];
    float[] ycoshi = new float[144];
    private volatile boolean toggleVBO = false;
    private volatile boolean toggleLighting = false;
    private volatile boolean toggleLightingModel = false;
    private volatile boolean recomputeElements = false;
    private boolean firstProfiledFrame;
    private int profiledFrameCount;
    private int numDrawElementsCalls;
    private long startTimeMillis;

    public static void main(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-slow")) continue;
            bl = false;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
        VertexBufferObject vertexBufferObject = new VertexBufferObject();
        vertexBufferObject.vboEnabled = bl;
        gLCanvas.addGLEventListener((GLEventListener)vertexBufferObject);
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        animator.setRunAsFastAsPossible(true);
        vertexBufferObject.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                VertexBufferObject.runExit(animator);
            }

            @Override
            public void repaint() {
            }
        });
        Frame frame = new Frame("Very Simple vertex_buffer_object demo");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VertexBufferObject.runExit(animator);
            }
        });
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(800, 800);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        animator.start();
    }

    private static void usage(String[] stringArray) {
        System.err.println("Given args: " + Arrays.asList(stringArray));
        System.err.println("usage: java VertexBufferObject [-slow]");
        System.err.println("-slow flag starts up using data in the Java heap");
        System.exit(0);
    }

    public VertexBufferObject() {
        this.setFlag(' ', true);
        this.setFlag('i', true);
    }

    private void setFlag(char c, boolean bl) {
        this.b[c & 0xFF] = bl;
    }

    private boolean getFlag(char c) {
        return this.b[c & 0xFF];
    }

    private void initExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            final String string2 = "OpenGL extension \"" + string + "\" not available";
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
                    VertexBufferObject.this.shutdownDemo();
                }
            }).start();
            throw new RuntimeException(string2);
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.initComplete = false;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.setSwapInterval(0);
        this.initExtension((GL)gL2, "GL_ARB_vertex_buffer_object");
        gL2.glEnable(2929);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glEnable(16384);
        gL2.glEnable(2896);
        gL2.glEnable(2977);
        gL2.glMaterialfv(1032, 4608, new float[]{0.1f, 0.1f, 0.0f, 1.0f}, 0);
        gL2.glMaterialfv(1032, 4609, new float[]{0.6f, 0.6f, 0.1f, 1.0f}, 0);
        gL2.glMaterialfv(1032, 4610, new float[]{1.0f, 1.0f, 0.75f, 1.0f}, 0);
        gL2.glMaterialf(1032, 5633, 128.0f);
        gL2.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, 0.5f, 0.0f}, 0);
        gL2.glLightModeli(2897, 0);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluPerspective(60.0, 1.0, 0.1, 100.0);
        gL2.glMatrixMode(5888);
        this.allocateBigArray(gL2);
        this.allocateBuffers((GL)gL2);
        this.sinArray = new float[1024];
        this.cosArray = new float[1024];
        for (int i = 0; i < 1024; ++i) {
            double d = (double)(i * 2) * Math.PI / 1024.0;
            this.sinArray[i] = (float)Math.sin(d);
            this.cosArray[i] = (float)Math.cos(d);
        }
        this.bigArray = this.vboEnabled ? this.bigArrayVBO : this.bigArraySystem;
        this.setupBuffers();
        gL2.glEnableClientState(32884);
        gL2.glEnableClientState(32885);
        this.computeElements(gL2);
        if (gLAutoDrawable instanceof AWTGLAutoDrawable) {
            ((AWTGLAutoDrawable)gLAutoDrawable).addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    VertexBufferObject.this.dispatchKey(keyEvent.getKeyChar());
                }
            });
        }
        this.initComplete = true;
    }

    private void allocateBuffers(GL gL) {
        this.buffers = new VBOBuffer[this.numBuffers];
        for (int i = 0; i < this.numBuffers; ++i) {
            this.buffers[i] = new VBOBuffer();
        }
    }

    private void setupBuffers() {
        int n = this.bufferLength / this.numBuffers;
        for (int i = 0; i < this.numBuffers; ++i) {
            int n2 = i * n;
            this.buffers[i].vertices = this.sliceBuffer(this.bigArray, n2, n);
            this.buffers[i].normals = this.sliceBuffer(this.buffers[i].vertices, 3, this.buffers[i].vertices.limit() - 3);
            this.buffers[i].vertexOffset = n2 * 4;
            this.buffers[i].normalOffset = (n2 + 3) * 4;
        }
    }

    private void dispatchKey(char c) {
        this.setFlag(c, !this.getFlag(c));
        if (c == '\u001b' || c == 'q') {
            this.shutdownDemo();
            return;
        }
        if (c == 'r' && this.getFlag(c)) {
            this.profiledFrameCount = 0;
            this.numDrawElementsCalls = 0;
            this.firstProfiledFrame = true;
        }
        if (c == 'w') {
            this.primitive = this.getFlag(c) ? 3 : 8;
        }
        if (c == 'p') {
            this.primitive = this.getFlag(c) ? 0 : 8;
        }
        if (c == 'v') {
            this.toggleVBO = true;
        }
        if (c == 'd') {
            this.toggleLighting = true;
        }
        if (c == 'i') {
            this.toggleLightingModel = true;
        }
        if ('h' == c) {
            this.hicoef = (float)((double)this.hicoef + 0.005);
        }
        if ('H' == c) {
            this.hicoef = (float)((double)this.hicoef - 0.005);
        }
        if ('l' == c) {
            this.locoef = (float)((double)this.locoef + 0.005);
        }
        if ('L' == c) {
            this.locoef = (float)((double)this.locoef - 0.005);
        }
        if ('1' == c) {
            this.lofreq += 0.1f;
        }
        if ('2' == c) {
            this.lofreq -= 0.1f;
        }
        if ('3' == c) {
            this.hifreq += 0.1f;
        }
        if ('4' == c) {
            this.hifreq -= 0.1f;
        }
        if ('5' == c) {
            this.phaseRate += 0.01f;
        }
        if ('6' == c) {
            this.phaseRate -= 0.01f;
        }
        if ('7' == c) {
            this.phase2Rate += 0.01f;
        }
        if ('8' == c) {
            this.phase2Rate -= 0.01f;
        }
        if ('t' == c && this.tileSize < 864) {
            this.tileSize += 144;
            this.recomputeElements = true;
            System.err.println("tileSize = " + this.tileSize);
        }
        if ('T' == c && this.tileSize > 144) {
            this.tileSize -= 144;
            this.recomputeElements = true;
            System.err.println("tileSize = " + this.tileSize);
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.initComplete) {
            return;
        }
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        if (this.getFlag(' ')) {
            this.phase += this.phaseRate;
            this.phase2 += this.phase2Rate;
            if (this.phase > 62.831852f) {
                this.phase = 0.0f;
            }
            if (this.phase2 < -62.831852f) {
                this.phase2 = 0.0f;
            }
        }
        PeriodicIterator periodicIterator = new PeriodicIterator(1024, (float)Math.PI * 2, this.phase, (float)((double)(1.0f / (float)this.tileSize * this.lofreq) * Math.PI));
        PeriodicIterator periodicIterator2 = new PeriodicIterator(periodicIterator);
        PeriodicIterator periodicIterator3 = new PeriodicIterator(1024, (float)Math.PI * 2, this.phase2, (float)((double)(1.0f / (float)this.tileSize * this.hifreq) * Math.PI));
        PeriodicIterator periodicIterator4 = new PeriodicIterator(periodicIterator3);
        if (this.toggleVBO) {
            boolean bl = this.vboEnabled = !this.vboEnabled;
            if (!this.vboEnabled) {
                this.bigArray = this.bigArraySystem;
                this.setupBuffers();
            }
            this.toggleVBO = false;
        }
        if (this.toggleLighting) {
            if (this.getFlag('d')) {
                gL2.glDisable(2896);
            } else {
                gL2.glEnable(2896);
            }
            this.toggleLighting = false;
        }
        if (this.toggleLightingModel) {
            if (this.getFlag('i')) {
                gL2.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, 0.5f, 0.0f}, 0);
                gL2.glLightModeli(2897, 0);
            } else {
                gL2.glLightfv(16384, 4611, new float[]{0.5f, 0.0f, -0.5f, 1.0f}, 0);
                gL2.glLightModeli(2897, 1);
            }
            this.toggleLightingModel = false;
        }
        if (this.recomputeElements) {
            this.computeElements(gL2);
            this.recomputeElements = false;
        }
        gL2.glClear(16640);
        gL2.glPushMatrix();
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
        gL2.glLoadMatrixf(fArray, 0);
        int n = 0;
        int n2 = this.tileSize / 144;
        if (this.vboEnabled) {
            gL2.glBindBuffer(34962, this.bigBufferObject);
        } else {
            gL2.glBindBuffer(34962, 0);
        }
        int n3 = n2;
        while (--n3 >= 0) {
            Buffer buffer;
            n = n3 % this.numBuffers;
            if (this.vboEnabled) {
                buffer = gL2.glMapBuffer(34962, 35001);
                if (buffer == null) {
                    throw new RuntimeException("Unable to map vertex buffer object");
                }
                if (buffer != this.bigArrayVBOBytes) {
                    this.bigArrayVBOBytes = buffer;
                    this.bigArrayVBO = this.setupBuffer((ByteBuffer)buffer);
                }
                if (this.bigArray != this.bigArrayVBO) {
                    this.bigArray = this.bigArrayVBO;
                    this.setupBuffers();
                }
            }
            buffer = this.buffers[n].vertices;
            int n4 = 0;
            if (this.vboEnabled) {
                gL2.glVertexPointer(3, 5126, 24, (long)this.buffers[n].vertexOffset);
                gL2.glNormalPointer(5126, 24, (long)this.buffers[n].normalOffset);
            } else {
                gL2.glVertexPointer(3, 5126, 24, buffer);
                gL2.glNormalPointer(5126, 24, (Buffer)this.buffers[n].normals);
            }
            int n5 = 144;
            while (--n5 >= 0) {
                this.ysinlo[n5] = this.sinArray[periodicIterator2.getIndex()];
                this.ycoslo[n5] = this.cosArray[periodicIterator2.getIndex()];
                periodicIterator2.incr();
                this.ysinhi[n5] = this.sinArray[periodicIterator4.getIndex()];
                this.ycoshi[n5] = this.cosArray[periodicIterator4.getIndex()];
                periodicIterator4.incr();
            }
            periodicIterator2.decr();
            periodicIterator4.decr();
            n5 = this.tileSize;
            while (--n5 >= 0) {
                float f = this.xyArray[n5];
                int n6 = periodicIterator.getIndex();
                int n7 = periodicIterator3.getIndex();
                int n8 = 143 * n3;
                float f2 = this.locoef * -this.cosArray[n6] + this.hicoef * -this.cosArray[n7];
                float f3 = this.locoef;
                float f4 = this.hicoef;
                float[] fArray2 = this.ysinlo;
                float[] fArray3 = this.ysinhi;
                float[] fArray4 = this.ycoslo;
                float[] fArray5 = this.ycoshi;
                float[] fArray6 = this.sinArray;
                float[] fArray7 = this.xyArray;
                int n9 = 144;
                while (--n9 >= 0) {
                    float f5 = fArray7[n9 + n8];
                    ((FloatBuffer)buffer).put(n4, f);
                    ((FloatBuffer)buffer).put(n4 + 1, f5);
                    ((FloatBuffer)buffer).put(n4 + 2, f3 * (fArray6[n6] + fArray2[n9]) + f4 * (fArray6[n7] + fArray3[n9]));
                    ((FloatBuffer)buffer).put(n4 + 3, f2);
                    float f6 = f3 * -fArray4[n9] + f4 * -fArray5[n9];
                    ((FloatBuffer)buffer).put(n4 + 4, f6);
                    ((FloatBuffer)buffer).put(n4 + 5, 0.15f);
                    n4 += 6;
                }
                periodicIterator.incr();
                periodicIterator3.incr();
            }
            periodicIterator.reset();
            periodicIterator3.reset();
            if (this.vboEnabled) {
                gL2.glUnmapBuffer(34962);
            }
            if (this.getFlag('m')) {
                n5 = this.tileSize - 1;
                gL2.glBindBuffer(34963, this.elementBufferObject);
                for (int i = 0; i < n5; ++i) {
                    ++this.numDrawElementsCalls;
                    gL2.glDrawElements(this.primitive, 288, 5125, (long)(i * 2 * 144 * 4));
                    if (!this.getFlag('f')) continue;
                    gL2.glFlush();
                }
                gL2.glBindBuffer(34963, 0);
                continue;
            }
            for (n5 = 0; n5 < this.elements.length; ++n5) {
                ++this.numDrawElementsCalls;
                gL2.glDrawElements(this.primitive, this.elements[n5].remaining(), 5125, (Buffer)this.elements[n5]);
                if (!this.getFlag('f')) continue;
                gL2.glFlush();
            }
        }
        gL2.glPopMatrix();
        if (this.getFlag('r')) {
            if (!this.firstProfiledFrame) {
                if (++this.profiledFrameCount == 30) {
                    long l = System.currentTimeMillis();
                    double d = (double)(l - this.startTimeMillis) / 1000.0;
                    double d2 = 30.0 / d;
                    double d3 = this.tileSize * this.tileSize * 2;
                    double d4 = d3 * d2 / 1000000.0;
                    System.err.println("fps: " + d2 + " polys/frame: " + d3 + " million polys/sec: " + d4 + " DrawElements calls/frame: " + this.numDrawElementsCalls / 30);
                    this.profiledFrameCount = 0;
                    this.numDrawElementsCalls = 0;
                    this.startTimeMillis = System.currentTimeMillis();
                }
            } else {
                this.startTimeMillis = System.currentTimeMillis();
                this.firstProfiledFrame = false;
            }
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void allocateBigArray(GL2 gL2) {
        this.bigArraySystem = this.setupBuffer(ByteBuffer.allocateDirect(this.bufferSize));
        int[] nArray = new int[1];
        gL2.glGenBuffers(1, nArray, 0);
        this.bigBufferObject = nArray[0];
        gL2.glBindBuffer(34962, this.bigBufferObject);
        gL2.glBufferData(34962, (long)this.bufferSize, (Buffer)null, 35048);
        this.bigArrayVBOBytes = gL2.glMapBuffer(34962, 35001);
        this.bigArrayVBO = this.setupBuffer(this.bigArrayVBOBytes);
        gL2.glUnmapBuffer(34962);
        gL2.glBindBuffer(34962, 0);
        float f = (float)this.bufferSize / 1000000.0f;
        System.err.println("Allocated " + f + " megabytes of fast memory");
    }

    private FloatBuffer setupBuffer(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asFloatBuffer();
    }

    private FloatBuffer sliceBuffer(FloatBuffer floatBuffer, int n, int n2) {
        floatBuffer.position(n);
        FloatBuffer floatBuffer2 = floatBuffer.slice();
        floatBuffer.position(0);
        floatBuffer2.limit(n2);
        return floatBuffer2;
    }

    private void computeElements(GL2 gL2) {
        int n;
        int n2;
        this.xyArray = new float[this.tileSize];
        for (n2 = 0; n2 < this.tileSize; ++n2) {
            this.xyArray[n2] = (float)n2 / ((float)this.tileSize - 1.0f) - 0.5f;
        }
        this.elements = new IntBuffer[this.tileSize - 1];
        for (n2 = 0; n2 < this.tileSize - 1; ++n2) {
            this.elements[n2] = IntBuffer.allocate(288);
            for (n = 0; n < 288; n += 2) {
                this.elements[n2].put(n, n2 * 144 + n / 2);
                this.elements[n2].put(n + 1, (n2 + 1) * 144 + n / 2);
            }
        }
        IntBuffer intBuffer = IntBuffer.allocate((this.tileSize - 1) * 288);
        n = 0;
        for (int i = 0; i < this.tileSize - 1; ++i) {
            for (int j = 0; j < 288; j += 2) {
                intBuffer.put(n++, i * 144 + j / 2);
                intBuffer.put(n++, (i + 1) * 144 + j / 2);
            }
        }
        int[] nArray = new int[1];
        gL2.glGenBuffers(1, nArray, 0);
        this.elementBufferObject = nArray[0];
        gL2.glBindBuffer(34963, this.elementBufferObject);
        gL2.glBufferData(34963, (long)(intBuffer.remaining() * 4), (Buffer)intBuffer, 35044);
        gL2.glBindBuffer(34963, 0);
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }

    static class VBOBuffer {
        public FloatBuffer vertices;
        public FloatBuffer normals;
        public int vertexOffset;
        public int normalOffset;

        VBOBuffer() {
        }
    }

    static class PeriodicIterator {
        private int arraySizeMask;
        private int increment;
        private int initOffset;
        private int index;

        public PeriodicIterator(int n, float f, float f2, float f3) {
            float f4 = (float)n * (f3 / f);
            this.increment = (int)(f4 * 65536.0f);
            float f5 = (float)n * (f2 / f);
            this.initOffset = (int)(f5 * 65536.0f);
            this.arraySizeMask = 0;
            int n2 = 20;
            while ((n & 1 << n2) == 0) {
                --n2;
            }
            this.arraySizeMask = (1 << n2) - 1;
            this.index = this.initOffset;
        }

        public PeriodicIterator(PeriodicIterator periodicIterator) {
            this.arraySizeMask = periodicIterator.arraySizeMask;
            this.increment = periodicIterator.increment;
            this.initOffset = periodicIterator.initOffset;
            this.index = periodicIterator.index;
        }

        public int getIndex() {
            return this.index >> 16 & this.arraySizeMask;
        }

        public void incr() {
            this.index += this.increment;
        }

        public void decr() {
            this.index -= this.increment;
        }

        public void reset() {
            this.index = this.initOffset;
        }
    }
}

