/*
 * Decompiled with CFR 0.152.
 */
package demos.vertexProgRefract;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.gl2.GLUT;
import com.jogamp.opengl.util.texture.Texture;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.util.Bunny;
import demos.util.Cubemap;
import demos.util.SystemTime;
import demos.util.Time;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.ExaminerViewer;
import gleem.ManipManager;
import gleem.linalg.Rotf;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JOptionPane;

public class VertexProgRefract
extends Demo {
    private boolean initComplete;
    private boolean firstRender = true;
    private int vtxProg;
    private int fragProg;
    private Texture cubemap;
    private int bunnydl;
    private int obj;
    private GLUT glut = new GLUT();
    private GLAutoDrawable drawable;
    private ExaminerViewer viewer;
    private boolean doViewAll = true;
    private Time time = new SystemTime();
    private float animRate = (float)Math.toRadians(-6.0);
    private float refract = 1.1f;
    private float wavelengthDelta = 0.05f;
    private float fresnel = 2.0f;
    private boolean wire = false;
    private boolean toggleWire = false;
    private static final String transformRefract = "!!ARBvp1.0\n# Refraction\n\n# Parameters\nPARAM mvp [4]       = { state.matrix.mvp };     # modelview projection matrix\nPARAM mvit[4]       = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]       = { state.matrix.modelview }; # modelview matrix\nPARAM tex [4]       = { state.matrix.texture }; # texture matrix\nPARAM eyePosition   = program.env[0];           # eye position\nPARAM fresnel       = program.env[1];           # fresnel multiplier\nPARAM texScale      = program.env[2];           # texture scale\nPARAM misc          = program.env[3];           # misc. constants\nPARAM refraction    = program.env[4];           # refractive index\n\n# Per vertex inputs\nATTRIB iPos         = vertex.position;          #position\nATTRIB iCol0        = vertex.color;             #color\nATTRIB iNorm        = vertex.normal;            #normal\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r8;\nTEMP r9;\nTEMP r11;\n\n# Outputs\nOUTPUT oPos         = result.position;          #position\nOUTPUT oCol0        = result.color;             #primary color\nOUTPUT oTex0        = result.texcoord[0];       #texture coordinate set 0\nOUTPUT oTex1        = result.texcoord[1];       #texture coordinate set 1\n\n\n# transform vertex position to eye space\nDP4    r9.x, mv[0], iPos ;\nDP4    r9.y, mv[1], iPos ;\nDP4    r9.z, mv[2], iPos ;\nDP4    r9.w, mv[3], iPos ;\n\n# transform normal to eye space\nDP3    r11.x, mvit[0], iNorm ;\nDP3    r11.y, mvit[1], iNorm ;\nDP3    r11.z, mvit[2], iNorm ;\n\n# vertex->eye vector\nADD    r0, -r9, eyePosition;\n\n# normalize\nDP3    r8.w, r0, r0;\nRSQ    r8.w, r8.w;\nMUL    r8, r0, r8.w;       # r8 = eye/incident vector\n\n# refraction, Renderman style\n\n# float IdotN = I.N;\n# float k = 1 - eta*eta*(1 - IdotN*IdotN);\n# return k < 0 ? (0,0,0) : eta*I - (eta*IdotN + sqrt(k))*N;\n\nDP3    r0.x, r11, -r8;             # r0 = N.I\n\nMAD    r1.x, -r0.x, r0.x, misc.y;  # r1 = -IdotN*IdotN + 1\nMUL    r1.x, r1.x, refraction.y;   # r1 = -(r1*eta*eta)+1\nADD    r1.x, misc.y, -r1.x;\n\nRSQ    r2.x, r1.x;\nRCP    r2.x, r2.x;\nMAD    r2.x, refraction.x, r0.x, r2.x;\nMUL    r2, r11, r2.x;\nMAD    r2, refraction.x, -r8, r2;\n\n# transform refracted ray by cubemap transform\nDP3    oTex0.x, tex[0], r2;\nDP3    oTex0.y, tex[1], r2;\nDP3    oTex0.z, tex[2], r2;\n\n# calculate reflection\nMUL    r0, r11, misc.z;\nDP3    r3.w, r11, r8;\nMAD    r3, r3.w, r0, -r8;\n\n# transform reflected ray by cubemap transform\nDP3    oTex1.x, tex[0], r3;\nDP3    oTex1.y, tex[1], r3;\nDP3    oTex1.z, tex[2], r3;\n\n# cheesy Fresnel approximation = (1-(I.N))^p\nDP3    r0.x, r8, r11;\nADD    r0.x, misc.y, -r0.x;\nMUL    r0.x, r0.x, r0.x;\nMUL    oCol0, r0.x, fresnel;\n\n# transform vertex to clip space\nDP4    oPos.x, mvp[0], iPos ;\nDP4    oPos.y, mvp[1], iPos ;\nDP4    oPos.z, mvp[2], iPos ;\nDP4    oPos.w, mvp[3], iPos ;\n\nEND\n";
    private boolean[] b = new boolean[256];

    public static void main(String[] stringArray) {
        GLCanvas gLCanvas = new GLCanvas();
        final VertexProgRefract vertexProgRefract = new VertexProgRefract();
        gLCanvas.addGLEventListener((GLEventListener)vertexProgRefract);
        gLCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                vertexProgRefract.dispatchKey(keyEvent.getKeyChar());
            }
        });
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        vertexProgRefract.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                VertexProgRefract.runExit(animator);
            }

            @Override
            public void repaint() {
            }
        });
        Frame frame = new Frame("Refraction Using Vertex Programs");
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VertexProgRefract.runExit(animator);
            }
        });
        animator.start();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        gLAutoDrawable.setGL((GL)new DebugGL2(gLAutoDrawable.getGL().getGL2()));
        this.initComplete = false;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        float f = 1.0f;
        gL2.glClearColor(f, f, f, 1.0f);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        gL2.glEnable(2929);
        try {
            this.initExtension((GL)gL2, "GL_ARB_vertex_program");
            this.initExtension((GL)gL2, "GL_VERSION_1_3");
            if (!gL2.isExtensionAvailable("GL_ARB_fragment_program")) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "This demo requires the GL_ARB_fragment_program extension", "Unavailable extension", 0);
                        VertexProgRefract.this.shutdownDemo();
                    }
                }).start();
                throw new RuntimeException("This demo requires the GL_ARB_fragment_program extension");
            }
        }
        catch (RuntimeException runtimeException) {
            this.shutdownDemo();
            throw runtimeException;
        }
        this.b[32] = true;
        int[] nArray = new int[1];
        gL2.glGenProgramsARB(1, nArray, 0);
        this.vtxProg = nArray[0];
        gL2.glBindProgramARB(34336, this.vtxProg);
        gL2.glProgramStringARB(34336, 34933, transformRefract.length(), transformRefract);
        gL2.glProgramEnvParameter4fARB(34336, 0, 0.0f, 0.0f, 0.0f, 1.0f);
        gL2.glProgramEnvParameter4fARB(34336, 1, this.fresnel, this.fresnel, this.fresnel, 1.0f);
        gL2.glProgramEnvParameter4fARB(34336, 2, 1.0f, -1.0f, 1.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 3, 0.0f, 1.0f, 2.0f, 3.0f);
        try {
            this.cubemap = Cubemap.loadFromStreams((GL)gL2, (ClassLoader)this.getClass().getClassLoader(), (String)"demos/data/cubemaps/uffizi_", (String)"png", (boolean)true);
        }
        catch (IOException iOException) {
            this.shutdownDemo();
            throw new RuntimeException(iOException);
        }
        gL2.glTexEnvi(8960, 8704, 7681);
        gL2.glDisable(2884);
        this.initFragmentProgram(gL2);
        try {
            this.bunnydl = Bunny.gen3DObjectList((GL2)gL2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.doViewAll = true;
        if (this.firstRender) {
            this.firstRender = false;
            ManipManager manipManager = ManipManager.getManipManager();
            manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
            this.drawable = gLAutoDrawable;
            this.viewer = new ExaminerViewer();
            this.viewer.setUpVector(Vec3f.Y_AXIS);
            this.viewer.setNoAltKeyMode(true);
            this.viewer.setAutoRedrawMode(false);
            this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new BSphereProvider(){

                public BSphere getBoundingSphere() {
                    return new BSphere(new Vec3f(0.0f, 0.0f, 0.0f), 1.0f);
                }
            });
            this.viewer.setVertFOV(1.4726216f);
            this.viewer.setZNear(0.1f);
            this.viewer.setZFar(10.0f);
        }
        this.initComplete = true;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.initComplete) {
            return;
        }
        this.time.update();
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        if (this.doViewAll) {
            this.viewer.viewAll(gL2);
            this.doViewAll = false;
        }
        if (this.getFlag(' ')) {
            this.viewer.rotateAboutFocalPoint(new Rotf(Vec3f.Y_AXIS, (float)(this.time.deltaT() * (double)this.animRate)));
        }
        if (this.toggleWire) {
            this.toggleWire = false;
            boolean bl = this.wire = !this.wire;
            if (this.wire) {
                gL2.glPolygonMode(1032, 6913);
            } else {
                gL2.glPolygonMode(1032, 6914);
            }
        }
        gL2.glDisable(2929);
        this.drawSkyBox(gL2);
        gL2.glEnable(2929);
        gL2.glPushMatrix();
        this.viewer.update(gL2);
        ManipManager.getManipManager().updateCameraParameters((AWTGLAutoDrawable)gLAutoDrawable, this.viewer.getCameraParameters());
        ManipManager.getManipManager().render((AWTGLAutoDrawable)gLAutoDrawable, gL2);
        gL2.glBindProgramARB(34336, this.vtxProg);
        gL2.glEnable(34336);
        gL2.glProgramEnvParameter4fARB(34336, 62, this.fresnel, this.fresnel, this.fresnel, 1.0f);
        gL2.glActiveTexture(33984);
        this.cubemap.bind((GL)gL2);
        this.cubemap.enable((GL)gL2);
        gL2.glMatrixMode(5890);
        gL2.glLoadIdentity();
        this.viewer.updateInverseRotation(gL2);
        gL2.glActiveTexture(33985);
        this.cubemap.bind((GL)gL2);
        this.cubemap.enable((GL)gL2);
        gL2.glMatrixMode(5890);
        gL2.glLoadIdentity();
        this.viewer.updateInverseRotation(gL2);
        gL2.glBindProgramARB(34820, this.fragProg);
        gL2.glEnable(34820);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        if (this.getFlag('s')) {
            this.setRefraction(gL2, this.refract);
            this.drawObj(gL2, this.obj);
        } else {
            gL2.glColorMask(true, false, false, false);
            this.setRefraction(gL2, this.refract);
            this.drawObj(gL2, this.obj);
            gL2.glDepthMask(false);
            gL2.glDepthFunc(514);
            gL2.glColorMask(false, true, false, false);
            this.setRefraction(gL2, this.refract + this.wavelengthDelta);
            this.drawObj(gL2, this.obj);
            gL2.glColorMask(false, false, true, false);
            this.setRefraction(gL2, this.refract + this.wavelengthDelta * 2.0f);
            this.drawObj(gL2, this.obj);
            gL2.glDepthMask(true);
            gL2.glDepthFunc(513);
            gL2.glColorMask(true, true, true, false);
        }
        gL2.glDisable(34820);
        gL2.glDisable(34336);
        gL2.glMatrixMode(5888);
        gL2.glPopMatrix();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    @Override
    public void shutdownDemo() {
        if (this.drawable != null) {
            this.viewer.detach();
            ManipManager.getManipManager().unregisterWindow((AWTGLAutoDrawable)this.drawable);
            this.drawable.removeGLEventListener((GLEventListener)this);
        }
        super.shutdownDemo();
    }

    private void dispatchKey(char c) {
        this.setFlag(c, !this.getFlag(c));
        if (c == '\u001b' || c == 'q') {
            this.shutdownDemo();
            return;
        }
        switch (c) {
            case '1': {
                this.obj = 0;
                break;
            }
            case '2': {
                this.obj = 1;
                break;
            }
            case '3': {
                this.obj = 2;
                break;
            }
            case '4': {
                this.obj = 3;
                break;
            }
            case 'v': {
                this.doViewAll = true;
                break;
            }
            case 'w': {
                this.toggleWire = true;
                break;
            }
        }
    }

    private void setFlag(char c, boolean bl) {
        this.b[c & 0xFF] = bl;
    }

    private boolean getFlag(char c) {
        return this.b[c & 0xFF];
    }

    private void initExtension(GL gL, String string) {
        if (!gL.isExtensionAvailable(string)) {
            final String string2 = "OpenGL extension \"" + string + "\" not available";
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
                    VertexProgRefract.this.shutdownDemo();
                }
            }).start();
            throw new RuntimeException(string2);
        }
    }

    private void initFragmentProgram(GL2 gL2) {
        int[] nArray = new int[1];
        gL2.glGenProgramsARB(1, nArray, 0);
        this.fragProg = nArray[0];
        String string = "!!ARBfp1.0\n# compute refraction*(1-fresnel) + reflection*fresnel\nTEMP texSamp0, texSamp1;\nTEMP invFresnel;\nPARAM one = { 1.0, 1.0, 1.0, 1.0 };\nTEX texSamp0, fragment.texcoord[0], texture[0], CUBE;\nTEX texSamp1, fragment.texcoord[1], texture[1], CUBE;\nSUB invFresnel, one, fragment.color;\nMUL texSamp0, texSamp0, invFresnel;\nMUL texSamp1, texSamp1, fragment.color;\nADD texSamp0, texSamp0, texSamp1;\nMOV result.color, texSamp0;\nEND";
        gL2.glBindProgramARB(34820, this.fragProg);
        gL2.glProgramStringARB(34820, 34933, string.length(), string);
        int[] nArray2 = new int[1];
        gL2.glGetIntegerv(34379, nArray2, 0);
        if (nArray2[0] >= 0) {
            int n;
            System.out.println("Fragment program failed to load:");
            String string2 = gL2.glGetString(34932);
            if (string2 == null) {
                System.out.println("[No error message available]");
            } else {
                System.out.println("Error message: \"" + string2 + "\"");
            }
            System.out.println("Error occurred at position " + nArray2[0] + " in program:");
            for (n = nArray2[0]; n < string.length() && string.charAt(n) != '\n'; ++n) {
            }
            System.out.println(string.substring(nArray2[0], n));
        }
    }

    private void drawSkyBox(GL2 gL2) {
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
        gL2.glActiveTexture(33985);
        gL2.glDisable(34067);
        gL2.glActiveTexture(33984);
        this.cubemap.bind((GL)gL2);
        this.cubemap.enable((GL)gL2);
        gL2.glEnable(2896);
        gL2.glTexGeni(8192, 9472, 34065);
        gL2.glTexGeni(8193, 9472, 34065);
        gL2.glTexGeni(8194, 9472, 34065);
        gL2.glEnable(3168);
        gL2.glEnable(3169);
        gL2.glEnable(3170);
        gL2.glTexEnvi(8960, 8704, 7681);
        gL2.glMatrixMode(5890);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        this.viewer.updateInverseRotation(gL2);
        this.glut.glutSolidSphere(5.0, 40, 20);
        gL2.glDisable(2896);
        gL2.glPopMatrix();
        gL2.glMatrixMode(5888);
        gL2.glDisable(3168);
        gL2.glDisable(3169);
        gL2.glDisable(3170);
    }

    private void drawObj(GL2 gL2, int n) {
        switch (n) {
            case 0: {
                gL2.glCallList(this.bunnydl);
                break;
            }
            case 1: {
                this.glut.glutSolidSphere(0.5, 64, 64);
                break;
            }
            case 2: {
                this.glut.glutSolidTorus(0.25, 0.5, 64, 64);
                break;
            }
            case 3: {
                this.drawPlane(gL2, 1.0f, 1.0f, 50, 50);
            }
        }
    }

    private void setRefraction(GL2 gL2, float f) {
        gL2.glProgramEnvParameter4fARB(34336, 4, f, f * f, 0.0f, 0.0f);
    }

    private void drawPlane(GL2 gL2, float f, float f2, int n, int n2) {
        float f3 = 1.0f / (float)n2;
        float f4 = 1.0f / (float)n;
        float f5 = f / (float)n2;
        float f6 = f2 / (float)n;
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        for (int i = 0; i < n; ++i) {
            gL2.glBegin(8);
            for (int j = 0; j <= n2; ++j) {
                float f7 = f5 * (float)j - f / 2.0f;
                float f8 = f6 * (float)i - f2 / 2.0f;
                float f9 = f3 * (float)j;
                float f10 = f4 * (float)i;
                gL2.glTexCoord2f(f9, f10);
                gL2.glColor3f(f9, f10, 0.0f);
                gL2.glVertex3f(f7, f8, 0.0f);
                gL2.glColor3f(f9, f10 + f4, 0.0f);
                gL2.glTexCoord2f(f9, f10 + f4);
                gL2.glVertex3f(f7, f8 + f6, 0.0f);
            }
            gL2.glEnd();
        }
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }
}

