/*
 * Decompiled with CFR 0.152.
 */
package demos.vertexProgWarp;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.AWTGLAutoDrawable;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import com.jogamp.opengl.util.Animator;
import demos.common.Demo;
import demos.common.DemoListener;
import demos.util.DurationTimer;
import demos.util.SystemTime;
import demos.util.Time;
import demos.util.Triceratops;
import gleem.BSphere;
import gleem.BSphereProvider;
import gleem.ExaminerViewer;
import gleem.ManipManager;
import gleem.linalg.Vec3f;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JOptionPane;

public class VertexProgWarp
extends Demo {
    private GLAutoDrawable drawable;
    private DurationTimer timer = new DurationTimer();
    private boolean firstRender = true;
    private int frameCount;
    private TitleSetter titleSetter;
    private boolean initComplete;
    private static final float SIN_PERIOD = 3.079f;
    private static final int NUM_OBJS = 5;
    private static final int NUM_PROGS = 7;
    private int[] programs = new int[7];
    private float zNear = 0.1f;
    private float zFar = 10.0f;
    private int program = 2;
    private int obj = 2;
    private boolean[] b = new boolean[256];
    private boolean wire = false;
    private boolean toggleWire = false;
    private boolean animating = true;
    private boolean doViewAll = true;
    private Time time = new SystemTime();
    private float anim = 0.0f;
    private float animScale = 7.0f;
    private float amp = 0.05f;
    private float freq = 8.0f;
    private float d = 4.0f;
    private GLU glu = new GLU();
    private ExaminerViewer viewer;
    private static final String[] programNames = new String[]{"Normal", "Pulsate", "Wave", "Square fisheye", "Spherical fisheye", "Ripple", "Twist"};
    private static final String programSetup = "PARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\n";
    private static final String[] programTexts = new String[]{"!!ARBvp1.0\n#Simple transform and diffuse lighting\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nDP4   oPos.x, mvp[0], iPos ;   # object x MVP -> clip\nDP4   oPos.y, mvp[1], iPos ;\nDP4   oPos.z, mvp[2], iPos ;\nDP4   oPos.w, mvp[3], iPos ;\n\nDP3   r1.x, mvit[0], iNorm ;        # normal x MV-1T -> lighting normal\nDP3   r1.y, mvit[1], iNorm ;\nDP3   r1.z, mvit[2], iNorm ;\n\nDP3   r0, lightPos, r1 ;              # L.N\nMUL   oCol0.xyz, r0, diffuseCol ;     # col = L.N * diffuse\nMOV   oTex0, iTex;\nEND\n", "!!ARBvp1.0\n#Displace geometry along normal based on sine function of distance from origin\n#(in object space)\n#sinFreqAmplitude.x = wave frequency\n#sinFreqAmplitude.y = wave amplitude\n#sinTaylorConst2    = PI constants\n#sinTaylorConst1    = Taylor series constants (see below)\n\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nMOV   r0, iPos; \n\n#calculate distance from (0, 0, 0)\nDP3   r3.x, r0, r0;\nRSQ   r3.x, r3.x;\nRCP   r3.x, r3.x;\n\nMUL   r3.x, r3.x, sinFreqAmplitude.x; # wave frequency\nADD   r3.x, r3.x, phaseAnim.x; # phase animation\n\n#reduce to period of 2*PI\nMUL   r2, r3.x, sinTaylorConst2.x;\nEXP   r4, r2.x;            # r4.y = r2.x - floor(r2.x)\nMUL   r3.x, r4.y, sinTaylorConst2.y;\n\n# offset to -PI - PI\nADD   r3.x, r3.x, -sinTaylorConst2.z;\n\n#Sine approximation using Taylor series (accurate between -PI and PI) :\n#sin(x)  = x - (x^3)/3! + (x^5)/5! - (x^7)/7! + ...\n#sin(x) ~= x*(1 - (x^2)*(1/3! - (x^2)(1/5! - (x^2)/7! )))\n#        = x * (a - y*(b - y*(c - y*d)))\n#where\n#a = 1.0    sinTaylorConst1.x\n#b = 1/3!   sinTaylorConst1.y\n#c = 1/5!   sinTaylorConst1.z\n#d = 1/7!   sinTaylorConst1.w\n#y = x^2    r2\n\n#r1.x = sin(r3.x);\n\nMUL   r2, r3.x, r3.x;\nMAD   r1, -r2, sinTaylorConst1.w, sinTaylorConst1.z;\nMAD   r1, r1, -r2, sinTaylorConst1.y;\nMAD   r1, r1, -r2, sinTaylorConst1.x;\nMUL   r1, r1, r3.x;\n\n#displace vertex along normal\nMUL   r1.x, r1.x, sinFreqAmplitude.y;\nMAX   r1.x, r1.x, smoothstep.x;     # r1.x = max(r1.x, 0.0);\nMUL   r2.xyz, iNorm, r1.x;\nADD   r0.xyz, r0, r2;\n\n#simple lighting\nDP3   r1.x, mvit[0], iNorm ;    # normal x MV-1T -> lighting normal\nDP3   r1.y, mvit[1], iNorm ;\nDP3   r1.z, mvit[2], iNorm ;\n\nDP3   r2, lightPos, r1 ;          # light position DOT normal\nMUL   oCol0.xyz, r2, diffuseCol ; # col = ldotn * diffuse\n\nMOV   oTex0, iTex;\n\nDP4   oPos.x, mvp[0], r0 ;    # object x MVP -> clip\nDP4   oPos.y, mvp[1], r0 ;\nDP4   oPos.z, mvp[2], r0 ;\nDP4   oPos.w, mvp[3], r0 ;\n\nEND\n", "!!ARBvp1.0\n# Perturb vertices in clip space with sine wave\n# x += sin((y*freq)+anim) * amp\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nDP4   r0.x, mvp[0], iPos ;\nDP4   r0.y, mvp[1], iPos ;\nDP4   r0.z, mvp[2], iPos ;\nDP4   r0.w, mvp[3], iPos ;\n\nMUL   r3.x, r0.y, sinFreqAmplitude.x;    # wave frequency\nADD   r3.x, r3.x, phaseAnim.x;    # phase animation\n\n# reduce to period of 2*PI\nMUL   r2, r3.x, sinTaylorConst2.x;\nEXP   r4, r2.x;               # r4.y = r2.x - floor(r2.x)\nMUL   r3.x, r4.y, sinTaylorConst2.y;\n\n# offset to -PI - PI\nADD   r3.x, r3.x, -sinTaylorConst2.z;\n\n# r1.x = sin(r3.x);\nMUL   r2,   r3.x, r3.x;\nMAD   r1, -r2, sinTaylorConst1.w, sinTaylorConst1.z;\nMAD   r1, r1, -r2, sinTaylorConst1.y;\nMAD   r1, r1, -r2, sinTaylorConst1.x;\nMUL   r1, r1, r3.x;\n\nMAD   r0.x, r1.x, sinFreqAmplitude.y, r0.x;\n\n# simple lighting\nDP3   r1.x, mvit[0], iNorm ;    # normal x MV-1T -> lighting normal\nDP3   r1.y, mvit[1], iNorm ;\nDP3   r1.z, mvit[2], iNorm ;\nDP3   r2, lightPos, r1 ;          # light position DOT normal\nMUL   oCol0.xyz, r2, diffuseCol ; # col = ldotn * diffuse\nMOV   oTex0, iTex;\n\nMOV   oPos, r0;\n\nEND\n", "!!ARBvp1.0\n#Fisheye distortion based on function:\n#f(x)=(d+1)/(d+(1/x))\n#maps the [0,1] interval monotonically onto [0,1]\n\n#sinFreqAmplitude.z = d\n#sinFreqAmplitude.w = d+1\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\n\nDP4   r0.x, mvp[0], iPos ;\nDP4   r0.y, mvp[1], iPos ;\nDP4   r0.z, mvp[2], iPos ;\nDP4   r0.w, mvp[3], iPos ;\n\n# do perspective divide\nRCP   r1, r0.w;\nMUL   r0, r0, r1.w;\n\nMAX   r1, r0, -r0;            # r1 = abs(r0)\n\nSLT   r2, r0, smoothstep.x;        # r2 = (r0 < 0.0) ? 1.0 : 0.0\nSGE   r3, r0, smoothstep.x;        # r3 = (r0 >= 0.0) ? 1.0 : 0.0\n\n# distort x\n# h(x)=(d+1)/(d+(1/x))\nRCP   r1.x, r1.x;             # r1 = 1 / r1\nADD   r1.x, r1.x, sinFreqAmplitude.z;    # r1 += d\nRCP   r1.x, r1.x;             # r1 = 1 / r1\nMUL   r1.x, r1.x, sinFreqAmplitude.w;    # r1 *= d + 1\n\n# distort y\nRCP   r1.y, r1.y;             # r1 = 1 / r1\nADD   r1.y, r1.y, sinFreqAmplitude.z;    # r1 += d\nRCP   r1.y, r1.y;             # r1 = 1 / r1\nMUL   r1.y, r1.y, sinFreqAmplitude.w;    # r1 *= d + 1\n\n# handle negative cases\nMUL   r4.xy, r1, r3;          # r4 = r1 * r3\nMAD   r1.xy, r1, -r2, r4;     # r1 = r1 * -r2 + r4\n\n# simple lighting\nDP3   r2.x, mvit[0], iNorm ;   # normal x MV-1T -> lighting normal\nDP3   r2.y, mvit[1], iNorm ;\nDP3   r2.z, mvit[2], iNorm ;\nDP3   r3, lightPos, r2 ;         # light position DOT normal\nMUL   oCol0.xyz, r3, diffuseCol ; # col = ldotn * diffuse\n\nMOV   oTex0, iTex;\n\nMOV   oPos, r1;\n\nEND\n", "!!ARBvp1.0\n# Spherical fish-eye distortion\n# in clip space\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nDP4   r0.x, mvp[0], iPos;\nDP4   r0.y, mvp[1], iPos;\nDP4   r0.z, mvp[2], iPos;\nDP4   r0.w, mvp[3], iPos;\n\n# do perspective divide\nRCP   r1.x, r0.w;\nMUL   r2, r0, r1.x;\n\n# calculate distance from centre\nMUL   r1.x, r2.x, r2.x;\nMAD   r1.x, r2.y, r2.y, r1.x;\nRSQ   r1.x, r1.x; # r1.x = 1 / sqrt(x*x+y*y)\n\n# calculate r3 = normalized direction vector\nMUL   r3.xy, r0, r1.x;\n\nRCP   r1.x, r1.x;             # r1.x = actual distance\nMIN   r1.x, r1.x, smoothstep.y;    # r1.x = min(r1.x, 1.0)\n\n# remap based on: f(x) = sqrt(1-x^2)\nADD   r1.x, smoothstep.y, -r1.x;\nMAD   r1.x, -r1.x, r1.x, smoothstep.y;\nRSQ   r1.x, r1.x;\nRCP   r1.x, r1.x;\n\n# move vertex to new distance from centre\nMUL   r0.xy, r3, r1.x;\n\n# simple lighting\nDP3   r2.x, mvit[0], iNorm;    # normal x MV-1T -> lighting normal\nDP3   r2.y, mvit[1], iNorm;\nDP3   r2.z, mvit[2], iNorm;\nDP3   r3, lightPos, r2 ;         # light position DOT normal\nMUL   oCol0.xyz, r3, diffuseCol ; # col = ldotn * diffuse\n\nMOV   oTex0, iTex;\n\nMOV   oPos, r0;\n\nEND\n", "!!ARBvp1.0\n# Ripple distortion\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nDP4   r0.x, mvp[0], iPos;\nDP4   r0.y, mvp[1], iPos;\nDP4   r0.z, mvp[2], iPos;\nDP4   r0.w, mvp[3], iPos;\n\n# do perspective divide\nRCP   r1.x, r0.w;\nMUL   r4, r0, r1.x;\n\n# calculate distance from centre\nMUL   r1.x, r4.x, r4.x;\nMAD   r1.x, r4.y, r4.y, r1.x;\nRSQ   r1.x, r1.x;\n\nRCP   r1.x, r1.x;\n\nMUL   r1.x, r1.x, sinFreqAmplitude.x;    # wave frequency\nADD   r1.x, r1.x, phaseAnim.x;    # phase animation\n\n# reduce to period of 2*PI\nMUL   r2, r1.x, sinTaylorConst2.x;      # r2 = r1 / 2.0 * PI\nEXP   r4, r2.x;               # r4.y = r2.x - floor(r2.x)\nMUL   r1.x, r4.y, sinTaylorConst2.y;\n\n# offset to -PI - PI\nADD   r1.x, r1.x, -sinTaylorConst2.z;\n\n# r3.x = sin(r1.x)\nMUL   r2, r1.x, r1.x;\nMAD   r3, -r2, sinTaylorConst1.w, sinTaylorConst1.z;\nMAD   r3, r3, -r2, sinTaylorConst1.y;\nMAD   r3, r3, -r2, sinTaylorConst1.x;\nMUL   r3, r3, r1.x;\n\nMUL   r3.x, r3.x, sinFreqAmplitude.y;\n\n# move vertex towards centre based on distance\nMAD   r0.xy, r0, -r3.x, r0;\n\n# lighting\nDP3   r2.x, mvit[0], iNorm;     # normal x MV-1T -> lighting normal\nDP3   r2.y, mvit[1], iNorm;\nDP3   r2.z, mvit[2], iNorm;\nDP3   r3, lightPos, r2;           # light position DOT normal\nMUL   oCol0.xyz, r3, diffuseCol;  # col = ldotn * diffuse\n\nMOV   oTex0, iTex;\n\nMOV   oPos, r0;\n\nEND\n", "!!ARBvp1.0\n# Twist\nPARAM mvp [4]          = { state.matrix.mvp };                # modelview projection matrix\nPARAM mvit[4]          = { state.matrix.modelview.invtrans }; # modelview matrix inverse transpose\nPARAM mv  [4]          = { state.matrix.modelview };          # modelview matrix\nPARAM proj[4]          = { state.matrix.projection };         # projection matrix\nPARAM lightPos         = program.env[0];                      # light position/direction\nPARAM diffuseCol       = program.env[1];                      # diffuse color\nPARAM specularCol      = program.env[2];                      # specular color\nPARAM smoothstep       = program.env[3];                      # smoothstep constants\nPARAM sinTaylorConst1  = program.env[4];                      # sin Taylor series constants 1 of 2\nPARAM sinTaylorConst2  = program.env[5];                      # sin Taylor series constants 2 of 2\nPARAM sinFreqAmplitude = program.env[6];                      # sin wave frequency, amplitude\nPARAM phaseAnim        = program.env[7];                      # phase animation\nPARAM fisheyeRadius    = program.env[8];                      # fisheye sphere radius\n\n# Per vertex inputs\nATTRIB iPos            = vertex.position;                     # position\nATTRIB iTex            = vertex.texcoord;                     # tex coord\nATTRIB iNorm           = vertex.normal;                       # normal\n\n# Outputs\nOUTPUT oPos            = result.position;                     # position\nOUTPUT oCol0           = result.color;                        # color\nOUTPUT oTex0           = result.texcoord;                     # tex coord\n\n# Temporaries\nTEMP r0;\nTEMP r1;\nTEMP r2;\nTEMP r3;\nTEMP r4;\nMOV   r0, iPos;\n\nMUL   r1.x, r0.x, sinFreqAmplitude.x;        # frequency\n\n# calculate sin(angle) and cos(angle)\nADD   r1.y, r1.x, -sinTaylorConst2.w;       # r1.y = r1.x + PI/2.0\n\n# reduce to period of 2*PI\nMUL   r2, r1, sinTaylorConst2.x;            # r2 = r1 / 2.0 * PI\nEXP   r3.y, r2.x;                 # r2.y = r2.x - floor(r2.x)\nMOV   r3.x, r3.y;\nEXP   r3.y, r2.y;                 # r2.y = r2.x - floor(r2.x)\nMAD   r2, r3, sinTaylorConst2.y, -sinTaylorConst2.z;  # r2 = (r3 * 2.0*PI) - M_PI\n\n# r4.x = sin(r2.x);\n# r4.y = cos(r2.y);\n# parallel taylor series\nMUL   r3,   r2, r2;\nMAD   r4, -r3, sinTaylorConst1.w, sinTaylorConst1.z;\nMAD   r4, r4, -r3, sinTaylorConst1.y;\nMAD   r4, r4, -r3, sinTaylorConst1.x;\nMUL   r4, r4, r2;\n\n# x    y    z    w\n# R:\n# 1    0    0    0\n# 0    c   -s    0\n# 0    s    c    0\n# 0    0    0    1\n\n# c = cos(a)\n# s = sin(a)\n\n# calculate rotation around X\nMOV   r1, r0;\n\nMUL   r1.y, r0.y, r4.y;\nMAD   r1.y, r0.z, -r4.x, r1.y;    # ny = y*cos(a) - z*sin(a)\n\nMUL   r1.z, r0.y, r4.x;\nMAD   r1.z, r0.z, r4.y, r1.z;     # nz = y*sin(a) + z*cos(a)\n\nDP4   oPos.x, mvp[0], r1;        # object x MVP -> clip\nDP4   oPos.y, mvp[1], r1;\nDP4   oPos.z, mvp[2], r1;\nDP4   oPos.w, mvp[3], r1;\n\n# rotate normal\nMOV   r2, iNorm;\nMUL   r2.y, iNorm.y, r4.y;\nMAD   r2.y, iNorm.z, -r4.x, r2.y;   # ny = y*cos(a) - z*sin(a)\n\nMUL   r2.z, iNorm.y, r4.x;\nMAD   r2.z, iNorm.z, r4.y, r2.z;    # nz = y*sin(a) + z*cos(a)\n\n# diffuse lighting\nDP3   r1.x, mvit[0], r2;             # normal x MV-1T -> lighting normal\nDP3   r1.y, mvit[1], r2;\nDP3   r1.z, mvit[2], r2;\n\nDP3   r3, lightPos, r1;              # light position DOT normal\nMUL   oCol0.xyz, r3, diffuseCol;     # col = ldotn * diffuse\n\nMOV   oTex0, iTex;\n\nEND\n"};

    public static void main(String[] stringArray) {
        new VertexProgWarp().run(stringArray);
    }

    public void run(String[] stringArray) {
        VertexProgWarp vertexProgWarp = new VertexProgWarp();
        GLCanvas gLCanvas = new GLCanvas();
        gLCanvas.addGLEventListener((GLEventListener)vertexProgWarp);
        gLCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                VertexProgWarp.this.dispatchKey(keyEvent.getKeyCode(), keyEvent.getKeyChar());
            }
        });
        final Animator animator = new Animator((GLAutoDrawable)gLCanvas);
        vertexProgWarp.setDemoListener(new DemoListener(){

            @Override
            public void shutdownDemo() {
                VertexProgWarp.runExit(animator);
            }

            @Override
            public void repaint() {
            }
        });
        final Frame frame = new Frame();
        vertexProgWarp.setTitleSetter(new TitleSetter(){

            @Override
            public void setTitle(String string) {
                frame.setTitle(string);
            }
        });
        frame.setLayout(new BorderLayout());
        gLCanvas.setSize(512, 512);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.setVisible(true);
        gLCanvas.requestFocus();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                VertexProgWarp.runExit(animator);
            }
        });
        animator.start();
    }

    public void setTitleSetter(TitleSetter titleSetter) {
        this.titleSetter = titleSetter;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        int n;
        this.initComplete = false;
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        float f = 0.0f;
        gL2.glClearColor(f, f, f, 1.0f);
        gL2.glColor3f(1.0f, 1.0f, 1.0f);
        gL2.glEnable(2929);
        gL2.glDisable(2884);
        try {
            this.initExtension(gL2, "GL_ARB_vertex_program");
        }
        catch (RuntimeException runtimeException) {
            this.shutdownDemo();
            throw runtimeException;
        }
        for (n = 0; n < 5; ++n) {
            gL2.glNewList(n + 1, 4864);
            this.drawObject(gL2, n);
            gL2.glEndList();
        }
        for (n = 0; n < 7; ++n) {
            int[] nArray = new int[1];
            gL2.glGenProgramsARB(1, nArray, 0);
            this.programs[n] = nArray[0];
            gL2.glBindProgramARB(34336, this.programs[n]);
            gL2.glProgramStringARB(34336, 34933, programTexts[n].length(), programTexts[n]);
        }
        gL2.glProgramEnvParameter4fARB(34336, 0, 0.0f, 0.0f, 1.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 1, 0.0f, 1.0f, 0.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 2, 1.0f, 1.0f, 1.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 3, 0.0f, 1.0f, 2.0f, 3.0f);
        gL2.glProgramEnvParameter4fARB(34336, 4, 1.0f, 0.16666667f, 0.008333334f, 1.984127E-4f);
        gL2.glProgramEnvParameter4fARB(34336, 5, 0.16239038f, 6.158f, 3.079f, 1.5395f);
        gL2.glProgramEnvParameter4fARB(34336, 6, 1.0f, 0.2f, 0.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 7, 0.0f, 0.0f, 0.0f, 0.0f);
        gL2.glProgramEnvParameter4fARB(34336, 8, 1.0f, 0.0f, 0.0f, 0.0f);
        this.setWindowTitle();
        this.doViewAll = true;
        this.b[112] = true;
        ManipManager manipManager = ManipManager.getManipManager();
        manipManager.registerWindow((AWTGLAutoDrawable)gLAutoDrawable);
        this.drawable = gLAutoDrawable;
        this.viewer = new ExaminerViewer();
        this.viewer.setUpVector(Vec3f.Y_AXIS);
        this.viewer.setNoAltKeyMode(true);
        this.viewer.setAutoRedrawMode(false);
        this.viewer.attach((AWTGLAutoDrawable)gLAutoDrawable, new BSphereProvider(){

            public BSphere getBoundingSphere() {
                return new BSphere(new Vec3f(0.0f, 0.0f, 0.0f), 1.0f);
            }
        });
        this.viewer.setVertFOV((float)Math.toRadians(60.0));
        this.viewer.setZNear(this.zNear);
        this.viewer.setZFar(this.zFar);
        this.initComplete = true;
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.initComplete) {
            return;
        }
        if (!this.firstRender) {
            if (++this.frameCount == 30) {
                this.timer.stop();
                System.err.println("Frames per second: " + 30.0f / this.timer.getDurationAsSeconds());
                this.timer.reset();
                this.timer.start();
                this.frameCount = 0;
            }
        } else {
            this.firstRender = false;
            this.timer.start();
        }
        this.time.update();
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16640);
        if (this.toggleWire) {
            boolean bl = this.wire = !this.wire;
            if (this.wire) {
                gL2.glPolygonMode(1032, 6913);
            } else {
                gL2.glPolygonMode(1032, 6914);
            }
            this.toggleWire = false;
        }
        gL2.glPushMatrix();
        if (this.doViewAll) {
            this.viewer.viewAll(gL2);
            this.doViewAll = false;
        }
        if (this.animating) {
            this.anim -= (float)((double)this.animScale * this.time.deltaT());
        }
        this.viewer.update(gL2);
        ManipManager.getManipManager().updateCameraParameters((AWTGLAutoDrawable)gLAutoDrawable, this.viewer.getCameraParameters());
        ManipManager.getManipManager().render((AWTGLAutoDrawable)gLAutoDrawable, gL2);
        gL2.glBindProgramARB(34336, this.programs[this.program]);
        gL2.glProgramEnvParameter4fARB(34336, 7, this.anim, 0.0f, 0.0f, 0.0f);
        if (this.program == 6) {
            gL2.glProgramEnvParameter4fARB(34336, 6, (float)Math.sin(this.anim) * this.amp * 50.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2.glProgramEnvParameter4fARB(34336, 6, this.freq, this.amp, this.d, this.d + 1.0f);
        }
        if (this.b[112]) {
            gL2.glEnable(34336);
        }
        gL2.glDisable(3553);
        gL2.glCallList(this.obj + 1);
        gL2.glDisable(34336);
        gL2.glPopMatrix();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    @Override
    public void shutdownDemo() {
        ManipManager.getManipManager().unregisterWindow((AWTGLAutoDrawable)this.drawable);
        this.drawable.removeGLEventListener((GLEventListener)this);
        super.shutdownDemo();
    }

    private void initExtension(GL2 gL2, String string) {
        if (!gL2.isExtensionAvailable(string)) {
            final String string2 = "OpenGL extension \"" + string + "\" not available";
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, string2, "Unavailable extension", 0);
                    VertexProgWarp.this.shutdownDemo();
                }
            }).start();
            throw new RuntimeException(string2);
        }
    }

    private void dispatchKey(int n, char c) {
        if (c < '\u0100') {
            this.b[c] = !this.b[c];
        }
        switch (n) {
            case 36: 
            case 82: {
                this.anim = 0.0f;
                this.amp = 0.05f;
                this.freq = 8.0f;
                this.d = 4.0f;
                this.doViewAll = true;
                break;
            }
            case 37: 
            case 226: {
                --this.program;
                if (this.program < 0) {
                    this.program = 6;
                }
                this.setWindowTitle();
                break;
            }
            case 39: 
            case 227: {
                this.program = (this.program + 1) % 7;
                this.setWindowTitle();
                break;
            }
            case 72: 
            case 112: {
                String string = System.getProperty("line.separator");
                string = string + string;
                String string2 = "F1/h - Help" + string + "Home - Reset" + string + "Left Button & Mouse - Rotate viewpoint" + string + "1..5 - Switch object (Sphere, Torus, Triceratop, Cube, Cylinder)" + string + "- / + - Change amplitude" + string + "[ / ] - Change frequency" + string + ", / . - Change square fisheye size" + string + "Left - Next vertex program" + string + "Right - Previous vertex program" + string + "W - Toggle wireframe" + string + "Space - Toggle animation" + string + "Esc/q - Exit program" + string;
                JOptionPane.showMessageDialog(null, string2, "Help", 1);
                break;
            }
            case 27: 
            case 81: {
                this.shutdownDemo();
                return;
            }
            case 87: {
                this.toggleWire = true;
                break;
            }
            case 61: 
            case 521: {
                this.amp = (float)((double)this.amp + 0.01);
                break;
            }
            case 45: {
                this.amp = (float)((double)this.amp - 0.01);
                break;
            }
            case 93: {
                this.freq = (float)((double)this.freq + 0.5);
                break;
            }
            case 91: {
                this.freq = (float)((double)this.freq - 0.5);
                break;
            }
            case 46: {
                this.d = (float)((double)this.d + 0.1);
                break;
            }
            case 44: {
                this.d = (float)((double)this.d - 0.1);
                break;
            }
            case 32: {
                this.animating = !this.animating;
                break;
            }
            case 49: {
                this.obj = 0;
                break;
            }
            case 50: {
                this.obj = 1;
                break;
            }
            case 51: {
                this.obj = 2;
                break;
            }
            case 52: {
                this.obj = 3;
                break;
            }
            case 53: {
                this.obj = 4;
            }
        }
    }

    private void setWindowTitle() {
        this.titleSetter.setTitle("SpaceWarp - " + programNames[this.program]);
    }

    private void drawObject(GL2 gL2, int n) {
        switch (n) {
            case 0: {
                this.drawSphere(gL2, 0.5f, 100, 100);
                break;
            }
            case 1: {
                this.drawTorus(gL2, 0.25f, 0.5f, 100, 100);
                break;
            }
            case 2: {
                try {
                    Triceratops.drawObject((GL2)gL2);
                    break;
                }
                catch (IOException iOException) {
                    this.shutdownDemo();
                    throw new RuntimeException(iOException);
                }
            }
            case 3: {
                this.drawCube(gL2);
                break;
            }
            case 4: {
                this.drawCylinder(gL2);
            }
        }
    }

    private void drawSphere(GL2 gL2, float f, int n, int n2) {
        int n3 = n2;
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            float f2 = (float)i / (float)n3;
            float f3 = (float)((double)(f2 * 2.0f) * Math.PI);
            float f4 = (float)(i + 1) / (float)n3;
            float f5 = (float)((double)(f4 * 2.0f) * Math.PI);
            gL2.glBegin(8);
            for (int j = 0; j < n4; ++j) {
                float f6 = (float)j / ((float)n4 - 1.0f);
                float f7 = (float)((double)f6 * Math.PI);
                float f8 = (float)(Math.cos(f7) * Math.cos(f3));
                float f9 = (float)(Math.sin(f7) * Math.cos(f3));
                float f10 = (float)Math.sin(f3);
                float f11 = f * f8;
                float f12 = f * f9;
                float f13 = f * f10;
                gL2.glColor3f(f6, f2, 0.0f);
                gL2.glNormal3f(f8, f9, f10);
                gL2.glVertex3f(f11, f12, f13);
                f8 = (float)(Math.cos(f7) * Math.cos(f5));
                f9 = (float)(Math.sin(f7) * Math.cos(f5));
                f10 = (float)Math.sin(f5);
                f11 = f * f8;
                f12 = f * f9;
                f13 = f * f10;
                gL2.glColor3f(f6, f2 + 1.0f / ((float)n3 - 1.0f), 0.0f);
                gL2.glNormal3f(f8, f9, f10);
                gL2.glVertex3f(f11, f12, f13);
            }
            gL2.glEnd();
        }
    }

    private void drawTorus(GL2 gL2, float f, float f2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        for (int i = 0; i < n3 - 1; ++i) {
            float f3 = (float)i / ((float)n3 - 1.0f);
            float f4 = (float)((double)(f3 * 2.0f) * Math.PI);
            float f5 = (float)(i + 1) / ((float)n3 - 1.0f);
            float f6 = (float)((double)(f5 * 2.0f) * Math.PI);
            gL2.glBegin(8);
            for (int j = 0; j < n4; ++j) {
                float f7 = (float)j / ((float)n4 - 1.0f);
                float f8 = (float)((double)(f7 * 2.0f) * Math.PI);
                float f9 = (float)((double)f2 * Math.cos(f8) + (double)f * Math.cos(f8) * Math.cos(f4));
                float f10 = (float)((double)f2 * Math.sin(f8) + (double)f * Math.sin(f8) * Math.cos(f4));
                float f11 = (float)((double)f * Math.sin(f4));
                float f12 = (float)(Math.cos(f8) * Math.cos(f4));
                float f13 = (float)(Math.sin(f8) * Math.cos(f4));
                float f14 = (float)Math.sin(f4);
                gL2.glColor3f(f7, f3, 0.0f);
                gL2.glNormal3f(f12, f13, f14);
                gL2.glVertex3f(f9, f10, f11);
                f9 = (float)((double)f2 * Math.cos(f8) + (double)f * Math.cos(f8) * Math.cos(f6));
                f10 = (float)((double)f2 * Math.sin(f8) + (double)f * Math.sin(f8) * Math.cos(f6));
                f11 = (float)((double)f * Math.sin(f6));
                f12 = (float)(Math.cos(f8) * Math.cos(f6));
                f13 = (float)(Math.sin(f8) * Math.cos(f6));
                f14 = (float)Math.sin(f6);
                gL2.glColor3f(f7, f3, 0.0f);
                gL2.glNormal3f(f12, f13, f14);
                gL2.glVertex3f(f9, f10, f11);
            }
            gL2.glEnd();
        }
    }

    private void drawCube(GL2 gL2) {
        int n = 40;
        float f = 0.5f;
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glNormal3f(0.0f, 0.0f, -1.0f);
        this.drawGrid(gL2, n, n, f, -1.0f, -1.0f, -1.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glNormal3f(0.0f, 0.0f, 1.0f);
        this.drawGrid(gL2, n, n, f, -1.0f, -1.0f, 1.0f, 2.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        gL2.glNormal3f(-1.0f, 0.0f, 0.0f);
        this.drawGrid(gL2, n, n, f, -1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        gL2.glNormal3f(1.0f, 0.0f, 0.0f);
        this.drawGrid(gL2, n, n, f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 2.0f, 0.0f);
        gL2.glColor3f(1.0f, 1.0f, 0.0f);
        gL2.glNormal3f(0.0f, -1.0f, 0.0f);
        this.drawGrid(gL2, n, n, f, -1.0f, -1.0f, -1.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
        gL2.glColor3f(0.0f, 1.0f, 1.0f);
        gL2.glNormal3f(0.0f, 1.0f, 0.0f);
        this.drawGrid(gL2, n, n, f, -1.0f, 1.0f, -1.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f);
    }

    private void drawGrid(GL2 gL2, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        for (int i = 0; i < n; ++i) {
            gL2.glBegin(8);
            for (int j = 0; j <= n2; ++j) {
                float f11 = (float)j / (float)n2;
                float f12 = (float)i / (float)n;
                float f13 = f12 + 1.0f / (float)n;
                gL2.glTexCoord2f(f11, f12);
                gL2.glVertex3f(f * (f2 + f11 * f5 + f12 * f8), f * (f3 + f11 * f6 + f12 * f9), f * (f4 + f11 * f7 + f12 * f10));
                gL2.glTexCoord2f(f11, f13);
                gL2.glVertex3f(f * (f2 + f11 * f5 + f13 * f8), f * (f3 + f11 * f6 + f13 * f9), f * (f4 + f11 * f7 + f13 * f10));
            }
            gL2.glEnd();
        }
    }

    private void drawCylinder(GL2 gL2) {
        GLUquadric gLUquadric = this.glu.gluNewQuadric();
        this.glu.gluQuadricDrawStyle(gLUquadric, 100012);
        this.glu.gluQuadricOrientation(gLUquadric, 100020);
        this.glu.gluQuadricNormals(gLUquadric, 100000);
        this.glu.gluQuadricTexture(gLUquadric, true);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glTranslatef(-1.0f, 0.0f, 0.0f);
        gL2.glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
        this.glu.gluCylinder(gLUquadric, 0.25, 0.25, 2.0, 60, 30);
        gL2.glPopMatrix();
        this.glu.gluDeleteQuadric(gLUquadric);
    }

    private static void runExit(final Animator animator) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                animator.stop();
                System.exit(0);
            }
        }).start();
    }

    public static abstract class TitleSetter {
        public abstract void setTitle(String var1);
    }
}

