/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import demos.xtrans.XTBasicTransitionManager;
import demos.xtrans.XTDesktopPane;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Random;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class Main {
    private XTDesktopPane desktop;
    private XTBasicTransitionManager transManager;
    private static final int TABLE = 1;
    private static final int TREE = 2;
    private Point loc = new Point();
    private boolean scrollingEnabled = true;
    private boolean rotationEnabled = true;
    private boolean fadesEnabled = true;
    private Random random;

    private void chooseNextTransition() {
        if (this.scrollingEnabled && this.rotationEnabled && this.fadesEnabled) {
            return;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        boolean bl = this.random.nextBoolean();
        if (!this.fadesEnabled) {
            bl = false;
        }
        XTBasicTransitionManager.Style style = XTBasicTransitionManager.STYLE_NO_MOTION;
        if (this.scrollingEnabled) {
            style = XTBasicTransitionManager.STYLE_SCROLL;
        } else if (this.rotationEnabled) {
            style = XTBasicTransitionManager.STYLE_ROTATE;
        }
        XTBasicTransitionManager.Direction direction = null;
        switch (this.random.nextInt(4)) {
            case 0: {
                direction = XTBasicTransitionManager.DIR_LEFT;
                break;
            }
            case 1: {
                direction = XTBasicTransitionManager.DIR_RIGHT;
                break;
            }
            case 2: {
                direction = XTBasicTransitionManager.DIR_UP;
                break;
            }
            default: {
                direction = XTBasicTransitionManager.DIR_DOWN;
            }
        }
        this.transManager.setNextTransition(style, direction, bl);
    }

    private void addWindow(int n) {
        JInternalFrame jInternalFrame = new JInternalFrame();
        jInternalFrame.setResizable(true);
        jInternalFrame.setClosable(true);
        jInternalFrame.setVisible(true);
        switch (n) {
            case 1: {
                jInternalFrame.setTitle("Table Example");
                Object[][] objectArray = this.produceTableData(3, 20);
                DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, new String[]{"A", "B", "C"});
                JTable jTable = new JTable(defaultTableModel);
                JScrollPane jScrollPane = new JScrollPane(jTable);
                jInternalFrame.getContentPane().add(jScrollPane);
                break;
            }
            case 2: {
                jInternalFrame.setTitle("Tree Example");
                Object[][] objectArray = new DefaultMutableTreeNode();
                this.populateTree((DefaultMutableTreeNode)objectArray, 2);
                JTree jTree = new JTree((TreeNode)objectArray);
                jTree.setRootVisible(false);
                jInternalFrame.getContentPane().add(jTree);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        jInternalFrame.setLocation(this.loc);
        this.loc = new Point((this.loc.x + 20) % this.desktop.getWidth(), (this.loc.y + 20) % this.desktop.getHeight());
        jInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                Main.this.chooseNextTransition();
            }
        });
        jInternalFrame.pack();
        int n2 = Math.min(this.desktop.getWidth() / 3, this.desktop.getHeight());
        jInternalFrame.setSize(n2, n2);
        this.chooseNextTransition();
        this.desktop.add(jInternalFrame);
        this.desktop.moveToFront(jInternalFrame);
    }

    private Object[][] produceTableData(int n, int n2) {
        Object[][] objectArray = new Object[n2][];
        Random random = new Random();
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray2 = new Object[n];
            for (int j = 0; j < n; ++j) {
                objectArray2[j] = random.nextInt(1000);
            }
            objectArray[i] = objectArray2;
        }
        return objectArray;
    }

    private void populateTree(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("A"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("B"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("C"));
        if (n > 0) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.populateTree((DefaultMutableTreeNode)enumeration.nextElement(), n - 1);
            }
        }
    }

    private void run(String[] stringArray) {
        JFrame jFrame = new JFrame("Desktop Demo");
        JMenu jMenu = new JMenu("Actions");
        JMenuBar jMenuBar = new JMenuBar();
        JMenuItem jMenuItem = new JMenuItem("Add Table");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addWindow(1);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Add Tree");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.addWindow(2);
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close all");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray = Main.this.desktop.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    Main.this.chooseNextTransition();
                    Main.this.desktop.remove(componentArray[i]);
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Enable Scrolling");
        jCheckBoxMenuItem.setState(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.scrollingEnabled = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Enable Rotation");
        jCheckBoxMenuItem.setState(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.rotationEnabled = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem = new JCheckBoxMenuItem("Enable Fades");
        jCheckBoxMenuItem.setState(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.fadesEnabled = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        jMenuBar.add(jMenu);
        jFrame.setJMenuBar(jMenuBar);
        this.desktop = new XTDesktopPane();
        this.transManager = (XTBasicTransitionManager)this.desktop.getTransitionManager();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(this.desktop);
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        int n = (int)((float)displayMode.getWidth() * 0.75f);
        int n2 = (int)((float)n * 3.0f / 4.0f);
        if ((float)n2 >= 95.0f * (float)displayMode.getHeight()) {
            n2 = (int)((float)displayMode.getHeight() * 0.75f);
            n = (int)((float)n2 * 4.0f / 3.0f);
        }
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        new Main().run(stringArray);
    }
}

