/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import demos.xtrans.OffscreenDesktopManager;
import demos.xtrans.OffscreenDesktopPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import jogamp.opengl.Debug;
import jogamp.opengl.awt.Java2D;

public class OffscreenComponentWrapper
extends JComponent {
    private static final boolean DEBUG = Debug.debug((String)"OffscreenComponentWrapper");

    public OffscreenComponentWrapper(Component component) {
        if (component == null) {
            throw new RuntimeException("Null argument");
        }
        this.add(component);
        this.setOpaque(false);
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() != 0) {
            throw new RuntimeException("May only add one child");
        }
        super.addImpl(component, object, n);
    }

    public Component getChild() {
        if (this.getComponentCount() == 0) {
            throw new RuntimeException("No child found");
        }
        return this.getComponent(0);
    }

    @Override
    public void remove(int n) {
        super.remove(n);
        throw new RuntimeException("Should not call this");
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        throw new RuntimeException("Should not call this");
    }

    @Override
    public Graphics getGraphics() {
        Container container = this.getParent();
        if (container != null && container instanceof OffscreenDesktopPane) {
            OffscreenDesktopPane offscreenDesktopPane = (OffscreenDesktopPane)container;
            OffscreenDesktopManager offscreenDesktopManager = (OffscreenDesktopManager)offscreenDesktopPane.getDesktopManager();
            Graphics graphics = offscreenDesktopManager.getOffscreenGraphics();
            Rectangle rectangle = offscreenDesktopManager.getBoundsOnBackBuffer(this.getChild());
            if (rectangle == null) {
                if (DEBUG) {
                    System.err.println("No bounds for child");
                }
                return graphics;
            }
            if (DEBUG) {
                System.err.println("Graphics.translate(" + rectangle.x + "," + rectangle.y + ")");
                System.err.println("  Surface identifier = " + Java2D.getOGLSurfaceIdentifier((Graphics)graphics));
            }
            graphics.translate(rectangle.x, rectangle.y);
            Component component = this.getChild();
            graphics.translate(-component.getX(), -component.getY());
            OffscreenDesktopManager.switchDoubleBuffering(this, false);
            offscreenDesktopManager.setNeedsRedraw();
            offscreenDesktopPane.repaint();
            return graphics;
        }
        return super.getGraphics();
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    @Override
    protected void paintChildren(Graphics graphics) {
    }
}

