/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import demos.xtrans.OffscreenComponentWrapper;
import demos.xtrans.OffscreenDesktopManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JDesktopPane;
import jogamp.opengl.Debug;

public class OffscreenDesktopPane
extends JDesktopPane {
    private static final boolean DEBUG = Debug.debug((String)"OffscreenDesktopPane");
    private static final Color[] colors = new Color[]{Color.LIGHT_GRAY, Color.CYAN, Color.PINK, Color.GRAY, Color.MAGENTA, Color.BLUE, Color.ORANGE, Color.DARK_GRAY, Color.RED, Color.YELLOW};
    private int colorIdx;
    private Map componentColorMap;

    private Color getNextColor() {
        Color color = colors[this.colorIdx];
        this.colorIdx = (this.colorIdx + 1) % colors.length;
        return color;
    }

    public OffscreenDesktopPane() {
        if (DEBUG) {
            this.componentColorMap = new WeakHashMap();
        }
        if (this.getClass() == OffscreenDesktopPane.class) {
            this.setDesktopManager(new OffscreenDesktopManager());
        }
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof OffscreenComponentWrapper) {
            throw new RuntimeException("Should not add OffscreenComponentWrappers directly");
        }
        OffscreenComponentWrapper offscreenComponentWrapper = new OffscreenComponentWrapper(component);
        offscreenComponentWrapper.setBounds(this.getBounds());
        OffscreenDesktopManager.switchDoubleBuffering(offscreenComponentWrapper, false);
        super.addImpl(offscreenComponentWrapper, object, n);
        if (DEBUG) {
            this.componentColorMap.put(component, this.getNextColor());
        }
        this.getOffscreenDesktopManager().setNeedsReLayout();
        this.repaint();
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        OffscreenDesktopManager.switchDoubleBuffering(component, true);
    }

    @Override
    public void remove(Component component) {
        if ((component = OffscreenDesktopPane.getWrapper(component)) == null) {
            return;
        }
        super.remove(component);
        OffscreenDesktopManager.switchDoubleBuffering(component, true);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((OffscreenComponentWrapper)componentArray[i]).setBounds(rectangle);
        }
    }

    @Override
    public void setPosition(Component component, int n) {
        super.setPosition(OffscreenDesktopPane.getWrapper(component), n);
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        this.getOffscreenDesktopManager().updateOffscreenBuffer(this);
        if (DEBUG) {
            Component[] componentArray = this.getRealChildComponents();
            int n = componentArray.length;
            for (int i = n - 1; i >= 0; --i) {
                Component component = componentArray[i];
                Rectangle rectangle = component.getBounds();
                Color color = (Color)this.componentColorMap.get(component);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    protected Component[] getRealChildComponents() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i] = ((OffscreenComponentWrapper)componentArray[i]).getChild();
        }
        return componentArray;
    }

    public OffscreenDesktopManager getOffscreenDesktopManager() {
        return (OffscreenDesktopManager)this.getDesktopManager();
    }

    protected static Component getRealComponent(Component component) {
        if (component instanceof OffscreenComponentWrapper) {
            return ((OffscreenComponentWrapper)component).getChild();
        }
        return component;
    }

    protected static Component getWrapper(Component component) {
        if (component instanceof OffscreenComponentWrapper) {
            return component;
        }
        Container container = component.getParent();
        if (container instanceof OffscreenComponentWrapper) {
            return container;
        }
        return null;
    }
}

