/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import com.jogamp.opengl.GL2;
import demos.xtrans.InterpolatedFloat;
import demos.xtrans.InterpolatedQuad2f;
import demos.xtrans.InterpolatedQuad3f;
import demos.xtrans.InterpolatedVec3f;
import demos.xtrans.Quad2f;
import demos.xtrans.Quad3f;
import demos.xtrans.XTTransition;
import gleem.linalg.Vec3f;

public class XTBasicTransition
implements XTTransition {
    protected Vec3f pivot = new Vec3f();
    protected Vec3f axis = new Vec3f();
    protected InterpolatedFloat angle;
    protected InterpolatedVec3f translation;
    protected InterpolatedQuad3f vertices;
    protected InterpolatedQuad2f texcoords;
    protected InterpolatedFloat alpha;
    protected float percentage;

    @Override
    public void update(float f) {
        this.percentage = f;
    }

    @Override
    public void draw(GL2 gL2) {
        float f = this.percentage;
        Quad3f quad3f = this.vertices.getCurrent(f);
        Quad2f quad2f = this.texcoords.getCurrent(f);
        if (this.translation != null) {
            Vec3f vec3f = this.translation.getCurrent(f);
            gL2.glTranslatef(vec3f.x(), vec3f.y(), vec3f.z());
        }
        gL2.glTranslatef(this.pivot.x(), this.pivot.y(), this.pivot.z());
        if (this.angle != null) {
            gL2.glRotatef(this.angle.getCurrent(f), this.axis.x(), this.axis.y(), this.axis.z());
        }
        gL2.glTranslatef(-this.pivot.x(), -this.pivot.y(), -this.pivot.z());
        gL2.glBegin(4);
        float f2 = 1.0f;
        if (this.alpha != null) {
            f2 = this.alpha.getCurrent(f);
        }
        gL2.glColor4f(1.0f, 1.0f, 1.0f, f2);
        gL2.glTexCoord2f(quad2f.getVec(0).x(), quad2f.getVec(0).y());
        gL2.glVertex3f(quad3f.getVec(0).x(), quad3f.getVec(0).y(), quad3f.getVec(0).z());
        gL2.glTexCoord2f(quad2f.getVec(1).x(), quad2f.getVec(1).y());
        gL2.glVertex3f(quad3f.getVec(1).x(), quad3f.getVec(1).y(), quad3f.getVec(1).z());
        gL2.glTexCoord2f(quad2f.getVec(3).x(), quad2f.getVec(3).y());
        gL2.glVertex3f(quad3f.getVec(3).x(), quad3f.getVec(3).y(), quad3f.getVec(3).z());
        gL2.glTexCoord2f(quad2f.getVec(3).x(), quad2f.getVec(3).y());
        gL2.glVertex3f(quad3f.getVec(3).x(), quad3f.getVec(3).y(), quad3f.getVec(3).z());
        gL2.glTexCoord2f(quad2f.getVec(1).x(), quad2f.getVec(1).y());
        gL2.glVertex3f(quad3f.getVec(1).x(), quad3f.getVec(1).y(), quad3f.getVec(1).z());
        gL2.glTexCoord2f(quad2f.getVec(2).x(), quad2f.getVec(2).y());
        gL2.glVertex3f(quad3f.getVec(2).x(), quad3f.getVec(2).y(), quad3f.getVec(2).z());
        gL2.glEnd();
    }

    public Vec3f getRotationAxis() {
        return this.axis;
    }

    public void setRotationAxis(Vec3f vec3f) {
        this.axis.set(vec3f);
    }

    public InterpolatedFloat getRotationAngle() {
        return this.angle;
    }

    public void setRotationAngle(InterpolatedFloat interpolatedFloat) {
        this.angle = interpolatedFloat;
    }

    public Vec3f getPivotPoint() {
        return this.pivot;
    }

    public void setPivotPoint(Vec3f vec3f) {
        this.pivot.set(vec3f);
    }

    public InterpolatedVec3f getTranslation() {
        return this.translation;
    }

    public void setTranslation(InterpolatedVec3f interpolatedVec3f) {
        this.translation = interpolatedVec3f;
    }

    public InterpolatedQuad3f getVertices() {
        return this.vertices;
    }

    public void setVertices(InterpolatedQuad3f interpolatedQuad3f) {
        this.vertices = interpolatedQuad3f;
    }

    public InterpolatedQuad2f getTexCoords() {
        return this.texcoords;
    }

    public void setTexCoords(InterpolatedQuad2f interpolatedQuad2f) {
        this.texcoords = interpolatedQuad2f;
    }

    public InterpolatedFloat getAlpha() {
        return this.alpha;
    }

    public void setAlpha(InterpolatedFloat interpolatedFloat) {
        this.alpha = interpolatedFloat;
    }
}

