/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import demos.xtrans.OffscreenDesktopManager;
import demos.xtrans.OffscreenDesktopPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JDesktopPane;
import jogamp.opengl.awt.Java2D;

public class XTDesktopManager
extends OffscreenDesktopManager {
    private GLContext j2dContext;
    private Object j2dContextSurfaceIdentifier;
    private int oglTextureId;
    private int prevBackBufferWidth;
    private int prevBackBufferHeight;
    private int textureTarget = 3553;

    public int getOpenGLTextureObject() {
        return this.oglTextureId;
    }

    public Rectangle2D getOpenGLTextureCoords(Component component) {
        Rectangle rectangle = this.getBoundsOnBackBuffer(component);
        if (rectangle == null) {
            throw new RuntimeException("Unknown component " + component);
        }
        double d = this.getOffscreenBackBufferWidth();
        double d2 = this.getOffscreenBackBufferHeight();
        return new Rectangle2D.Double((double)rectangle.x / d, (d2 - (double)rectangle.y - (double)rectangle.height) / d2, (double)rectangle.width / d, (double)rectangle.height / d2);
    }

    @Override
    public void updateOffscreenBuffer(OffscreenDesktopPane offscreenDesktopPane) {
        boolean bl;
        boolean bl2 = this.needsCopyBack();
        boolean bl3 = false;
        super.updateOffscreenBuffer(offscreenDesktopPane);
        Image image2 = this.getOffscreenBackBuffer();
        boolean bl4 = bl = this.oglTextureId == 0 || image2 == null || this.prevBackBufferWidth != image2.getWidth(null) || this.prevBackBufferHeight != image2.getHeight(null);
        if (bl2) {
            final Graphics graphics = this.getOffscreenGraphics();
            Java2D.invokeWithOGLContextCurrent((Graphics)graphics, (Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GLProfile gLProfile;
                    if (XTDesktopManager.this.j2dContext == null || XTDesktopManager.this.j2dContextSurfaceIdentifier != Java2D.getOGLSurfaceIdentifier((Graphics)graphics)) {
                        gLProfile = GLProfile.getDefault();
                        XTDesktopManager.this.j2dContext = GLDrawableFactory.getFactory((GLProfile)gLProfile).createExternalGLContext();
                        XTDesktopManager.this.j2dContext.setGL((GL)new DebugGL2(XTDesktopManager.this.j2dContext.getGL().getGL2()));
                        XTDesktopManager.this.j2dContextSurfaceIdentifier = Java2D.getOGLSurfaceIdentifier((Graphics)graphics);
                    }
                    XTDesktopManager.this.j2dContext.makeCurrent();
                    try {
                        gLProfile = XTDesktopManager.this.j2dContext.getGL().getGL2();
                        if (XTDesktopManager.this.oglTextureId == 0) {
                            int[] nArray = new int[1];
                            gLProfile.glGenTextures(1, nArray, 0);
                            XTDesktopManager.this.oglTextureId = nArray[0];
                            if (XTDesktopManager.this.oglTextureId == 0) {
                                throw new RuntimeException("Error generating OpenGL back buffer texture");
                            }
                            assert (bl) : "Must know we need to resize";
                        }
                        gLProfile.glBindTexture(XTDesktopManager.this.textureTarget, XTDesktopManager.this.oglTextureId);
                        int n = XTDesktopManager.this.getOffscreenBackBufferWidth();
                        int n2 = XTDesktopManager.this.getOffscreenBackBufferHeight();
                        if (bl) {
                            XTDesktopManager.this.prevBackBufferWidth = n;
                            XTDesktopManager.this.prevBackBufferHeight = n2;
                            gLProfile.glTexImage2D(XTDesktopManager.this.textureTarget, 0, 32856, n, n2, 0, 6408, 5121, null);
                        }
                        gLProfile.glPixelStorei(3312, 0);
                        gLProfile.glPixelStorei(3328, 0);
                        gLProfile.glPixelStorei(3313, 0);
                        gLProfile.glPixelStorei(3329, 0);
                        gLProfile.glPixelStorei(3314, 0);
                        gLProfile.glPixelStorei(3330, 0);
                        gLProfile.glPixelStorei(3315, 0);
                        gLProfile.glPixelStorei(3331, 0);
                        gLProfile.glPixelStorei(3316, 0);
                        gLProfile.glPixelStorei(3332, 0);
                        gLProfile.glPixelStorei(3317, 1);
                        gLProfile.glPixelStorei(3333, 1);
                        gLProfile.glPixelTransferf(3348, 1.0f);
                        gLProfile.glPixelTransferf(3352, 1.0f);
                        gLProfile.glPixelTransferf(3354, 1.0f);
                        gLProfile.glPixelTransferf(3356, 1.0f);
                        gLProfile.glPixelTransferf(3349, 0.0f);
                        gLProfile.glPixelTransferf(3353, 0.0f);
                        gLProfile.glPixelTransferf(3355, 0.0f);
                        gLProfile.glPixelTransferf(3357, 0.0f);
                        gLProfile.glCopyTexSubImage2D(XTDesktopManager.this.textureTarget, 0, 0, 0, 0, 0, n, n2);
                    }
                    finally {
                        XTDesktopManager.this.j2dContext.release();
                    }
                }
            });
        }
    }

    @Override
    protected void repaintPortionOfDesktop(JDesktopPane jDesktopPane, Component component) {
        jDesktopPane.repaint();
    }
}

