/*
 * Decompiled with CFR 0.152.
 */
package demos.xtrans;

import com.jogamp.opengl.DebugGL2;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import demos.xtrans.OffscreenDesktopPane;
import demos.xtrans.XTBasicTransitionManager;
import demos.xtrans.XTDesktopManager;
import demos.xtrans.XTTransition;
import demos.xtrans.XTTransitionManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import jogamp.opengl.awt.Java2D;

public class XTDesktopPane
extends OffscreenDesktopPane {
    private GLContext j2dContext;
    private Object j2dContextSurfaceIdentifier;
    private Rectangle oglViewport;
    private XTTransitionManager transitionManager = new XTBasicTransitionManager();
    private boolean reallyRemove;
    private boolean alwaysRedraw;
    private List transitions = new ArrayList();
    private float TRANSITION_DURATION = 300.0f;
    private int textureTarget = 3553;
    private GLU glu = new GLU();
    private GLProfile glProfile = GLProfile.getDefault();

    public XTDesktopPane() {
        if (!Java2D.isOGLPipelineActive()) {
            throw new RuntimeException("XTDesktopPane requires new Java2D/JOGL support in Java SE 6 and -Dsun.java2d.opengl=true");
        }
        this.setDesktopManager(new XTDesktopManager());
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this.getOffscreenDesktopManager().layoutOffscreenBuffer(this);
        this.addTransition(true, component, this.transitionManager.createTransitionForComponent(component, true, this.getOGLViewport(), this.computeViewportOffsetToCenterComponent(component, this.getOGLViewport()), this.getXTDesktopManager().getOpenGLTextureCoords(component)));
    }

    @Override
    public void remove(int n) {
        if (this.reallyRemove) {
            super.remove(n);
        } else {
            this.addRemoveTransition(XTDesktopPane.getRealComponent(this.getComponent(n)));
        }
    }

    @Override
    public void remove(Component component) {
        if (this.reallyRemove) {
            super.remove(component);
        } else {
            this.addRemoveTransition(XTDesktopPane.getRealComponent(component));
        }
    }

    protected void removeImpl(Component component) {
        this.reallyRemove = true;
        try {
            this.remove(component);
        }
        finally {
            this.reallyRemove = false;
        }
    }

    @Override
    protected void paintChildren(final Graphics graphics) {
        if (this.alwaysRedraw) {
            this.getOffscreenDesktopManager().setNeedsRedraw();
        }
        this.getOffscreenDesktopManager().updateOffscreenBuffer(this);
        final Component[] componentArray = this.getRealChildComponents();
        final ArrayList arrayList = new ArrayList();
        Java2D.invokeWithOGLContextCurrent((Graphics)graphics, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (XTDesktopPane.this.j2dContext == null || XTDesktopPane.this.j2dContextSurfaceIdentifier != Java2D.getOGLSurfaceIdentifier((Graphics)graphics)) {
                    XTDesktopPane.this.j2dContext = GLDrawableFactory.getFactory((GLProfile)XTDesktopPane.this.glProfile).createExternalGLContext();
                    XTDesktopPane.this.j2dContext.setGL((GL)new DebugGL2(XTDesktopPane.this.j2dContext.getGL().getGL2()));
                    XTDesktopPane.this.j2dContextSurfaceIdentifier = Java2D.getOGLSurfaceIdentifier((Graphics)graphics);
                }
                XTDesktopPane.this.j2dContext.makeCurrent();
                try {
                    GL2 gL2 = XTDesktopPane.this.j2dContext.getGL().getGL2();
                    Rectangle rectangle = Java2D.getOGLViewport((Graphics)graphics, (int)XTDesktopPane.this.getWidth(), (int)XTDesktopPane.this.getHeight());
                    XTDesktopPane.this.oglViewport = new Rectangle(rectangle);
                    double d = 30.0;
                    double d2 = rectangle.getWidth();
                    double d3 = rectangle.getHeight();
                    double d4 = d3 / 2.0 / Math.tan(Math.toRadians(d) / 2.0);
                    double d5 = d4 - d3 / 2.0;
                    double d6 = d4 + d3 / 2.0;
                    gL2.glViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    gL2.glMatrixMode(5889);
                    gL2.glPushMatrix();
                    gL2.glLoadIdentity();
                    XTDesktopPane.this.glu.gluPerspective(d, d2 / d3, d5, d6);
                    gL2.glMatrixMode(5890);
                    gL2.glPushMatrix();
                    gL2.glLoadIdentity();
                    gL2.glMatrixMode(5888);
                    gL2.glPushMatrix();
                    gL2.glLoadIdentity();
                    double d7 = d2 / 2.0;
                    double d8 = d3 / 2.0;
                    XTDesktopPane.this.glu.gluLookAt(d7, d8, d4, d7, d8, 0.0, 0.0, 1.0, 0.0);
                    gL2.glEnable(3089);
                    Rectangle rectangle2 = Java2D.getOGLScissorBox((Graphics)graphics);
                    if (rectangle2 != null) {
                        gL2.glScissor(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    gL2.glBindTexture(XTDesktopPane.this.textureTarget, XTDesktopPane.this.getXTDesktopManager().getOpenGLTextureObject());
                    gL2.glEnable(XTDesktopPane.this.textureTarget);
                    gL2.glTexParameteri(XTDesktopPane.this.textureTarget, 10242, 10496);
                    gL2.glTexParameteri(XTDesktopPane.this.textureTarget, 10243, 10496);
                    gL2.glTexParameteri(XTDesktopPane.this.textureTarget, 10240, 9729);
                    gL2.glTexParameteri(XTDesktopPane.this.textureTarget, 10241, 9729);
                    gL2.glEnable(3042);
                    gL2.glTexEnvi(8960, 8704, 8448);
                    gL2.glBlendFunc(770, 771);
                    int n = componentArray.length;
                    long l = XTDesktopPane.currentTimeMillis();
                    for (int i = n - 1; i >= 0; --i) {
                        Cloneable cloneable;
                        Component component = componentArray[i];
                        TransitionInfo transitionInfo = XTDesktopPane.this.transitionForComponent(component);
                        if (transitionInfo != null) {
                            gL2.glPushMatrix();
                            cloneable = XTDesktopPane.this.computeViewportOffsetToCenterComponent(component, XTDesktopPane.this.getOGLViewport());
                            gL2.glViewport(rectangle.x + ((Point)cloneable).x, rectangle.y + ((Point)cloneable).y, rectangle.width, rectangle.height);
                            float f = XTDesktopPane.clamp((float)(l - transitionInfo.startTime) / XTDesktopPane.this.TRANSITION_DURATION, 0.0f, 1.0f);
                            XTTransition xTTransition = transitionInfo.trans;
                            xTTransition.update(f);
                            xTTransition.draw(gL2);
                            if (f == 1.0f) {
                                XTDesktopPane.this.transitions.remove(transitionInfo);
                                arrayList.add(transitionInfo);
                            }
                            gL2.glPopMatrix();
                            gL2.glViewport(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            continue;
                        }
                        cloneable = XTDesktopPane.this.getXTDesktopManager().getOpenGLTextureCoords(component);
                        Rectangle rectangle3 = component.getBounds();
                        int n2 = rectangle3.x;
                        int n3 = rectangle3.y;
                        int n4 = rectangle3.width;
                        int n5 = rectangle3.height;
                        float f = (float)((RectangularShape)cloneable).getX();
                        float f2 = (float)((RectangularShape)cloneable).getY();
                        float f3 = (float)((RectangularShape)cloneable).getWidth();
                        float f4 = (float)((RectangularShape)cloneable).getHeight();
                        float f5 = rectangle.x;
                        float f6 = rectangle.y;
                        float f7 = rectangle.width;
                        float f8 = rectangle.height;
                        gL2.glBegin(4);
                        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                        gL2.glTexCoord2f(f, f2 + f4);
                        gL2.glVertex3f((float)n2, f8 - (float)n3, 0.0f);
                        gL2.glTexCoord2f(f, f2);
                        gL2.glVertex3f((float)n2, f8 - (float)n3 - (float)n5, 0.0f);
                        gL2.glTexCoord2f(f + f3, f2 + f4);
                        gL2.glVertex3f((float)(n2 + n4), f8 - (float)n3, 0.0f);
                        gL2.glTexCoord2f(f + f3, f2 + f4);
                        gL2.glVertex3f((float)(n2 + n4), f8 - (float)n3, 0.0f);
                        gL2.glTexCoord2f(f, f2);
                        gL2.glVertex3f((float)n2, f8 - (float)n3 - (float)n5, 0.0f);
                        gL2.glTexCoord2f(f + f3, f2);
                        gL2.glVertex3f((float)(n2 + n4), f8 - (float)n3 - (float)n5, 0.0f);
                        gL2.glEnd();
                    }
                    gL2.glFlush();
                    gL2.glDisable(XTDesktopPane.this.textureTarget);
                    gL2.glDisable(3042);
                    gL2.glTexEnvi(8960, 8704, 8448);
                    gL2.glMatrixMode(5889);
                    gL2.glPopMatrix();
                    gL2.glMatrixMode(5890);
                    gL2.glPopMatrix();
                    gL2.glMatrixMode(5888);
                    gL2.glPopMatrix();
                    gL2.glFinish();
                }
                finally {
                    XTDesktopPane.this.j2dContext.release();
                }
            }
        });
        for (TransitionInfo transitionInfo : arrayList) {
            if (transitionInfo.isIn) continue;
            this.removeImpl(transitionInfo.target);
            this.repaint();
        }
        if (!this.transitions.isEmpty()) {
            this.repaint();
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public XTDesktopManager getXTDesktopManager() {
        return (XTDesktopManager)this.getDesktopManager();
    }

    public XTTransitionManager getTransitionManager() {
        return this.transitionManager;
    }

    public void setTransitionManager(XTTransitionManager xTTransitionManager) {
        this.transitionManager = xTTransitionManager;
    }

    public void setAlwaysRedraw(boolean bl) {
        this.alwaysRedraw = bl;
    }

    public boolean getAlwaysRedraw() {
        return this.alwaysRedraw;
    }

    private TransitionInfo transitionForComponent(Component component) {
        for (TransitionInfo transitionInfo : this.transitions) {
            if (transitionInfo.target != component) continue;
            return transitionInfo;
        }
        return null;
    }

    protected void addTransition(boolean bl, Component component, XTTransition xTTransition) {
        TransitionInfo transitionInfo = new TransitionInfo(bl, component, XTDesktopPane.currentTimeMillis(), xTTransition);
        this.transitions.add(transitionInfo);
    }

    protected void addRemoveTransition(Component component) {
        this.addTransition(false, component, this.transitionManager.createTransitionForComponent(component, false, this.getOGLViewport(), this.computeViewportOffsetToCenterComponent(component, this.getOGLViewport()), this.getXTDesktopManager().getOpenGLTextureCoords(component)));
    }

    protected Point computeViewportOffsetToCenterComponent(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = component.getBounds();
        return new Point(rectangle2.x + (rectangle2.width - rectangle.width) / 2, -rectangle2.y + (rectangle.height - rectangle2.height) / 2);
    }

    protected static float clamp(float f, float f2, float f3) {
        return Math.min(f3, Math.max(f2, f));
    }

    protected static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected Rectangle getOGLViewport() {
        if (this.oglViewport != null) {
            return this.oglViewport;
        }
        Rectangle rectangle = this.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    static class TransitionInfo {
        boolean isIn;
        Component target;
        long startTime;
        XTTransition trans;

        TransitionInfo(boolean bl, Component component, long l, XTTransition xTTransition) {
            this.isIn = bl;
            this.target = component;
            this.startTime = l;
            this.trans = xTTransition;
        }
    }
}

