/*
 * Decompiled with CFR 0.152.
 */
package glredbook;

import glredbook10.GLSkeleton;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class JOGLApplet
extends JApplet {
    private GLSkeleton<?> skeleton;

    @Override
    public void start() {
        String string = this.getParameter("demo");
        this.loadDemo(string);
    }

    @Override
    public void stop() {
        if (this.skeleton != null) {
            this.skeleton.runExit();
        }
    }

    public void loadDemo(String string) {
        if (this.skeleton != null) {
            this.skeleton.runExit();
            SwingUtilities.invokeLater(new Runnable(){
                final Component drawable;
                {
                    this.drawable = (Component)((JOGLApplet)JOGLApplet.this).skeleton.drawable;
                }

                @Override
                public void run() {
                    JOGLApplet.this.remove(this.drawable);
                }
            });
        }
        this.log().info("i'll try to instantiate: " + string);
        try {
            Class<?> clazz = Class.forName(string);
            try {
                this.skeleton = (GLSkeleton)clazz.newInstance();
                System.out.println(this.skeleton);
                SwingUtilities.invokeLater(new Runnable(){
                    final GLSkeleton<?> s;
                    {
                        this.s = JOGLApplet.this.skeleton;
                    }

                    @Override
                    public void run() {
                        if (JOGLApplet.this.skeleton == this.s) {
                            JOGLApplet.this.add((Component)this.s.drawable);
                            System.out.println("added");
                            JOGLApplet.this.validate();
                        }
                    }
                });
            }
            catch (InstantiationException instantiationException) {
                this.log().log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log().log(Level.SEVERE, null, illegalAccessException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log().log(Level.SEVERE, "can't find main class", classNotFoundException);
        }
    }

    private Logger log() {
        return Logger.getLogger(JOGLApplet.class.getName());
    }
}

