/*
 * Decompiled with CFR 0.152.
 */
package glredbook10;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.GLBuffers;
import glredbook10.GLSkeleton;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.nio.IntBuffer;
import javax.swing.JFrame;

public class picksquare
extends GLSkeleton<GLJPanel>
implements GLEventListener,
KeyListener,
MouseListener {
    private GLU glu;
    private int[][] board = new int[3][3];
    private static final int BUFSIZE = 512;
    private Point pickPoint;

    @Override
    protected GLJPanel createDrawable() {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        gLJPanel.addGLEventListener((GLEventListener)this);
        gLJPanel.addKeyListener((KeyListener)this);
        gLJPanel.addMouseListener((MouseListener)this);
        return gLJPanel;
    }

    public static void main(String[] stringArray) {
        picksquare picksquare2 = new picksquare();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("picksquare");
        jFrame.setSize(512, 256);
        jFrame.setLocationRelativeTo(null);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add((Component)picksquare2.drawable);
        jFrame.setVisible(true);
        ((GLJPanel)picksquare2.drawable).requestFocusInWindow();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.glu = new GLU();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.board[i][j] = 0;
            }
        }
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16384);
        if (this.pickPoint != null) {
            this.pickSquares(gL2);
        }
        this.drawSquares(gL2, 7168);
        gL2.glFlush();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glViewport(0, 0, n3, n4);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        this.glu.gluOrtho2D(0.0, 3.0, 0.0, 3.0);
        gL2.glMatrixMode(5888);
        gL2.glLoadIdentity();
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private void drawSquares(GL2 gL2, int n) {
        for (int i = 0; i < 3; ++i) {
            if (n == 7170) {
                gL2.glLoadName(i);
            }
            for (int j = 0; j < 3; ++j) {
                if (n == 7170) {
                    gL2.glPushName(j);
                }
                gL2.glColor3f((float)i / 3.0f, (float)j / 3.0f, (float)this.board[i][j] / 3.0f);
                gL2.glRecti(i, j, i + 1, j + 1);
                if (n != 7170) continue;
                gL2.glPopName();
            }
        }
    }

    private void processHits(int n, int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        System.out.println("hits =  " + n);
        for (int i = 0; i < n; ++i) {
            int n5 = nArray[n4];
            System.out.println(" number of names for this hit = " + n5);
            System.out.println("  z1 is  " + (float)nArray[++n4] / 2.1474836E9f);
            System.out.println(" z2 is " + (float)nArray[++n4] / 2.1474836E9f);
            ++n4;
            System.out.println("   names are ");
            for (int j = 0; j < n5; ++j) {
                System.out.println("" + nArray[n4]);
                if (j == 0) {
                    n2 = nArray[n4];
                } else if (j == 1) {
                    n3 = nArray[n4];
                }
                ++n4;
            }
            System.out.println("\n");
            this.board[n2][n3] = (this.board[n2][n3] + 1) % 3;
        }
    }

    private void pickSquares(GL2 gL2) {
        int[] nArray = new int[512];
        IntBuffer intBuffer = GLBuffers.newDirectIntBuffer((int)512);
        int[] nArray2 = new int[4];
        gL2.glGetIntegerv(2978, nArray2, 0);
        gL2.glSelectBuffer(512, intBuffer);
        gL2.glRenderMode(7170);
        gL2.glInitNames();
        gL2.glPushName(0);
        gL2.glMatrixMode(5889);
        gL2.glPushMatrix();
        gL2.glLoadIdentity();
        this.glu.gluPickMatrix((double)this.pickPoint.x, (double)(nArray2[3] - this.pickPoint.y), 5.0, 5.0, nArray2, 0);
        this.glu.gluOrtho2D(0.0, 3.0, 0.0, 3.0);
        this.drawSquares(gL2, 7170);
        gL2.glMatrixMode(5889);
        gL2.glPopMatrix();
        gL2.glFlush();
        int n = gL2.glRenderMode(7168);
        intBuffer.get(nArray);
        this.processHits(n, nArray);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyChar()) {
            case '\u001b': {
                System.exit(0);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.pickPoint = mouseEvent.getPoint();
            super.refresh();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }
}

