/*
 * Decompiled with CFR 0.152.
 */
package glredbook12x;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.GLBuffers;
import glredbook10.GLSkeleton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class convolution
extends GLSkeleton<GLJPanel>
implements GLEventListener,
KeyListener {
    private JFrame frame;
    private KeyEvent key;
    private ByteBuffer pixels;
    private Dimension dim = new Dimension(0, 0);
    private float[][] horizontal = new float[][]{{0.0f, -1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
    private float[][] vertical = new float[][]{{0.0f, 0.0f, 0.0f}, {-1.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
    private float[][] laplacian = new float[][]{{-0.125f, -0.125f, -0.125f}, {-0.125f, 1.0f, -0.125f}, {-0.125f, -0.125f, -0.125f}};
    private FloatBuffer horizontalBuf = GLBuffers.newDirectFloatBuffer((int)(this.horizontal.length * this.horizontal[0].length));
    private FloatBuffer verticalBuf = GLBuffers.newDirectFloatBuffer((int)(this.vertical.length * this.vertical[0].length));
    private FloatBuffer laplacianBuf = GLBuffers.newDirectFloatBuffer((int)(this.laplacian.length * this.laplacian[0].length));

    public convolution() {
        for (int i = 0; i < 3; ++i) {
            this.horizontalBuf.put(this.horizontal[i]);
            this.verticalBuf.put(this.vertical[i]);
            this.laplacianBuf.put(this.laplacian[i]);
        }
        this.horizontalBuf.rewind();
        this.verticalBuf.rewind();
        this.laplacianBuf.rewind();
    }

    @Override
    protected GLJPanel createDrawable() {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        gLJPanel.addGLEventListener((GLEventListener)this);
        gLJPanel.addKeyListener((KeyListener)this);
        return gLJPanel;
    }

    protected void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public static void main(String[] stringArray) {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        convolution convolution2 = new convolution();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame("convolution");
        jFrame.setSize(640, 480);
        jFrame.setLocationRelativeTo(null);
        jFrame.setDefaultCloseOperation(3);
        convolution2.setFrame(jFrame);
        jFrame.getContentPane().add((Component)convolution2.drawable);
        jFrame.setVisible(true);
        ((GLJPanel)convolution2.drawable).requestFocusInWindow();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glPixelStorei(3317, 1);
        gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (gL2.isExtensionAvailable("GL_ARB_imaging")) {
            if (gL2.isFunctionAvailable("glConvolutionFilter2D")) {
                System.out.println("Using the horizontal filter");
                gL2.glConvolutionFilter2D(32785, 6409, 3, 3, 6409, 5126, (Buffer)this.horizontalBuf);
                gL2.glEnable(32785);
            }
        } else {
            this.frame.setTitle("convolution: NO ARB Imaging Subset");
            SwingUtilities.updateComponentTreeUI(this.frame);
        }
        if (this.pixels == null) {
            this.pixels = this.readImage("Data/leeds.bin", this.dim);
            System.out.println(this.pixels.toString());
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glClear(16384);
        if (gL2.isFunctionAvailable("glConvolutionFilter2D") && this.key != null) {
            switch (this.key.getKeyChar()) {
                case 'h': {
                    System.out.println("Using a horizontal filter");
                    gL2.glConvolutionFilter2D(32785, 6409, 3, 3, 6409, 5126, (Buffer)this.horizontalBuf);
                    break;
                }
                case 'v': {
                    System.out.println("Using the vertical filter\n");
                    gL2.glConvolutionFilter2D(32785, 6409, 3, 3, 6409, 5126, (Buffer)this.verticalBuf);
                    break;
                }
                case 'l': {
                    System.out.println("Using the laplacian filter\n");
                    gL2.glConvolutionFilter2D(32785, 6409, 3, 3, 6409, 5126, (Buffer)this.laplacianBuf);
                }
            }
        }
        gL2.glRasterPos2i(1, 1);
        gL2.glDrawPixels(this.dim.width, this.dim.height, 6407, 5121, (Buffer)this.pixels);
        gL2.glFlush();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        gL2.glViewport(0, 0, n3, n4);
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gL2.glOrtho(0.0, (double)n3, 0.0, (double)n4, -1.0, 1.0);
        gL2.glMatrixMode(5888);
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    private ByteBuffer readImage(String string, Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        ByteBuffer byteBuffer = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(this.getClass().getClassLoader().getResourceAsStream(string));
            dimension.width = dataInputStream.readInt();
            dimension.height = dataInputStream.readInt();
            System.out.println("Creating buffer, width: " + dimension.width + " height: " + dimension.height);
            byteBuffer = GLBuffers.newDirectByteBuffer((int)(3 * dimension.width * dimension.height));
            for (int i = 0; i < byteBuffer.capacity(); ++i) {
                byteBuffer.put(dataInputStream.readByte());
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.key = keyEvent;
        switch (keyEvent.getKeyCode()) {
            case 27: {
                System.exit(0);
            }
        }
        super.refresh();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }
}

