/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class FPSCounter {
    public static final int UPPER_LEFT = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int LOWER_LEFT = 3;
    public static final int LOWER_RIGHT = 4;
    private int textLocation = 4;
    private final GLDrawable drawable;
    private final TextRenderer renderer;
    private final DecimalFormat format = new DecimalFormat("####.00");
    private int frameCount;
    private long startTime;
    private String fpsText;
    private int fpsMagnitude;
    private int fpsWidth;
    private int fpsHeight;
    private int fpsOffset;

    public FPSCounter(GLDrawable gLDrawable, int n) throws GLException {
        this(gLDrawable, new Font("SansSerif", 1, n));
    }

    public FPSCounter(GLDrawable gLDrawable, Font font) throws GLException {
        this(gLDrawable, font, true, true);
    }

    public FPSCounter(GLDrawable gLDrawable, Font font, boolean bl, boolean bl2) throws GLException {
        this.drawable = gLDrawable;
        this.renderer = new TextRenderer(font, bl, bl2);
    }

    public int getTextLocation() {
        return this.textLocation;
    }

    public void setTextLocation(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("textLocation");
        }
        this.textLocation = n;
    }

    public void setColor(float f, float f2, float f3, float f4) throws GLException {
        this.renderer.setColor(f, f2, f3, f4);
    }

    public void draw() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        if (++this.frameCount >= 100) {
            long l = System.currentTimeMillis();
            float f = 100.0f / (float)(l - this.startTime) * 1000.0f;
            this.recomputeFPSSize(f);
            this.frameCount = 0;
            this.startTime = System.currentTimeMillis();
            this.fpsText = "FPS: " + this.format.format(f);
        }
        if (this.fpsText != null) {
            this.renderer.beginRendering(this.drawable.getSurfaceWidth(), this.drawable.getSurfaceHeight());
            int n = 0;
            int n2 = 0;
            switch (this.textLocation) {
                case 1: {
                    n = this.fpsOffset;
                    n2 = this.drawable.getSurfaceHeight() - this.fpsHeight - this.fpsOffset;
                    break;
                }
                case 2: {
                    n = this.drawable.getSurfaceWidth() - this.fpsWidth - this.fpsOffset;
                    n2 = this.drawable.getSurfaceHeight() - this.fpsHeight - this.fpsOffset;
                    break;
                }
                case 3: {
                    n = this.fpsOffset;
                    n2 = this.fpsOffset;
                    break;
                }
                case 4: {
                    n = this.drawable.getSurfaceWidth() - this.fpsWidth - this.fpsOffset;
                    n2 = this.fpsOffset;
                }
            }
            this.renderer.draw(this.fpsText, n, n2);
            this.renderer.endRendering();
        }
    }

    private void recomputeFPSSize(float f) {
        int n;
        String string;
        if (f >= 10000.0f) {
            string = "10000.00";
            n = 5;
        } else if (f >= 1000.0f) {
            string = "1000.00";
            n = 4;
        } else if (f >= 100.0f) {
            string = "100.00";
            n = 3;
        } else if (f >= 10.0f) {
            string = "10.00";
            n = 2;
        } else {
            string = "9.00";
            n = 1;
        }
        if (n > this.fpsMagnitude) {
            Rectangle2D rectangle2D = this.renderer.getBounds("FPS: " + string);
            this.fpsWidth = (int)rectangle2D.getWidth();
            this.fpsHeight = (int)rectangle2D.getHeight();
            this.fpsOffset = (int)((float)this.fpsHeight * 0.5f);
            this.fpsMagnitude = n;
        }
    }
}

