/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

public class FloatList {
    private static final int DEFAULT_SIZE = 10;
    private float[] data = new float[10];
    private int numElements;

    public void add(float f) {
        if (this.numElements == this.data.length) {
            this.resize(1 + this.numElements);
        }
        this.data[this.numElements++] = f;
        assert (this.numElements <= this.data.length);
    }

    public int size() {
        return this.numElements;
    }

    public float get(int n) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void put(int n, float f) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.data[n] = f;
    }

    public void trim() {
        if (this.data.length > this.numElements) {
            float[] fArray = new float[this.numElements];
            System.arraycopy(this.data, 0, fArray, 0, this.numElements);
            this.data = fArray;
        }
    }

    public float[] getData() {
        return this.data;
    }

    private void resize(int n) {
        int n2 = 2 * this.data.length;
        if (n2 == 0) {
            n2 = 10;
        }
        if (n2 < n) {
            n2 = n;
        }
        float[] fArray = new float[n2];
        System.arraycopy(this.data, 0, fArray, 0, this.data.length);
        this.data = fArray;
    }
}

