/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

public class IntList {
    private static final int DEFAULT_SIZE = 10;
    private int[] data = new int[10];
    private int numElements;

    public void add(int n) {
        if (this.numElements == this.data.length) {
            this.resize(1 + this.numElements);
        }
        this.data[this.numElements++] = n;
        assert (this.numElements <= this.data.length);
    }

    public int size() {
        return this.numElements;
    }

    public int get(int n) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void put(int n, int n2) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.data[n] = n2;
    }

    public void trim() {
        if (this.data.length > this.numElements) {
            int[] nArray = new int[this.numElements];
            System.arraycopy(this.data, 0, nArray, 0, this.numElements);
            this.data = nArray;
        }
    }

    public int[] getData() {
        return this.data;
    }

    private void resize(int n) {
        int n2 = 2 * this.data.length;
        if (n2 == 0) {
            n2 = 10;
        }
        if (n2 < n) {
            n2 = n;
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.data, 0, nArray, 0, this.data.length);
        this.data = nArray;
    }
}

