/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class MD2 {
    private static final float[] normalTable = new float[]{-0.525731f, 0.0f, 0.850651f, -0.442863f, 0.238856f, 0.864188f, -0.295242f, 0.0f, 0.955423f, -0.309017f, 0.5f, 0.809017f, -0.16246f, 0.262866f, 0.951056f, 0.0f, 0.0f, 1.0f, 0.0f, 0.850651f, 0.525731f, -0.147621f, 0.716567f, 0.681718f, 0.147621f, 0.716567f, 0.681718f, 0.0f, 0.525731f, 0.850651f, 0.309017f, 0.5f, 0.809017f, 0.525731f, 0.0f, 0.850651f, 0.295242f, 0.0f, 0.955423f, 0.442863f, 0.238856f, 0.864188f, 0.16246f, 0.262866f, 0.951056f, -0.681718f, 0.147621f, 0.716567f, -0.809017f, 0.309017f, 0.5f, -0.587785f, 0.425325f, 0.688191f, -0.850651f, 0.525731f, 0.0f, -0.864188f, 0.442863f, 0.238856f, -0.716567f, 0.681718f, 0.147621f, -0.688191f, 0.587785f, 0.425325f, -0.5f, 0.809017f, 0.309017f, -0.238856f, 0.864188f, 0.442863f, -0.425325f, 0.688191f, 0.587785f, -0.716567f, 0.681718f, -0.147621f, -0.5f, 0.809017f, -0.309017f, -0.525731f, 0.850651f, 0.0f, 0.0f, 0.850651f, -0.525731f, -0.238856f, 0.864188f, -0.442863f, 0.0f, 0.955423f, -0.295242f, -0.262866f, 0.951056f, -0.16246f, 0.0f, 1.0f, 0.0f, 0.0f, 0.955423f, 0.295242f, -0.262866f, 0.951056f, 0.16246f, 0.238856f, 0.864188f, 0.442863f, 0.262866f, 0.951056f, 0.16246f, 0.5f, 0.809017f, 0.309017f, 0.238856f, 0.864188f, -0.442863f, 0.262866f, 0.951056f, -0.16246f, 0.5f, 0.809017f, -0.309017f, 0.850651f, 0.525731f, 0.0f, 0.716567f, 0.681718f, 0.147621f, 0.716567f, 0.681718f, -0.147621f, 0.525731f, 0.850651f, 0.0f, 0.425325f, 0.688191f, 0.587785f, 0.864188f, 0.442863f, 0.238856f, 0.688191f, 0.587785f, 0.425325f, 0.809017f, 0.309017f, 0.5f, 0.681718f, 0.147621f, 0.716567f, 0.587785f, 0.425325f, 0.688191f, 0.955423f, 0.295242f, 0.0f, 1.0f, 0.0f, 0.0f, 0.951056f, 0.16246f, 0.262866f, 0.850651f, -0.525731f, 0.0f, 0.955423f, -0.295242f, 0.0f, 0.864188f, -0.442863f, 0.238856f, 0.951056f, -0.16246f, 0.262866f, 0.809017f, -0.309017f, 0.5f, 0.681718f, -0.147621f, 0.716567f, 0.850651f, 0.0f, 0.525731f, 0.864188f, 0.442863f, -0.238856f, 0.809017f, 0.309017f, -0.5f, 0.951056f, 0.16246f, -0.262866f, 0.525731f, 0.0f, -0.850651f, 0.681718f, 0.147621f, -0.716567f, 0.681718f, -0.147621f, -0.716567f, 0.850651f, 0.0f, -0.525731f, 0.809017f, -0.309017f, -0.5f, 0.864188f, -0.442863f, -0.238856f, 0.951056f, -0.16246f, -0.262866f, 0.147621f, 0.716567f, -0.681718f, 0.309017f, 0.5f, -0.809017f, 0.425325f, 0.688191f, -0.587785f, 0.442863f, 0.238856f, -0.864188f, 0.587785f, 0.425325f, -0.688191f, 0.688191f, 0.587785f, -0.425325f, -0.147621f, 0.716567f, -0.681718f, -0.309017f, 0.5f, -0.809017f, 0.0f, 0.525731f, -0.850651f, -0.525731f, 0.0f, -0.850651f, -0.442863f, 0.238856f, -0.864188f, -0.295242f, 0.0f, -0.955423f, -0.16246f, 0.262866f, -0.951056f, 0.0f, 0.0f, -1.0f, 0.295242f, 0.0f, -0.955423f, 0.16246f, 0.262866f, -0.951056f, -0.442863f, -0.238856f, -0.864188f, -0.309017f, -0.5f, -0.809017f, -0.16246f, -0.262866f, -0.951056f, 0.0f, -0.850651f, -0.525731f, -0.147621f, -0.716567f, -0.681718f, 0.147621f, -0.716567f, -0.681718f, 0.0f, -0.525731f, -0.850651f, 0.309017f, -0.5f, -0.809017f, 0.442863f, -0.238856f, -0.864188f, 0.16246f, -0.262866f, -0.951056f, 0.238856f, -0.864188f, -0.442863f, 0.5f, -0.809017f, -0.309017f, 0.425325f, -0.688191f, -0.587785f, 0.716567f, -0.681718f, -0.147621f, 0.688191f, -0.587785f, -0.425325f, 0.587785f, -0.425325f, -0.688191f, 0.0f, -0.955423f, -0.295242f, 0.0f, -1.0f, 0.0f, 0.262866f, -0.951056f, -0.16246f, 0.0f, -0.850651f, 0.525731f, 0.0f, -0.955423f, 0.295242f, 0.238856f, -0.864188f, 0.442863f, 0.262866f, -0.951056f, 0.16246f, 0.5f, -0.809017f, 0.309017f, 0.716567f, -0.681718f, 0.147621f, 0.525731f, -0.850651f, 0.0f, -0.238856f, -0.864188f, -0.442863f, -0.5f, -0.809017f, -0.309017f, -0.262866f, -0.951056f, -0.16246f, -0.850651f, -0.525731f, 0.0f, -0.716567f, -0.681718f, -0.147621f, -0.716567f, -0.681718f, 0.147621f, -0.525731f, -0.850651f, 0.0f, -0.5f, -0.809017f, 0.309017f, -0.238856f, -0.864188f, 0.442863f, -0.262866f, -0.951056f, 0.16246f, -0.864188f, -0.442863f, 0.238856f, -0.809017f, -0.309017f, 0.5f, -0.688191f, -0.587785f, 0.425325f, -0.681718f, -0.147621f, 0.716567f, -0.442863f, -0.238856f, 0.864188f, -0.587785f, -0.425325f, 0.688191f, -0.309017f, -0.5f, 0.809017f, -0.147621f, -0.716567f, 0.681718f, -0.425325f, -0.688191f, 0.587785f, -0.16246f, -0.262866f, 0.951056f, 0.442863f, -0.238856f, 0.864188f, 0.16246f, -0.262866f, 0.951056f, 0.309017f, -0.5f, 0.809017f, 0.147621f, -0.716567f, 0.681718f, 0.0f, -0.525731f, 0.850651f, 0.425325f, -0.688191f, 0.587785f, 0.587785f, -0.425325f, 0.688191f, 0.688191f, -0.587785f, 0.425325f, -0.955423f, 0.295242f, 0.0f, -0.951056f, 0.16246f, 0.262866f, -1.0f, 0.0f, 0.0f, -0.850651f, 0.0f, 0.525731f, -0.955423f, -0.295242f, 0.0f, -0.951056f, -0.16246f, 0.262866f, -0.864188f, 0.442863f, -0.238856f, -0.951056f, 0.16246f, -0.262866f, -0.809017f, 0.309017f, -0.5f, -0.864188f, -0.442863f, -0.238856f, -0.951056f, -0.16246f, -0.262866f, -0.809017f, -0.309017f, -0.5f, -0.681718f, 0.147621f, -0.716567f, -0.681718f, -0.147621f, -0.716567f, -0.850651f, 0.0f, -0.525731f, -0.688191f, 0.587785f, -0.425325f, -0.587785f, 0.425325f, -0.688191f, -0.425325f, 0.688191f, -0.587785f, -0.425325f, -0.688191f, -0.587785f, -0.587785f, -0.425325f, -0.688191f, -0.688191f, -0.587785f, -0.425325f};

    public static Model loadMD2(String string) throws IOException {
        ArrayList arrayList = new ArrayList();
        MD2.loadFrames(string, arrayList);
        return MD2.computeModel(arrayList);
    }

    public static Model loadMD2(InputStream inputStream) throws IOException {
        ArrayList arrayList = new ArrayList();
        MD2.loadFrames(inputStream, arrayList);
        return MD2.computeModel(arrayList);
    }

    public static void computePlane(PositionNormal positionNormal, PositionNormal positionNormal2, PositionNormal positionNormal3, Plane plane) {
        float[] fArray = new float[]{positionNormal2.x - positionNormal.x, positionNormal2.y - positionNormal.y, positionNormal2.z - positionNormal.z};
        float[] fArray2 = new float[]{positionNormal3.x - positionNormal.x, positionNormal3.y - positionNormal.y, positionNormal3.z - positionNormal.z};
        float[] fArray3 = new float[]{fArray[1] * fArray2[2] - fArray[2] * fArray2[1], fArray[2] * fArray2[0] - fArray[0] * fArray2[2], fArray[0] * fArray2[1] - fArray[1] * fArray2[0]};
        float f = (float)Math.sqrt(fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1] + fArray3[2] * fArray3[2]);
        if (f == 0.0f) {
            plane.d = 0.0f;
            plane.c = 0.0f;
            plane.b = 0.0f;
            plane.a = 0.0f;
            return;
        }
        plane.a = fArray3[0] / f;
        plane.b = fArray3[1] / f;
        plane.c = fArray3[2] / f;
        plane.d = -(plane.a * positionNormal.x + plane.b * positionNormal.y + plane.c * positionNormal.z);
    }

    private static Model computeModel(List list) throws IOException {
        if (!MD2.compareFrames(list)) {
            throw new IOException("unsuitable model -- frames aren't same");
        }
        Model model = new Model();
        model.tri = ((IFrame)list.get((int)0)).tri;
        model.f = new Frame[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Frame frame;
            model.f[i] = frame = new Frame();
            IFrame iFrame = (IFrame)list.get(i);
            frame.pn = iFrame.pn;
            MD2.computeFramePlanes(model.tri, frame);
        }
        MD2.computeWingedEdges(model);
        return model;
    }

    private static void loadFrames(String string, List list) throws IOException {
        FileModel fileModel = MD2.loadMD2File(string);
        MD2.computeFrames(fileModel, list);
    }

    private static void loadFrames(InputStream inputStream, List list) throws IOException {
        FileModel fileModel = MD2.loadMD2File(inputStream);
        MD2.computeFrames(fileModel, list);
    }

    private static void computeFrames(FileModel fileModel, List list) throws IOException {
        for (int i = 0; i < fileModel.frames.length; ++i) {
            int n;
            Object object;
            IFrame iFrame = new IFrame();
            list.add(iFrame);
            FileFrame fileFrame = fileModel.frames[i];
            iFrame.pn = new PositionNormal[fileFrame.verts.length];
            for (int j = 0; j < fileFrame.verts.length; ++j) {
                object = new PositionNormal();
                ((PositionNormal)object).x = ((float)(fileFrame.verts[j].v[0] & 0xFF) * fileFrame.scale[0] + fileFrame.translate[0]) * 0.025f;
                ((PositionNormal)object).y = ((float)(fileFrame.verts[j].v[1] & 0xFF) * fileFrame.scale[1] + fileFrame.translate[1]) * 0.025f;
                ((PositionNormal)object).z = ((float)(fileFrame.verts[j].v[2] & 0xFF) * fileFrame.scale[2] + fileFrame.translate[2]) * 0.025f;
                n = fileFrame.verts[j].lightnormalindex & 0xFF;
                ((PositionNormal)object).nx = normalTable[3 * n + 0];
                ((PositionNormal)object).ny = normalTable[3 * n + 1];
                ((PositionNormal)object).nz = normalTable[3 * n + 2];
                iFrame.pn[j] = object;
            }
            ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
            object = new int[1];
            while (fileModel.glcmds[object[0]] != 0) {
                Object object2;
                Object object3;
                boolean bl;
                if (fileModel.glcmds[object[0]] > 0) {
                    Object object4 = object;
                    Object object5 = object4[0];
                    object4[0] = object5 + true;
                    n = fileModel.glcmds[object5];
                    bl = true;
                } else {
                    Object object6 = object;
                    Object object7 = object6[0];
                    object6[0] = object7 + true;
                    n = -fileModel.glcmds[object7];
                    bl = false;
                }
                if (bl) {
                    object3 = new Vertex[]{MD2.extractVertex(fileModel.glcmds, (int[])object), MD2.extractVertex(fileModel.glcmds, (int[])object)};
                    for (int j = 2; j < n; ++j) {
                        Triangle triangle = new Triangle();
                        if (j % 2 == 0) {
                            triangle.v[0] = object3[0];
                            triangle.v[1] = object3[1];
                            triangle.v[2] = MD2.extractVertex(fileModel.glcmds, (int[])object);
                            object3[0] = triangle.v[2];
                        } else {
                            triangle.v[0] = object3[1];
                            triangle.v[1] = MD2.extractVertex(fileModel.glcmds, (int[])object);
                            triangle.v[2] = object3[0];
                            object3[1] = triangle.v[1];
                        }
                        object2 = triangle.v[1];
                        triangle.v[1] = triangle.v[2];
                        triangle.v[2] = object2;
                        arrayList.add(triangle);
                    }
                    continue;
                }
                object3 = MD2.extractVertex(fileModel.glcmds, (int[])object);
                Vertex vertex = MD2.extractVertex(fileModel.glcmds, (int[])object);
                for (int j = 2; j < n; ++j) {
                    object2 = new Triangle();
                    ((Triangle)object2).v[0] = object3;
                    ((Triangle)object2).v[1] = vertex;
                    ((Triangle)object2).v[2] = MD2.extractVertex(fileModel.glcmds, (int[])object);
                    vertex = ((Triangle)object2).v[2];
                    Vertex vertex2 = ((Triangle)object2).v[1];
                    ((Triangle)object2).v[1] = ((Triangle)object2).v[2];
                    ((Triangle)object2).v[2] = vertex2;
                    arrayList.add((Triangle)object2);
                }
            }
            iFrame.tri = arrayList.toArray(new Triangle[0]);
        }
    }

    private static FileModel loadMD2File(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        FileModel fileModel = new FileModel();
        FileHeader fileHeader = MD2.readHeader(byteBuffer);
        byteBuffer.position(fileHeader.ofs_frames);
        MD2.readFrames(byteBuffer, fileHeader, fileModel);
        byteBuffer.position(fileHeader.ofs_glcmds);
        MD2.readGLCommands(byteBuffer, fileHeader, fileModel);
        return fileModel;
    }

    private static FileModel loadMD2File(InputStream inputStream) throws IOException {
        Object object;
        inputStream = new BufferedInputStream(inputStream);
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        do {
            if (n3 + n > byArray.length) {
                object = new byte[n3 + n];
                System.arraycopy(byArray, 0, object, 0, n3);
                byArray = object;
            }
            if ((n2 = inputStream.read(byArray, n3, n)) < 0) continue;
            n3 += n2;
        } while ((n = inputStream.available()) > 0 && n2 >= 0);
        object = ByteBuffer.allocateDirect(n3);
        ((ByteBuffer)object).put(byArray, 0, n3);
        ((ByteBuffer)object).rewind();
        return MD2.loadMD2File((ByteBuffer)object);
    }

    private static FileModel loadMD2File(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileInputStream.available());
        FileModel fileModel = MD2.loadMD2File(mappedByteBuffer);
        fileChannel.close();
        fileInputStream.close();
        return fileModel;
    }

    private static FileHeader readHeader(ByteBuffer byteBuffer) {
        FileHeader fileHeader = new FileHeader();
        fileHeader.ident = byteBuffer.getInt();
        fileHeader.version = byteBuffer.getInt();
        fileHeader.skinwidth = byteBuffer.getInt();
        fileHeader.skinheight = byteBuffer.getInt();
        fileHeader.framesize = byteBuffer.getInt();
        fileHeader.num_skins = byteBuffer.getInt();
        fileHeader.num_xyz = byteBuffer.getInt();
        fileHeader.num_st = byteBuffer.getInt();
        fileHeader.num_tris = byteBuffer.getInt();
        fileHeader.num_glcmds = byteBuffer.getInt();
        fileHeader.num_frames = byteBuffer.getInt();
        fileHeader.ofs_skins = byteBuffer.getInt();
        fileHeader.ofs_st = byteBuffer.getInt();
        fileHeader.ofs_tris = byteBuffer.getInt();
        fileHeader.ofs_frames = byteBuffer.getInt();
        fileHeader.ofs_glcmds = byteBuffer.getInt();
        fileHeader.ofs_end = byteBuffer.getInt();
        return fileHeader;
    }

    private static int numVerts(int n) {
        return (n >> 2) - 10;
    }

    private static void readFrames(ByteBuffer byteBuffer, FileHeader fileHeader, FileModel fileModel) throws IOException {
        int n = fileHeader.num_frames;
        int n2 = fileHeader.framesize;
        int n3 = MD2.numVerts(n2);
        FileFrame[] fileFrameArray = new FileFrame[n];
        byte[] byArray = new byte[16];
        for (int i = 0; i < n; ++i) {
            FileFrame fileFrame = new FileFrame();
            fileFrame.scale[0] = byteBuffer.getFloat();
            fileFrame.scale[1] = byteBuffer.getFloat();
            fileFrame.scale[2] = byteBuffer.getFloat();
            fileFrame.translate[0] = byteBuffer.getFloat();
            fileFrame.translate[1] = byteBuffer.getFloat();
            fileFrame.translate[2] = byteBuffer.getFloat();
            byteBuffer.get(byArray);
            try {
                fileFrame.name = new String(byArray, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IOException(unsupportedEncodingException.toString());
            }
            fileFrame.verts = new FileCompressedVertex[n3];
            for (int j = 0; j < n3; ++j) {
                FileCompressedVertex fileCompressedVertex = new FileCompressedVertex();
                byteBuffer.get(fileCompressedVertex.v);
                fileCompressedVertex.lightnormalindex = byteBuffer.get();
                fileFrame.verts[j] = fileCompressedVertex;
            }
            fileFrameArray[i] = fileFrame;
        }
        fileModel.frames = fileFrameArray;
    }

    private static void readGLCommands(ByteBuffer byteBuffer, FileHeader fileHeader, FileModel fileModel) {
        int n = fileHeader.num_glcmds;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        fileModel.glcmds = nArray;
    }

    private static Vertex extractVertex(int[] nArray, int[] nArray2) {
        Vertex vertex = new Vertex();
        int n = nArray2[0];
        nArray2[0] = n + 1;
        vertex.tc.s = Float.intBitsToFloat(nArray[n]);
        int n2 = nArray2[0];
        nArray2[0] = n2 + 1;
        vertex.tc.t = Float.intBitsToFloat(nArray[n2]);
        int n3 = nArray2[0];
        nArray2[0] = n3 + 1;
        vertex.pn_index = nArray[n3];
        return vertex;
    }

    private static boolean compareFrames(List list) {
        IFrame iFrame = (IFrame)list.get(0);
        boolean bl = true;
        boolean bl2 = true;
        for (int i = 1; i < list.size(); ++i) {
            IFrame iFrame2 = (IFrame)list.get(i);
            if (iFrame2.pn.length != iFrame.pn.length) {
                System.err.println("pn size different for iframe " + i + " :  " + iFrame.pn.length + " != " + iFrame2.pn.length);
                bl = false;
            }
            if (iFrame2.tri.length != iFrame.tri.length) {
                System.err.println("tri size different for iframe " + i + " :  " + iFrame.tri.length + " != " + iFrame2.tri.length);
                bl = false;
            }
            if (!bl) continue;
            for (int j = 0; j < iFrame2.tri.length; ++j) {
                Triangle triangle = iFrame.tri[j];
                Triangle triangle2 = iFrame2.tri[j];
                for (int k = 0; k < 3; ++k) {
                    if (triangle.v[k].pn_index != triangle2.v[k].pn_index) {
                        System.err.println("tri " + j + " triangle pn_index " + k + " different!");
                        bl = false;
                    }
                    if (triangle.v[k].tc.s == triangle2.v[k].tc.s && triangle.v[k].tc.t == triangle2.v[k].tc.t) continue;
                    System.err.println("tri " + j + " triangle tc " + k + " different!");
                    bl2 = false;
                }
            }
        }
        return bl && bl2;
    }

    private static void computeFramePlanes(Triangle[] triangleArray, Frame frame) {
        frame.triplane = new Plane[triangleArray.length];
        for (int i = 0; i < triangleArray.length; ++i) {
            Triangle triangle = triangleArray[i];
            int n = triangle.v[0].pn_index;
            int n2 = triangle.v[1].pn_index;
            int n3 = triangle.v[2].pn_index;
            Plane plane = new Plane();
            MD2.computePlane(frame.pn[n], frame.pn[n2], frame.pn[n3], plane);
            frame.triplane[i] = plane;
        }
    }

    private static int computeWingedEdges(Model model) {
        int n;
        Triangle[] triangleArray = model.tri;
        ArrayList arrayList = new ArrayList();
        int n2 = triangleArray.length;
        for (n = 0; n < n2; ++n) {
            Triangle triangle = triangleArray[n];
            for (int i = 0; i < 3; ++i) {
                WingedEdge wingedEdge = new WingedEdge();
                wingedEdge.e[0] = triangle.v[i].pn_index;
                wingedEdge.e[1] = triangle.v[(i + 1) % 3].pn_index;
                wingedEdge.w[0] = n;
                wingedEdge.w[1] = -1;
                MD2.addEdge(arrayList, wingedEdge);
            }
        }
        n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((WingedEdge)arrayList.get((int)i)).w[1] != -1) continue;
            ++n;
        }
        model.edge = arrayList.toArray(new WingedEdge[0]);
        return n;
    }

    private static void addEdge(List list, WingedEdge wingedEdge) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            WingedEdge wingedEdge2 = (WingedEdge)list.get(i);
            if (wingedEdge2.e[0] == wingedEdge.e[0] && wingedEdge2.e[1] == wingedEdge.e[1]) {
                System.err.println("facingness different between polys on edge!");
            }
            if (wingedEdge2.e[0] != wingedEdge.e[1] || wingedEdge2.e[1] != wingedEdge.e[0]) continue;
            if (wingedEdge2.w[1] != -1) {
                System.err.println("triple edge! bad...");
            }
            wingedEdge2.w[1] = wingedEdge.w[0];
            return;
        }
        list.add(wingedEdge);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Model model = MD2.loadMD2(stringArray[i]);
                System.err.println("Successfully parsed " + stringArray[i]);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error parsing " + stringArray[i] + ":");
                iOException.printStackTrace();
            }
        }
    }

    public static class Model {
        public Frame[] f;
        public Triangle[] tri;
        public WingedEdge[] edge;
    }

    public static class PositionNormal
    implements Cloneable {
        public float x;
        public float y;
        public float z;
        public float nx;
        public float ny;
        public float nz;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
    }

    public static class Plane
    implements Cloneable {
        public float a;
        public float b;
        public float c;
        public float d;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
    }

    private static class IFrame {
        PositionNormal[] pn;
        Triangle[] tri;

        private IFrame() {
        }
    }

    public static class Triangle {
        public Vertex[] v = new Vertex[3];
        public boolean kill;
    }

    public static class Frame
    implements Cloneable {
        public PositionNormal[] pn;
        public Plane[] triplane;

        public Object clone() {
            int n;
            Frame frame = new Frame();
            frame.pn = new PositionNormal[this.pn.length];
            for (n = 0; n < this.pn.length; ++n) {
                frame.pn[n] = (PositionNormal)this.pn[n].clone();
            }
            frame.triplane = new Plane[this.triplane.length];
            for (n = 0; n < this.triplane.length; ++n) {
                frame.triplane[n] = (Plane)this.triplane[n].clone();
            }
            return frame;
        }
    }

    public static class FileModel {
        public int[] glcmds;
        public FileFrame[] frames;
    }

    public static class FileFrame {
        public float[] scale = new float[3];
        public float[] translate = new float[3];
        public String name;
        public FileCompressedVertex[] verts;
    }

    public static class FileCompressedVertex {
        public byte[] v = new byte[3];
        public byte lightnormalindex;
    }

    public static class Vertex {
        public int pn_index;
        public TexCoord tc = new TexCoord();
    }

    public static class FileHeader {
        public int ident;
        public int version;
        public int skinwidth;
        public int skinheight;
        public int framesize;
        public int num_skins;
        public int num_xyz;
        public int num_st;
        public int num_tris;
        public int num_glcmds;
        public int num_frames;
        public int ofs_skins;
        public int ofs_st;
        public int ofs_tris;
        public int ofs_frames;
        public int ofs_glcmds;
        public int ofs_end;
    }

    public static class TexCoord {
        public float s;
        public float t;
    }

    public static class WingedEdge {
        public int[] e = new int[2];
        public int[] w = new int[2];
    }
}

