/*
 * Decompiled with CFR 0.152.
 */
package demos.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ScreenResSelector {
    public static List getAvailableDisplayModes() {
        List list = ScreenResSelector.getDisplayModes();
        final DisplayMode displayMode = ScreenResSelector.getCurrentDisplayMode();
        list = ScreenResSelector.filterDisplayModes(list, new DisplayModeFilter(){

            @Override
            public boolean filter(DisplayMode displayMode2) {
                return displayMode2.getRefreshRate() <= displayMode.getRefreshRate();
            }
        });
        list = ScreenResSelector.filterDisplayModes(list, new DisplayModeFilter(){

            @Override
            public boolean filter(DisplayMode displayMode) {
                return displayMode.getBitDepth() < 0 || displayMode.getBitDepth() >= 24;
            }
        });
        if ((list = ScreenResSelector.filterDisplayModes(list, new DisplayModeFilter(){

            @Override
            public boolean filter(DisplayMode displayMode) {
                return displayMode.getWidth() >= 640 && displayMode.getHeight() >= 480;
            }
        })).size() == 0) {
            throw new RuntimeException("Couldn't find any valid display modes");
        }
        return list;
    }

    public static DisplayMode showSelectionDialog() {
        SelectionDialog selectionDialog = new SelectionDialog();
        selectionDialog.setVisible(true);
        selectionDialog.waitFor();
        return selectionDialog.selected();
    }

    public static void main(String[] stringArray) {
        DisplayMode displayMode = ScreenResSelector.showSelectionDialog();
        if (displayMode != null) {
            System.err.println("Selected display mode:");
            System.err.println(ScreenResSelector.modeToString(displayMode));
        } else {
            System.err.println("No display mode selected.");
        }
        System.exit(0);
    }

    private static DisplayMode getCurrentDisplayMode() {
        GraphicsDevice graphicsDevice = ScreenResSelector.getDefaultScreenDevice();
        return graphicsDevice.getDisplayMode();
    }

    private static List getDisplayModes() {
        GraphicsDevice graphicsDevice = ScreenResSelector.getDefaultScreenDevice();
        DisplayMode[] displayModeArray = graphicsDevice.getDisplayModes();
        return ScreenResSelector.toList(displayModeArray);
    }

    private static GraphicsDevice getDefaultScreenDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    private static List toList(DisplayMode[] displayModeArray) {
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        for (int i = 0; i < displayModeArray.length; ++i) {
            arrayList.add(displayModeArray[i]);
        }
        return arrayList;
    }

    private static String modeToString(DisplayMode displayMode) {
        return (displayMode.getBitDepth() > 0 ? displayMode.getBitDepth() + " bits, " : "") + displayMode.getWidth() + "x" + displayMode.getHeight() + ", " + displayMode.getRefreshRate() + " Hz";
    }

    private static String[] modesToString(List list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = ScreenResSelector.modeToString((DisplayMode)iterator.next());
        }
        return stringArray;
    }

    private static List filterDisplayModes(List list, DisplayModeFilter displayModeFilter) {
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        for (DisplayMode displayMode : list) {
            if (!displayModeFilter.filter(displayMode)) continue;
            arrayList.add(displayMode);
        }
        return arrayList;
    }

    private static void center(Component component, Dimension dimension) {
        Dimension dimension2 = component.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        component.setLocation(n, n2);
    }

    static interface DisplayModeFilter {
        public boolean filter(DisplayMode var1);
    }

    static class SelectionDialog
    extends JFrame {
        private Object monitor = new Object();
        private List modes;
        private volatile boolean done = false;
        private volatile int selectedIndex;

        public SelectionDialog() {
            this.setTitle("Display Modes");
            this.modes = ScreenResSelector.getAvailableDisplayModes();
            String[] stringArray = ScreenResSelector.modesToString(this.modes);
            final JList<String> jList = new JList<String>(stringArray);
            jList.setSelectionMode(0);
            jList.setSelectedIndex(0);
            JScrollPane jScrollPane = new JScrollPane(jList);
            this.getContentPane().setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JLabel("Select full-screen display mode,"), "North");
            jPanel.add((Component)new JLabel("or Cancel for windowed mode:"), "Center");
            this.getContentPane().add("North", jPanel);
            this.getContentPane().add("Center", jScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createGlue());
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    selectedIndex = jList.getSelectedIndex();
                    done = true;
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                    this.setVisible(false);
                    this.dispose();
                }
            });
            jPanel2.add(jButton);
            jPanel2.add(Box.createHorizontalStrut(10));
            jButton = new JButton("Cancel");
            jButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    selectedIndex = -1;
                    done = true;
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                    this.setVisible(false);
                    this.dispose();
                }
            });
            jPanel2.add(jButton);
            jPanel2.add(Box.createGlue());
            this.getContentPane().add("South", jPanel2);
            this.setSize(300, 200);
            ScreenResSelector.center(this, Toolkit.getDefaultToolkit().getScreenSize());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() {
            Object object = this.monitor;
            synchronized (object) {
                while (!this.done) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public DisplayMode selected() {
            if (this.selectedIndex < 0) {
                return null;
            }
            return (DisplayMode)this.modes.get(this.selectedIndex);
        }
    }
}

